/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.Activities;
import com.digiwin.athena.kg.activity.ActivityBaseInfoVO;
import com.digiwin.athena.kg.activity.ActivityVO;
import com.digiwin.athena.kg.activity.Language;
import com.digiwin.athena.knowledgegraph.domain.ActivityData;
import com.digiwin.athena.knowledgegraph.domain.ActivityOld;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityInputData;
import java.util.List;
import java.util.Optional;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface ActivityRepository
extends Neo4jRepository<ActivityOld, Long> {
    @Query(value="MATCH (task:Task)-[:Contains]->(activity:Activity) where task.code = $0 and activity.code = $1 return activity")
    public ActivityOld getActivityByCode(String var1, String var2);

    @Query(value="MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 return activity")
    public ActivityOld getActivityByCodeAndVersion(String var1, String var2);

    @Query(value="MATCH(task:Task{version:$2,code:$1})-[:Contains]->(activity:Activity) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return activity.code")
    public List<String> getActivityCodes(String var1, String var2, String var3);

    @Query(value="MATCH (task:Task{code:$0})-[:Contains]->(activity:Activity{code:$1})-[:TRANSLATION]->(language:Language) return language")
    public List<Language> getActivityLanguageByCode(String var1, String var2);

    @Query(value="MATCH (task:Task{code:$1,version:$3})-[:Contains]->(t:Activity {code:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    public Optional<ActivityInputData> getActivityInputData(String var1, String var2, String var3, String var4);

    @Query(value="MATCH (task:Task{version:$2})-[:Contains]->(t:Activity {code:$1})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    public Optional<ActivityInputData> getActivityInputData(String var1, String var2, String var3);

    @Query(value="MATCH (sp:SolvePlan)-[:TroubleShoot]->(de:DataEntity) MATCH (sp)-[:Instance]->(aSet:ActivitySet) WHERE sp.planId = $0 and de.name = $1 and sp.version = $2 RETURN aSet.activities as activities")
    public Activities getActivitySetByPlanId(String var1, String var2, String var3);

    @Query(value="MATCH (task:Task{code:$0})-[:TRANSLATION]->(language:Language) return language")
    public List<Language> getTaskLanguageByCode(String var1);

    @Query(value="MATCH (task:Task{code:$0})-[:Achieves]->(target:TaskTarget)-[:TRANSLATION]->(language:Language) return language")
    public List<Language> getTargetLanguageByCode(String var1);

    @Query(value="MATCH (task:Task)-[:Contains]->(activity:CustomizationActivity {level:'tenant',levelId:$3,type:'add'}) where task.code = $0 and activity.code = $1 OPTIONAL MATCH (activity)-[:TRANSLATION]->(language:Language {locale:$2}) return activity, language")
    public ActivityData getAddedCustomByCode(String var1, String var2, String var3, String var4);

    @Query(value="MATCH (n:Activity) WHERE n.code in $0 and n.version = $2 and (n.tenantId in ['SYSTEM',$3] or n.tenantId is null or $3 in n.inclusionTenant)OPTIONAL MATCH (n)-[:TRANSLATION]->(lang:Language {locale:$1}) RETURN n.code AS activityId, n.sourceLevel as sourceLevel, n.tenantId as tenantId,CASE WHEN lang.name is null THEN n.name ELSE lang.name END AS activityName ")
    public List<ActivityVO> getActivitySetByIds(List<String> var1, String var2, String var3, String var4);

    @Query(value="match (t:Task{version:$3})-[:Contains]->(a:Activity) where t.code in $0 and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null) and (t.hideDeliverySetting is null or  t.hideDeliverySetting  = false) and a.category = \"APPROVAL\" return t.code as taskId,a.allowSubLevel as allowSubLevel,a.needEnableApprove as needEnableApprove, case when $2 = 'zh_CN' then  coalesce(t.`lang.name.zh_CN`, t.name) when $2 = 'zh_TW' then coalesce(t.`lang.name.zh_TW`, t.name) else  coalesce(t.`lang.name.en_US`, t.name) end as taskName, a.code as activityId, case when $2 = 'zh_CN' then  coalesce(a.`lang.name.zh_CN`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.en_US`, a.name) end as activityName, case when $2 = 'zh_CN' then  coalesce(a.`lang.startApproveActivityName.zh_CN`, a.startApproveActivityName) when $2 = 'zh_TW' then coalesce(a.`lang.startApproveActivityName.zh_TW`, a.startApproveActivityName) else  coalesce(a.`lang.startApproveActivityName.en_US`, a.startApproveActivityName) end as startApproveActivityName, case when $2 = 'zh_CN' then  coalesce(a.`lang.approvePlanDesc.zh_CN`, a.approvePlanDesc) when $2 = 'zh_TW' then coalesce(a.`lang.approvePlanDesc.zh_TW`, a.approvePlanDesc) else  coalesce(a.`lang.approvePlanDesc.en_US`, a.approvePlanDesc) end as approvePlanDesc")
    public List<ActivityBaseInfoVO> getApproveActivityListByTaskIds(List<String> var1, String var2, String var3, String var4);

    @Query(value="match(a:Activity{version:$2}) where a.code in $0 and a.category = \"APPROVAL\"  and (a.tenantId in ['SYSTEM',$1] or a.tenantId is null) return a.code as activityId, a.version as activityVersion")
    public List<ActivityBaseInfoVO> getApproveActivityListByActivityIds(List<String> var1, String var2, String var3);

    @Query(value="match (t:Task{version:$2}) -[:Contains]->(a:Activity) where t.code in $0 and a.executeType = \"MANUAL\" and a.category <> \"APPROVAL\" and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null) return t.code as taskId, a.code as activityId, a.name as activityName")
    public List<ActivityBaseInfoVO> getManualActivityListByTaskIds(List<String> var1, String var2, String var3);

    @Query(value="match (t:Task{version:$3}) -[:Contains]->(a:Activity) where t.code in $0  and (t.tenantId in ['SYSTEM',$1] or t.tenantId is null)return t.code as taskId, a.code as activityId,a.sequence as sequence, case when $2 = 'en_US' then  coalesce(a.`lang.name.en_US`, a.name) when $2 = 'zh_TW' then coalesce(a.`lang.name.zh_TW`, a.name) else  coalesce(a.`lang.name.zh_CN`, a.name) end as activityName order by a.sequence")
    public List<ActivityBaseInfoVO> getActivityListByTaskIds(List<String> var1, String var2, String var3, String var4);
}

