/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivities;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivity;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndTarget;
import com.digiwin.athena.knowledgegraph.domain.task.TaskInputData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface TaskRepository
extends Neo4jRepository<Task, Long> {
    public Task findOneByCodeAndVersion(String var1, String var2, @Depth int var3);

    @Query(value="match(task:Task{code:$1,version:$2}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null or $0 in task.inclusionTenant) return task")
    public Task findTask(String var1, String var2, String var3);

    @Query(value="match (task:Task) where code = $0 return task")
    public Task findTaskNoTenantId(String var1);

    @Query(value="match(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,target,personInCharge")
    public TaskAndTarget findTaskAndTarget(String var1, String var2, String var3);

    @Query(value="match(task:Task{code:$1,version:$2})-[:Contains]->(activity:Activity) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,COLLECT(activity) as activities")
    public TaskAndActivities findTaskAndActivities(String var1, String var2, String var3);

    @Query(value="match(task:Task{code:$1,version:$3})-[:Contains]->(activity:Activity{code:$2}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task,activity")
    public TaskAndActivity findTaskAndActivity(String var1, String var2, String var3, String var4);

    @Query(value="match(te:TenantEntity{tenantId:$0})-[:TASK]->(task:Task{manualAble:$1,version:$2})-[:preset]->(a:LifeActivity)<-[:ACTIVITY]-(te:TenantEntity{tenantId:$0}) return task")
    public List<Task> findByManualAble(String var1, Boolean var2, String var3);

    @Query(value="MATCH (t:Task {code:$1,version:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (t.tenantId in ['SYSTEM',$0] or t.tenantId is null) RETURN t.code as taskId, COLLECT(field) as fields, entity as inputData")
    public Optional<TaskInputData> getTaskInputData(String var1, String var2, String var3);

    @Query(value="match(task:Task{version:$1}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) and task.code in $2 return task")
    public List<Task> allTask(String var1, String var2, List<String> var3);

    @Query(value="match(task:Task{code:$1,version:$2}) optional match(task)-[:Achieves]->(target:TaskTarget) optional match(task)<-[:ResponsibleFor]-(personInCharge:PersonInCharge) optional match(task)-[:Contains]->(activity:Activity) optional match(task)-[:preset]->(lifeActivity:LifeActivity)  where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null)   return task,target,personInCharge,COLLECT(activity) as activities,COLLECT(lifeActivity) as presetActivities")
    public TaskAndTarget findTaskDetail(String var1, String var2, String var3);

    @Query(value="match(t:Task{version:$1})-[:Contains]->(a:Activity) where t.code in $0 and a.executeType='MANUAL' return a")
    public List<Activity> findManualActivities(List<String> var1, String var2);

    @Query(value="match (task:Task) where task.code in $1 and task.version = $2  and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return task")
    public List<Task> getTasksByCode(String var1, List<String> var2, String var3);

    @Query(value="match (n:Task{version:$2})-[:preset]->(a:LifeActivity) where n.manualAble = true  and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null) and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) return n")
    public List<Task> getManualProjectsByName(String var1, String var2, String var3);

    @Query(value="match (t:Task) return distinct t.code as code, t.name as name , t.nameSpace as nameSpace")
    public List<Map> getAllTask();

    @Query(value="match(task:Task{version:$1})-[:Contains]->(activity:Activity{executeType:'MANUAL'}) where task.code in $2 and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null)  return distinct activity.code as code,activity.name as name,{name:{zh_TW:activity.`lang.name.zh_TW`,en_US:activity.`lang.name.en_US`,zh_CN:activity.`lang.name.zh_CN`}} as lang")
    public List<Map<String, Object>> getTaskByProjectCodes(String var1, String var2, List<String> var3);

    @Query(value="match (task:Task{version:$1}) where task.code in $2 and (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) return distinct task.code as code,task.name as name,{name:{zh_TW:task.`lang.name.zh_TW`,en_US:task.`lang.name.en_US`,zh_CN:task.`lang.name.zh_CN`}} as lang")
    public List<Map<String, Object>> getProjectByProjectCodes(String var1, String var2, List<String> var3);
}

