package com.digiwin.athena.knowledgegraph.action.dao;

import com.digiwin.athena.knowledgegraph.domain.rule.TenantServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class TenantServiceConfigDAO {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    public TenantServiceConfig findTenantServiceConfig(String tenantId, String serviceName){
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId)
                .and("serviceName").is(serviceName).and("status").is("1"));
        TenantServiceConfig tenantServiceConfig = this.mongoTemplate.findOne(query, TenantServiceConfig.class);
        return tenantServiceConfig;
    }

    /**
     * 把原来生效的置为失效
     * @param tenantId
     * @param serviceName
     */
    public void disableTenantService(String tenantId, String serviceName){
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId)
                .and("serviceName").is(serviceName).and("status").is("1"));
        Update update = new Update();
        update.set("status","0");
        this.mongoTemplate.updateMulti(query, update, TenantServiceConfig.class);
    }

    public void  addTenantServiceConfig(String tenantId, String serviceName, String productName){
        TenantServiceConfig tenantServiceConfig = new TenantServiceConfig();
        tenantServiceConfig.setTenantId(tenantId);
        tenantServiceConfig.setServiceName(serviceName);
        tenantServiceConfig.setProductName(productName);
        tenantServiceConfig.setStatus("1");
        this.mongoTemplate.save(tenantServiceConfig);
    }

    public void  removeTenantServiceConfig(String tenantId, String serviceName){
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId)
                .and("serviceName").is(serviceName));
        this.mongoTemplate.remove(query, TenantServiceConfig.class);
    }


}
