package com.digiwin.athena.knowledgegraph.action.execution;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.action.metadata.KmActionClient;
import com.digiwin.athena.knowledgegraph.action.constant.ActionCons;
import com.digiwin.athena.knowledgegraph.action.dao.ActionMetadataDAO;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ActionQueryService {
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private ActionMetadataDAO actionMetadataDAO;
    @Autowired
    private KmActionClient actionClient;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private DataPickService dataPickService;

    public List<ActionExecutionDTO> queryActionExeutionList(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = dataPickService.excludeWithSameCode(actionRepository.getActionAndLabels(actionIds, tenantId, tenantVersion),
                actionLabel -> actionLabel.getAction().entityBizCode(),
                actionLabel -> actionLabel.getAction().getSourceLevel());
        List<ActionExecutionDTO> result = new ArrayList<>();
        if (actionAndLabels.size() == 0) {
         //   return result;
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound",actionIds,tenantId));
        }
        actionAndLabels.forEach(e->{
            ActionLabel actionLabel = actionAndLabels.get(0);
            Map<String, Object> actionMatched = JSONObject.parseObject(JSONObject.toJSONString(actionLabel.getAction()), Map.class);
            actionMatched.put(ActionCons.TENANT_ID, tenantId);
            List<String> actionLabels = actionLabel.getActionLabels();
            try {
                result.add(this.actionClient.doHandlerExecution(actionLabels, actionMatched)) ;
            } catch (Exception ex) {
                log.error(ex.getMessage(), ex);
            }
        });
        return result;

    }

    public ActionExecutionDTO queryActionExeution(String actionId, String tenantId) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<ActionLabel> actionAndLabels = dataPickService.filterByIndividual(actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion),
                tenantId,
                actionLabel -> actionLabel.getAction().getNameSpace());
        if (actionAndLabels.size() == 0) {
          //  return null;
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound",actionId,tenantId));
        }
        ActionLabel actionLabel = actionAndLabels.get(0);
        Map<String, Object> actionMatched = JSONObject.parseObject(JSONObject.toJSONString(actionLabel.getAction()), Map.class);
        actionMatched.put(ActionCons.TENANT_ID, tenantId);
        List<String> actionLabels = actionLabel.getActionLabels();
        return this.actionClient.doHandlerExecution(actionLabels, actionMatched);

    }

    public ActionDefinitionDTO queryActionMetadataInfo(String actionId, String tenantId) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<ActionLabel> actionAndLabels = dataPickService.filterByIndividual(actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion),
                tenantId,
                actionLabel -> actionLabel.getAction().getNameSpace());
        if (actionAndLabels.size() == 0) {
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound",actionId,tenantId));
        }
        ActionLabel actionLabel = actionAndLabels.get(0);
        Map<String, Object> actionMatched = JSONObject.parseObject(JSONObject.toJSONString(actionLabel.getAction()), Map.class);
        actionMatched.put(ActionCons.TENANT_ID, tenantId);
        List<String> actionLabels = actionLabel.getActionLabels();
        return this.actionClient.doHandlerMetadata(actionLabels, actionMatched);

    }
}
