package com.digiwin.athena.knowledgegraph.action.model.report;

import lombok.Data;

import java.util.List;

/**
 * @title: ActionSchemaDTO
 * @author: linc
 * @date 2023/11/20 17:10
 * @version: 1.0
 */
@Data
public class ActionSchemaDTO {
    /**
     * 运算列
     */
    private List<ComputedField> computedFields;
    /**
     * 维度字段
     */
    private List<Dimension> dimensions;
    /**
     * 是否去重，true去重，false不去重
     */
    private boolean distinct;
    /**
     * 过滤器配置
     */
    private PlaygroundFilterDTO filter;
    /**
     * 预设条件固定字段
     */
    private List<String> fixedFields;
    /**
     * 度量字段
     */
    private List<Measure> measures;
    /**
     * 模型ID
     */
    private String modelId;
    /**
     * 分页配置项
     */
    private Page page;
    /**
     * 入参配置，key:value的结构，key：参数的名称，value：该字段的值
     */
    private List<Param> params;
    /**
     * 排序字段
     */
    private List<SortField> sortFields;
}
