package com.digiwin.athena.knowledgegraph.constant;

import com.digiwin.athena.knowledgegraph.utils.SpringUtil;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.stereotype.Component;

@Component
@EnableAutoConfiguration
@Setter
@Getter
public class PropertiesConstants {

    private static PropertiesConstants instance;

    private PropertiesConstants() {
    }


    @Value("${eocUrl}")
    private String eocUrl;

    public static PropertiesConstants getInstance() {
        if (PropertiesConstants.instance == null) {
            PropertiesConstants.instance = SpringUtil.getBean(PropertiesConstants.class);
        }
        return PropertiesConstants.instance;
    }
}
