package com.digiwin.athena.knowledgegraph.controller;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.service.impl.ParameterService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * 实现鼎捷云平台设置行权限接口
 * @version 1.0
 */
@RestController
@RequestMapping("/knowledgegraph/")
@Slf4j
public class PermissionController {

    @Autowired
    ParameterService parameterService;

    // appId	String	应用ID	BOSS
    // moduleId	String	模组ID	boss-goods
    // actionId	String	行为ID   boss-goods-management
    // tenantId	String	租户ID	1
    @GetMapping(value= "api/permission/data/schemas")
    @ResponseBody
    public Object getDataPermissionSchemas( String appId,
                                            String moduleId,
                                            String actionId,
                                            String tenantId) throws DWBusinessException {
        /*List<StandardParamsDTO> standardParamsDTOList = parameterService.getParameter(appId, tenantId);
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        permissionSchemas.setFields(standardParamsDTOList);*/
        return parameterService.getParameter(appId, tenantId,moduleId,actionId);
    }
}
