package com.digiwin.athena.knowledgegraph.data;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.stereotype.Component;

@Component
public class MongoDBManager implements InitializingBean {
    //需要参数化
    //todo mongodb不能匿名访问
    private static String connectString = "mongodb://localhost:27017";
    private static String dbName = "tenant_config";
    //单例模式
    // mongoClinet使用连接池管理，不需要每次使用关闭
    private static  MongoDBManager mongoDBManager = new MongoDBManager();

    public static MongoDBManager getMongoDBManager() {
        return mongoDBManager;
    }

    @Autowired
    private MongoDbFactory mongoDbFactory;

  //  private MongoClient client = null;
    private MongoDatabase database = null;
    private MongoDBManager() {
//        if (client == null) {
//            String conStr;
//            String dbName;
//            if (UnitTestHelper.isUnitTest) {
//                conStr = this.connectString;
//                dbName = this.dbName;
//            } else {
//                conStr = DWModuleConfigUtils.getCurrentModuleProperty("mongoDBKGConnectString");
//                dbName = DWModuleConfigUtils.getCurrentModuleProperty("mongoDBKGDBName");
//            }
//            client = MongoClients.create(conStr);
//            database = client.getDatabase(dbName);
//        }
    }

    public MongoDatabase getDatabase() {
        return database;
    }

    public MongoCollection<Document> getCollection(String colName, String keyName) {
        MongoCollection<Document> col = database.getCollection(colName);
        boolean keyExisted = false;
        for (Document index : col.listIndexes()) {
            if (keyName.equals(index.get("name"))) {
                keyExisted = true;
                break;
            }
        }
        if (!keyExisted) {
            IndexOptions indexOptions = new IndexOptions().name(keyName).unique(false).background(true);
            col.createIndex(Indexes.ascending(keyName), indexOptions);
        }
        return col;
    }

    public MongoCollection<Document> getCollectionWithKeys(String colName, String indexName, String... keyName) throws DWBusinessException {
        if (indexName == null ||  indexName.isEmpty() || keyName.length == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.needKey"));
        }
        MongoCollection<Document> col = database.getCollection(colName);
        boolean indexExisted = false;
        for (Document index : col.listIndexes()) {
            if (indexName.equals(index.get("name"))) {
                indexExisted = true;
                break;
            }
        }
        if (!indexExisted) {
            IndexOptions indexOptions = new IndexOptions().name(indexName).unique(false).background(true);
            col.createIndex(Indexes.ascending(keyName), indexOptions);
        }
        return col;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        mongoDBManager = this;
        database = mongoDbFactory.getDb(KnowledgeGraphDb.SYSTEM.getValue());//改为使用公用mongodb
    }
}
