package com.digiwin.athena.knowledgegraph.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.internal.value.*;
import org.neo4j.driver.v1.*;
import org.neo4j.driver.v1.util.Pair;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

//@Component
public class Neo4jManager  implements InitializingBean {
    private static Log log = LogFactory.getLog(Neo4jManager.class);
    //单例模式
    // 每个方法中可以开启Session，而Driver可以复用
    private static  Neo4jManager neo4jManager = null;

    public static Neo4jManager getNeo4jManager() {

        return neo4jManager;
    }

    @Autowired
    private Driver driver ;
//    public void init () {
//        if (driver == null) {
//            String conStr;
//            String userName;
//            String pwd;
//            if (UnitTestHelper.isUnitTest) {
//                conStr = this.connectString;
//                userName = this.userName;
//                pwd = this.password;
//            } else {
//                conStr = DWModuleConfigUtils.getCurrentModuleProperty("neo4jConnectString");
//                userName = DWModuleConfigUtils.getCurrentModuleProperty("neo4jUserName");
//                pwd = DWModuleConfigUtils.getCurrentModuleProperty("neo4jPassword");
//            }
//            //20200612 by maxl: 为解决Neo4j nio超时问题（15min超时返回异常），根据withMaxConnectionLifetime对应的MR说明
//            //  设置连接超过5分钟后自动关闭，避免被网络设备（例如阿里云防火墙）关闭导致在执行时发生超时。
//            //  https://github.com/neo4j/neo4j-java-driver/pull/398
//            Config config = Config.build().withMaxConnectionLifetime(5, TimeUnit.MINUTES).toConfig();
//            driver = GraphDatabase.driver(conStr, AuthTokens.basic(userName, pwd), config);
//        }
//
//        neo4jManager = new Neo4jManager();
//    }

    public void ExecuteNoQuery(String statement) {
        //long start = System.currentTimeMillis();
        //String requestBatch = UUID.randomUUID().toString();
        //logBefore(start, requestBatch, log);
        try (Session session = driver.session())

        {
            session.run(statement);
            // Wrapping Cypher in an explicit transaction provides atomicity
            // and makes handling errors much easier.
//            try (Transaction tx = session.beginTransaction())
//            {
//                tx.run(statement);
//                //tx.commit();
//                tx.commitAsync();
//            }
        }
        //logAfter(start, requestBatch, log);
    }

    public void ExecuteNoQuery(List<String> statements) {
        //long start = System.currentTimeMillis();
        //String requestBatch = UUID.randomUUID().toString();
        //logBefore(start, requestBatch, log);
        try (Session session = driver.session()) {
            // Wrapping Cypher in an explicit transaction provides atomicity
            // and makes handling errors much easier.
//            try (Transaction tx = session.beginTransaction()) {
//                for (String statement : statements) {
//                    tx.run(statement);
//                }
//                tx.commit();
//            }

            for (String statement : statements) {
                session.run(statement);
            }

            //logAfter(start, requestBatch, log);
        } catch (Exception e) {
            //logException(start, requestBatch, e, log);
            throw e;
        }
    }

    public List<Map<String, Object>> ExecuteQuery(String statement) {
        //long start = System.currentTimeMillis();
        //String requestBatch = UUID.randomUUID().toString();
        //logBefore(start, requestBatch, log);
        try (Session session = driver.session()) {
            StatementResult result = session.run(statement);
            List<Map<String, Object>> mapObjects = new ArrayList<>();
            while (result.hasNext()) {
                Record record = result.next();
                List<Pair<String, Value>> fields = record.fields();
                Map<String, Object> recordAsMap = new HashMap<>();
                for (Pair<String, Value> field : fields) {
                    recordAsMap.put(field.key(), ParseNode(field.value()));
                }
                mapObjects.add(recordAsMap);
            }
            //logAfter(start, requestBatch, log);
            return mapObjects;
        } catch (Exception e) {
            //logException(start, requestBatch, e, log);
            throw e;
        }
    }

    public List<Map<String, Object>> ExecuteQuery(String statement, Map<String, Object> params) {
        //long start = System.currentTimeMillis();
        //String requestBatch = UUID.randomUUID().toString();
        //logBefore(start, requestBatch, log);
        try (Session session = driver.session()) {
            StatementResult result = session.run(statement, params);
            List<Map<String, Object>> mapObjects = new ArrayList<>();
            while (result.hasNext()) {
                Record record = result.next();
                List<Pair<String, Value>> fields = record.fields();
                Map<String, Object> recordAsMap = new HashMap<>();
                for (Pair<String, Value> field : fields) {
                    recordAsMap.put(field.key(), ParseNode(field.value()));
                }
                mapObjects.add(recordAsMap);
            }
            //logAfter(start, requestBatch, log);
            return mapObjects;
        } catch (Exception e) {
            //logException(start, requestBatch, e, log);
            throw e;
        }
    }

    private static Object ParseNode(Object value) {
        if (value instanceof NodeValue ) {
            return ((Value)value).asMap();
        }
        else if (value instanceof StringValue) {
            return ((Value)value).asString();
        }
        else if (value instanceof BooleanValue) {
            return ((Value)value).asBoolean();
        }
        else if (value instanceof IntegerValue) {
            return ((Value)value).asInt();
        }
        else if (value instanceof FloatValue) {
            return ((Value)value).asFloat();
        }
//        else if (value instanceof DateValue) {
//            return ((Value)value).asLocalDate();
//        }
//        else if (value instanceof TimeValue) {
//            return ((Value)value).asLocalTime();
//        }
//        else if (value instanceof DateTimeValue) {
//            return ((Value)value).asLocalDateTime();
//        }
        else if (value instanceof ListValue) {
            ArrayList<Object> parsedValue = new ArrayList<>();
            List<Object> valueAsList = ((Value)value).asList();
            for (Object element : valueAsList) {
                parsedValue.add(ParseNode(element));
            }
            return parsedValue;
        }
        else {
            return value;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        neo4jManager = this;

    }
}
