package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.domain.DomainEntity;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * @Author QinQiang
 * @Description
 * @Date 2024/11/18
 **/
@Data
@Document(collection = "componentStructuredList")
public class ComponentStructuredList extends DomainEntity {
    //结构清单类型
    private ComponentStructuredListType type;
    //应用编号，同时也是管理议题编号
    private String appCode;
    //范式，对应客户在特定管理议题下的分类
    private String paradigm;
    //机制编号
    private String mechanismCode;
    //组件结构版本号，为将来可能发生的结构变化提供兼容方案，每个版本可以用不同的解析器进行解析
    private String structureVersion;

    //组件
    private List<StructuredComponentBO> components;

    @Override
    public String entityBizCode() {
        return appCode + paradigm + type + mechanismCode;
    }
}
