package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
租户信息节点.把所有租户信息都存于neo4j中,通过图的关系把租户节点和它使用的其他入口级节点连接起来
 **/
@Data
@Document(collection = "tenantEntity")
public class TenantEntity extends DomainEntity {

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 产品
     */
    @Relationship(type="PRODUCT")
    private List<ProductEntity> products;

    /**
     * 客服代号
     */
    private String customerServiceCode;




}
