package com.digiwin.athena.knowledgegraph.domain.activity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * 导出导入配置表
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = "exportAndImportConfig")
public class ExportAndImportConfig {

    private String code;
    private String name;

    private Map<String, Map<String, String>> lang;

    private String viewCode;
    private String viewName;
    private String pattern;
    private String pageCode;

    private Object exportConfig;
    private Object importConfig;
    private Object templateConfig;

}
