package com.digiwin.athena.knowledgegraph.domain.config;

import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Data
public class MergeRule {
    /**
     * 类型
     */
    private String type;
    /**
     * 规则code
     */
    private String code;
    /**
     * 是否删除
     */
    private Boolean delete;
    /**
     * 是否合并
     */
    private Boolean merge;
    /**
     * 合并规则列表
     */
    private List<Map> mergeRules;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 版本
     */
    private String version;

    public static Map<String, Object> convertToMergeConfig(List<Map> mergeRules, Map<String, Object> activityConfig) {
        if (mergeRules == null || mergeRules.isEmpty()) {
            throw new IllegalArgumentException("mergeRules cannot be empty");
        }

        Map<String, Object> mergeConfig = new HashMap<>();
        Map<String, Object> sysMergeConfig = (Map<String, Object>) activityConfig.get("mergeConfig");
        if (CollectionUtils.isEmpty(sysMergeConfig)) {
            mergeConfig.put("type", "businessFieldNONE");
            mergeConfig.put("planFields", Collections.EMPTY_LIST);
            mergeConfig.put("fields", Collections.EMPTY_LIST);
            return mergeConfig;
        }
        String variableKey = (String) sysMergeConfig.get("variableKey");
        String variableType = (String) sysMergeConfig.get("variableType");
        List<Map> fieldMeta = sysMergeConfig.get("fieldMeta") == null ? Collections.emptyList() : (List<Map>) sysMergeConfig.get("fieldMeta");
        Set<String> dataNames = new HashSet<>();

        for (Map<String, Object> field : fieldMeta) {
            String dataName = (String) field.get("data_name");
            if (dataName != null && !dataName.isEmpty()) {
                dataNames.add(dataName);
            }
        }

        mergeConfig.put("variableKey", variableKey);
        mergeConfig.put("variableType", variableType);
        mergeConfig.put("fieldMeta", fieldMeta);

        Object submit = sysMergeConfig.get("submit");
        if(!ObjectUtils.isEmpty(submit)){
            mergeConfig.put("submit", String.valueOf(submit));
        }

        Map<String, Object> planEndDateRule = null;
        Map<String, Object> businessFieldRule = null;
        Map<String, Object> businessTypeRule = null;

        for (Map<String, Object> rule : mergeRules) {
            String type = (String) rule.get("type");
            if ("planEndDate".equals(type)) {
                planEndDateRule = rule;
            } else if ("businessField".equals(type)) {
                businessFieldRule = rule;
            } else if ("businessType".equals(type)) {
                businessTypeRule = rule;
            }
        }

        if (planEndDateRule == null || businessTypeRule == null) {
            throw new IllegalArgumentException("Invalid mergeRules format");
        }

        String mergeType;
        List<String> planFields = null;
        List<String> fields = null;

        boolean isEnabledPlanEndDate = (boolean) planEndDateRule.get("enabled");
        boolean isEnabledBusinessField = businessFieldRule == null ? false : (boolean) businessFieldRule.get("enabled");
        boolean isEnabledBusinessType = (boolean) businessTypeRule.get("enabled");


        if (!isEnabledPlanEndDate && !isEnabledBusinessField && !isEnabledBusinessType) {
            mergeType = "noPlanTime";
            planFields = new ArrayList<>();
            fields = new ArrayList<>();
        } else if (isEnabledPlanEndDate) {
            mergeType = "businessFieldNONE";
            if (isEnabledBusinessType) {
                planFields = (List<String>) businessTypeRule.get("types");
            }
            if (isEnabledBusinessField) {
                fields = (List<String>) businessFieldRule.get("fields");
            }
        } else if (!isEnabledPlanEndDate) {
            mergeType = "businessField";
            if (isEnabledBusinessType) {
                planFields = (List<String>) businessTypeRule.get("types");
            }
            if (isEnabledBusinessField) {
                fields = (List<String>) businessFieldRule.get("fields");
            }
        } else {
            throw new IllegalArgumentException("Invalid combination of mergeRules");
        }

        if (fields != null && !dataNames.isEmpty()) {
            fields = fields.stream().filter(dataNames::contains).collect(Collectors.toList());
        }

        mergeConfig.put("type", mergeType);
        if (!CollectionUtils.isEmpty(planFields)) {
            mergeConfig.put("planFields", planFields);
        }
        if (!CollectionUtils.isEmpty(fields)) {
            mergeConfig.put("fields", fields);
        }
        //若mergeType为businessField且fields为空则降级为noPlanTime
        if (mergeType.equals("businessField") && CollectionUtils.isEmpty(planFields) && CollectionUtils.isEmpty(fields)) {
            mergeConfig.put("type", "noPlanTime");
        }

        return mergeConfig;
    }

}
