package com.digiwin.athena.knowledgegraph.domain.esp;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EspResponse {
    Status status;
    String msg;
    Object data;
    String errorCode;
    String chainInfo;

    public static EspResponse ok(){
        return EspResponse.builder().status(Status.SUCCESS).build();
    }

    public static EspResponse ok(Object data){
        return EspResponse.builder().status(Status.SUCCESS).data(data).build();
    }

    public static EspResponse failed(String msg){
        return EspResponse.builder().status(Status.FAILED).msg(msg).build();
    }

    public enum Status{
        SUCCESS, FAILED
    }
    public boolean isOK() {
        return this.status.equals(Status.SUCCESS);
    }
}
