package com.digiwin.athena.knowledgegraph.domain.mechanism;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author tang jie cheng
 * @date 2022-05-20 13:10
 */
@Data
@Document(collection = "paradigm")
public class Paradigm extends DomainEntity {

    /**
     * 范式名称
     */
    private String name;

    /**
     * 范式编码
     */
    private String code;

    /**
     * 自动添加组件Y/N
     */
    private String _autoAdd;

    /**
     * 应用编码
     */
    private String application;

    /**
     * 创建人
     */
    private Object createBy;

    /**
     * 创建时间
     */
    private Long createDate;

    /**
     * 修改人
     */
    private Object editBy;

    /**
     * 修改时间
     */
    private Long editDate;


    @Override
    public String entityBizCode() {
        return code;
    }
}
