package com.digiwin.athena.knowledgegraph.domain.targets;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.Objects;

@Data
public class SystemIndicatorTreeNodeRelation {

    @NotEmpty
    private String indicatorId;
    private String parentId;
    private String name;
    private String tendency;
    private Boolean featureSelection;
    private String unit;
    private String group;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SystemIndicatorTreeNodeRelation that = (SystemIndicatorTreeNodeRelation) o;
        return indicatorId.equals(that.indicatorId) && parentId.equals(that.parentId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(indicatorId, parentId);
    }
}
