package com.digiwin.athena.knowledgegraph.domain.task;

import com.digiwin.athena.kg.domain.CodedEntity;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-11-29 14:33
 **/
@Data
public class EmailView  extends CodedEntity {
    /**
     * 邮件名称
     */
    private String name;
    /**
     * 邮件模板code
     */
    private String templateCode;
    /**
     * 多语言
     */
    private Map<String,String> localeViews;
    /**
     * 得分
     */
    private Integer score=0;
    /**
     * 匹配条件
     */
    private List<MatchCondition> matches;
    /**
     * 是否默认模板
     */
    private Boolean defaultTemplate;
    /**
     * 邮件配置样例,主要用于提示每个表格支持哪些字段
     */
    private EmailConfig template;
    /**
     * 实际采用的配置结果
     */
    private EmailConfig config;
    /**
     * 邮件描述
     */
    private String description;
    /**
     * 应用code
     */
    private String application;
}
