package com.digiwin.athena.knowledgegraph.domain2.mechanism;

import com.digiwin.athena.kg.action.AbstractionEntity;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
一个场景,包含一组条件 一个公式(以及参数) 一些建议
 **/
@Data
public class MechanismScene extends AbstractionEntity {

    //场景的类别
    private String category;
    //代表一种场景
//    private String key;
//    private String name;
    private Object condition;

    //公式
    private MechanismFormula2 formula;

    //推荐值
    @Relationship(type="SUGGESTS")
    private List<MechanismSuggest> suggests;

    //哪些条件构成该场景
//    @Relationship(type="CONSTITUTE",direction=Relationship.INCOMING)
//    private List<MechanismClassifyCondition> constitutes;

    //使用此公式满足的条件
    private List<String> keys;

}
