package com.digiwin.athena.knowledgegraph.dto;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.kg.domain.DomainEntity;
import com.digiwin.athena.knowledgegraph.domain.ActivityOld;
import lombok.Data;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-07-23 16:13
 **/
@Data
public class ActivityDTO extends DomainEntity {

    private String name;
    //任务代码
    private String code;

    private String sequence;
    //执行类型
    private String executeType;

    private Boolean milestone;

    private String expectedDuration;

    private String category;

    private Integer emergency;

    private String pattern;

    private Boolean showFlow;

    private Boolean dispatchWF;

    private String relationQueries;

    private String summaryFields;

    private String filters;

    private String operations;

    private String checkItems;


    private ActionDTO getDataAction;

    private List<ActionDTO> submitActions;




    public static ActivityDTO toActivity(ActivityOld activityOld){

        ActivityDTO result = null;
        if(null!= activityOld){
            result =new ActivityDTO();
            result.setCategory(activityOld.getCategory());
            result.setCode(activityOld.getCode());
            result.setDispatchWF(activityOld.getDispatchWF());
            result.setEmergency(activityOld.getEmergency());
            result.setExecuteType(activityOld.getExecuteType());
            result.setExpectedDuration(activityOld.getExpectedDuration());
            result.setMilestone(activityOld.getMilestone());
            result.setName(activityOld.getName());
            result.setPattern(activityOld.getPattern());
            result.setSequence(activityOld.getSequence());
            result.setShowFlow(activityOld.getShowFlow());
            result.setLang(activityOld.getLang());
            if(null!= activityOld.getSubmitActions()){
                result.setSubmitActions(JSON.parseArray(activityOld.getSubmitActions(),ActionDTO.class));
            }

            if(null!= activityOld.getGetDataAction()){
                //todo 暂时屏蔽掉
               // result.setGetDataAction(JSON.parseObject(activity.getGetDataAction(),ActionDTO.class));
            }

        }

        return result;
    }

}
