package com.digiwin.athena.knowledgegraph.dto;

import com.digiwin.athena.knowledgegraph.domain.common.LanguageEntity;
import lombok.Data;

import java.util.LinkedList;
import java.util.List;

@Data
public class TargetNodeDto extends LanguageEntity {

    private String objectId;
    private String tenantId;
    private String id;
    private String name;
    private String tendency;
    private String tendencyName;
    private String period;
    private String unit;
    private String precision;
    private String description;
    private String target;
    private String warningStage;
    private List<TargetNodeDto> children;
    private List<String> personInCharge;
    private Boolean enabled;

    public void addChildren(TargetNodeDto child) {
        if (null == children) {
            children = new LinkedList<>();
        }
        children.add(child);
    }

}
