package com.digiwin.athena.knowledgegraph.dto;

import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.enums.Dimensionality;
import com.digiwin.athena.knowledgegraph.enums.PointInTime;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 交付设计器的待办工作台设置中的条件
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WSConditionDTO implements Serializable {

    private BusinessMessageSourceMethod businessMessageSourceMethod;

    /**
     * 名称
     */
    @NotBlank
    private String aliasName;
    /**
     * 代号
     */
    @NotBlank
    private String aliasCode;


    /**
     * 交付设计器界面拖拽排序
     */
    private Integer sort;
    /**
     * 类型
     */
    @NotBlank
    private String dataType;

    @NotNull
    private SourceType sourceType;

    private List<PointInTime> pointInTime;

    private List<Dimensionality> dimensionality;
    /**
     * 是否默认启用
     */
    private Boolean defaultEffective;

    /**
     * 是否启用
     */
    private Boolean enable;

    /**
     * 分组下，是否默认分组项
     */
    private Boolean defaultGroup;

    public Map<String, Map<String, String>> lang;

    /**
     * 生效范围
     */
    private List<ConditionScopeDTO> conditionScope;
}
