package com.digiwin.athena.knowledgegraph.mechanism;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.widgets.Widget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.Field;
import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-09 10:11
 **/
@Slf4j
public abstract class AbstractMechanismCapacityParser implements MechanismCapacityParser{

    @Autowired
    private List<MechanismPartParser> partParsers;


    public void parsePart(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        if(null==part){return;}
        for(MechanismPartParser parser:partParsers){
            if(parser.accept(part)){
                parser.parse(context, part);
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的MechanismPart by:"+part);
    }

    public void generateCypherPart(MechanismParseContext context, MechanismPart part,String parentNode) throws DWBusinessException {
        if(null==part){return;}
        String nodeId = doGenerateCypherPart(context, part, parentNode);
        for(MechanismPartParser parser:partParsers){
            if(parser.accept(part)){
                parser.generateCypher(context,part,nodeId);
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的MechanismPart by:"+part);
    }

    protected String doGenerateCypherPart(MechanismParseContext context, MechanismPart part,String parentNode){
        String nodeId = part.getCode();
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismPart:MechanismComponent{")
                .append("code").append(":'").append(part.getCode()).append("',")
                .append("name").append(":'").append(part.getName()==null?"Part_"+part.getCode():part.getName()).append("',")
                .append("type").append(":'").append(part.getType()).append("',");

        fieldCypher(context, part);

        context.getCypherSb().append("pluginId").append(":'").append(context.getPluginId()).append("'")
                .append("})\r\n");
        context.getCypherSb().append("create(").append(parentNode).append(")-[:PART]->(").append(nodeId).append(")\r\n");

        return nodeId;
    }

    protected String doGenerateCypherPart(MechanismParseContext context, MechanismPart part){
        String nodeId = part.getCode();
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismPart:MechanismComponent{")
                .append("code").append(":'").append(part.getCode()).append("',")
                .append("name").append(":'").append(part.getName()==null?"Part_"+part.getCode():part.getName()).append("',")
                .append("type").append(":'").append(part.getType()).append("',");

       // fieldCypher(context, part);
        context.getCypherSb().append("tenantId").append(":'").append(context.getTenantId()).append("',");
        context.getCypherSb().append("pluginId").append(":'").append(context.getPluginId()).append("'")
                .append("})\r\n");

        return nodeId;
    }

    protected void doGenerateCypherPartRelation(MechanismParseContext context, String fromNode,String toNode,String relation){
        context.getCypherSb().append("create(").append(fromNode).append(")-[:"+relation+"]->(").append(toNode).append(")\r\n");
    }



    private void fieldCypher(MechanismParseContext context, MechanismPart part){
        Field[] fields = part.getClass().getDeclaredFields();
        for(Field f: fields){
            try {
                f.setAccessible(true);
                if(f.getName().equals("strategies")){continue;}
                Object obj = f.get(part);
                if(null==obj){continue;}
                //if(obj instanceof Widget){continue;}
                String objStr= null;
                if(!Utils.isPrimitive(f.getType())){
                    objStr = JSON.toJSONString(obj);
                }else{
                    objStr = obj.toString();
                }
                if(objStr.contains("'")){continue;}

                context.getCypherSb().append(f.getName()).append(":'").append(objStr).append("',");
            } catch (IllegalAccessException e) {
                log.error(e.getMessage(), e);
            }
        }
    }


    public static void main(String[] args) {
        System.out.println("abs'afsd'bb".contains("'"));
    }
}
