package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-09 09:14
 **/
@Service
public class MechanismBuilderService {

    @Autowired
    private List<MechanismCapacityParser> capacityParsers;


    public MechanismLogic build(MechanismParseContext context) throws DWBusinessException {
        MechanismCapacity capacity = context.getCapacity();
        MechanismLogic mechanismLogic = new MechanismLogic();
        mechanismLogic.setTenantId(context.getTenantId());
        mechanismLogic.setVersion(context.getTenantVersion());
        mechanismLogic.setApplication(capacity.getApplication());
        mechanismLogic.setCode(capacity.getCode());
        mechanismLogic.setName(capacity.getName());
        mechanismLogic.setDescription(capacity.getDescription());
        mechanismLogic.setLang(capacity.getLang());
        mechanismLogic.setType(capacity.getType());
        mechanismLogic.setCreatedByDevPlatform(capacity.isCreatedByDevPlatform());
        parseCapacity(context,capacity);
        MechanismAbility logic = context.getLogic();
        if(logic instanceof DriveAbilityBo){
            mechanismLogic.setType(ComponentTypeEnum.MechanismDrive.name());
        }
        mechanismLogic.setLogic(logic);

        return mechanismLogic;
    }

    public void parseCapacity(MechanismParseContext context,MechanismCapacity capacity) throws DWBusinessException {
      //  String rootId = geneCypherRoot(context, capacity);
        for(MechanismCapacityParser parser:capacityParsers){
            if(parser.accept(capacity)){
                parser.parse(context, capacity);
                if (!"SYSTEM".equals(capacity.getFrom())) {
                    parser.generateCypher(context,capacity,null);
                }
                return;
            }
        }
        throw new DWBusinessException("没有找到对应的MechanismCapacityParser by:"+capacity);
    }

    @Deprecated
    public String geneCypherRoot(MechanismParseContext context,MechanismCapacity capacity){
        String rootNodeId = "MechanismCapacity_"+capacity.getCode();
        context.getCypherSb().append("create(").append(rootNodeId).append(":MechanismCapacity:MechanismComponent{")
                .append("code").append(":'").append(capacity.getCode()).append("',")
                .append("name").append(":'").append(capacity.getName()).append("',")
                .append("type").append(":'").append(capacity.getType()).append("',")
                .append("description").append(":'").append(capacity.getDescription()).append("',")
                .append("mechanismTheoryCode").append(":'").append(capacity.getMechanismCode()).append("',")
                .append("mechanismCode01").append(":'").append(capacity.getMechanismCode()).append("',")
                .append("status").append(":").append(capacity.getStatus()).append(",")
                .append("pluginId").append(":'").append(context.getPluginId()).append("'")
                .append("})\r\n")
                ;


        return rootNodeId;
    }



}
