package com.digiwin.athena.knowledgegraph.mechanism.partparsers;


import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;

import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskAccordingToStandardPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.check.CheckAccordingToStandard;
import com.digiwin.athena.mechanism.widgets.check.CheckCompleteParam;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 仅适用于source是侦测的情况
 * @author: Tuo
 * @create: 2023-03-09 15:19
 **/
@Slf4j
@Service
public class CheckTaskAccordingToStandardParser extends AbstractMechanismPartParser {

    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    ActionMetadataManager actionMetadataManager;

    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.checkTaskAccordingToStandard.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        // 将 part 转换为 CheckTaskOnTimeOverPart 类型
        CheckTaskAccordingToStandardPart checkPart = (CheckTaskAccordingToStandardPart) part;
        // 获取上下文中的逻辑和检查来源
        DriveAbilityBo logic = (DriveAbilityBo) context.getLogic();
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget) logic.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();

        // 如果规则的静态参数列表为空，则创建一个空列表
        if (null == rule.getStaticParams()) {
            rule.setStaticParams(new ArrayList<>());
        }

        // 如果逻辑中的预活动列表为空，则创建一个空列表
        if (null == logic.getPreActivities()) {
            logic.setPreActivities(new ArrayList<>());
        }
        // 获取检查作业
        String checkJob = checkPart.getCheckAccordingToStandard().getCheckJob();
        if (StringUtils.isEmpty(checkJob)) {
            // 如果检查作业为空，则抛出异常
            throw new DWBusinessException("checkJob is required by CheckTaskAccordingToStandardPart");
        }

        // 如果检查作业是按时报工
        if ("reportForWorkOnTime".equalsIgnoreCase(checkJob)) {
            // 检查是否设置了 checkField 字段，如果没有则抛出异常
            if (null == checkPart.getCheckAccordingToStandard() || StringUtils.isEmpty(checkPart.getCheckAccordingToStandard().getCheckField())
                    || StringUtils.isEmpty(checkPart.getCheckAccordingToStandard().getCheckDataSource())) {
                throw new DWBusinessException("checkField is required by CheckTaskAccordingToStandardPart");
            }

            String checkAccordingToStandardStr = JSON.toJSONString(checkPart.getCheckAccordingToStandard());
            String reportEoc = checkPart.getCheckAccordingToStandard().getEocPath();

            // 获取包含流程变量的task列表
            rule.setMonitorActionId("mechanism_CheckTaskByStandardAction");

            // 添加参数
            SourceWidget targetSource = context.getTargetSource();
            DynamicParam param1 = new DynamicParam();
            param1.setParam_name("taskDefCode");
            param1.setParam_value(targetSource.getTarget());
            rule.getStaticParams().add(param1);
            DynamicParam param2 = new DynamicParam();
            param2.setParam_name("closed");
            param2.setParam_value("false");
            rule.getStaticParams().add(param2);

            // step1 配置活动查询所有进行中的任务
            ActivityWidget activityWidget1 = new ActivityWidget();
            activityWidget1.setType("script");
            activityWidget1.setConfig(new HashMap<>());
            activityWidget1.getConfig().put("executionMode", "script");
            Map<String, String> scriptMode = new HashMap<>();
            scriptMode.put("requestScript", "");
            String responseScript = "var data = $(data); var processData = data[0]['data']; return {processVariable: { list: processData} }";
            //responseScript = responseScript.replace("#checkDay#", cd.toString());
            scriptMode.put("responseScript", responseScript);
            activityWidget1.getConfig().put("scriptMode", scriptMode);
            activityWidget1.setName("返回所有进行中的包含流程变量任务");
            logic.getPreActivities().add(activityWidget1);
            checkPart.setActivityWidget0(activityWidget1);

            // step2 在将整包数据通过调用kg定制api请求esp获取业务数据
            ActivityWidget activityWidget2 = new ActivityWidget();
            activityWidget2.setType("http");
            activityWidget2.setConfig(new HashMap<>());
            activityWidget2.getConfig().put("executionMode","script");
            activityWidget2.getConfig().put("method","post");
            activityWidget2.getConfig().put("domain","thememap");
            activityWidget2.getConfig().put("contentType","json");
            activityWidget2.getConfig().put("url","/restful/service/knowledgegraph/mechanismEnhancement/taskBizData");
            String kgRequestScript = "var request = { \"taskId\": \"#taskId#\", \"taskList\": $(list), " +
                    "\"checkDataSource\": \"#checkDataSource#\", \"tenantId\": \"$(tenantId)\", \"checkAccordingToStandard\": #checkAccordingToStandard#}; return request;";
            kgRequestScript = kgRequestScript.replace("#taskId#", targetSource.getTarget());
            String checkDataSource = checkPart.getCheckAccordingToStandard().getCheckDataSource();
            kgRequestScript = kgRequestScript.replace("#checkDataSource#", checkDataSource);
            kgRequestScript = kgRequestScript.replace("#checkAccordingToStandard#", checkAccordingToStandardStr);
            String kgResponseScript = "var data = $(response); var processData = data['response']['data']; return {processVariable: { bizData: processData} }";
            HashMap<Object, Object> scriptMode2 = new HashMap<>();
            scriptMode2.put("requestScript",kgRequestScript);
            scriptMode2.put("responseScript",kgResponseScript);

            activityWidget2.getConfig().put("scriptMode",scriptMode2);
            activityWidget2.setName("返回包含业务数据的任务");
            logic.getPreActivities().add(activityWidget2);
            checkPart.setActivityWidget1(activityWidget2);

            // step3 获取通知用户
            ActivityWidget activityWidget3 = new ActivityWidget();
            activityWidget3.setType("http");
            activityWidget3.setConfig(new HashMap<>());
            activityWidget3.getConfig().put("executionMode","script");
            activityWidget3.getConfig().put("method","post");
            activityWidget3.getConfig().put("domain","thememap");
            activityWidget3.getConfig().put("contentType","json");
            activityWidget3.getConfig().put("url","/restful/service/knowledgegraph/mechanismEnhancement/taskInformPersonByEoc");
            String kgGetUserRequestScript = "var request = { \"taskCode\": \"#taskCode#\", \"taskList\": $(bizData), " +
                    "\"checkDataSource\": \"#checkDataSource#\", \"tenantId\": \"$(tenantId)\",\"eocField\": \"#eocField#\"}; return request;";
            kgGetUserRequestScript = kgGetUserRequestScript.replace("#taskCode#", targetSource.getTarget());
            kgGetUserRequestScript = kgGetUserRequestScript.replace("#checkDataSource#", checkDataSource);
            String eocField = reportEoc;
            if (!StringUtils.isEmpty(eocField)) {
                kgGetUserRequestScript = kgGetUserRequestScript.replace("#eocField#", eocField);
            } else {
                kgGetUserRequestScript = kgGetUserRequestScript.replace("#eocField#", "");
            }
            String kgGetUserResponseScript = "var data = $(response); var informPersons = data['response']['data']; return { processVariable: { informPersons: informPersons} }";
            HashMap<Object, Object> scriptMode3 = new HashMap<>();
            scriptMode3.put("requestScript",kgGetUserRequestScript);
            scriptMode3.put("responseScript",kgGetUserResponseScript);
            activityWidget3.getConfig().put("scriptMode",scriptMode3);
            activityWidget3.setName("从业务数据中取出eoc转为userId");
            logic.getPreActivities().add(activityWidget3);
            checkPart.setActivityWidget2(activityWidget3);

            // 设置 IM 消息的执行人 $(informPersons)
            context.getNamedParams().put(MechanismParseContext.Names.im_userId, "$(informPersons)");

        }else if("reportForWorkOnApi".equalsIgnoreCase(checkJob)){
            //添加定义流程逻辑
            // 检查是否设置了 checkField 字段，如果没有则抛出异常
            if (null == checkPart.getCheckAccordingToStandard()) {
                throw new DWBusinessException("CheckTaskAccordingToStandard is required");
            }
            CheckAccordingToStandard checkAccordingToStandard = checkPart.getCheckAccordingToStandard();
            // 获取包含流程变量的task列表
            String actionId=checkAccordingToStandard.getObjectApiActionId();
            rule.setMonitorActionId(checkAccordingToStandard.getObjectApiActionId());
            GetActionLocaleResponseDTO getActionLocaleResponseDTO;
            String dataName;
            try {
                ActionMetadataDTO responseDTO = actionMetadataManager.getActionMetadata(actionId, "SYSTEM", "1.0");
                getActionLocaleResponseDTO = JSON.parseObject(JSON.toJSONString(responseDTO),
                        GetActionLocaleResponseDTO.class);
                dataName = getActionLocaleResponseDTO.getResponse().getData().getData_name();
            } catch (Exception e) {
                throw new DWBusinessException( "P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound",actionId));
            }
            if (StringUtils.isEmpty(dataName)) {
                throw new DWBusinessException( "P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionResponseDataNameNotFound", actionId));
            }
            if(null!=getActionLocaleResponseDTO){
                // 添加参数
                List<MechanismConditionGroup> groups = checkAccordingToStandard.getBusinessCondition().getGroups();
                if(!CollectionUtils.isEmpty(groups)){
                    groups.forEach(mechanismConditionGroup -> {
                        List<MechanismConditionConfig> conditions = mechanismConditionGroup.getConditions();
                        if(!CollectionUtils.isEmpty(conditions)){
                            DynamicParam dynamicParam=new DynamicParam();
                            dynamicParam.setParam_name(ComponentConstants.PHP_TASK_INFO);
                            dynamicParam.setConfigType(ComponentConstants.PHP_API);
                            List<DynamicParam> taskInfo=new ArrayList<>();
                            conditions.forEach(mechanismConditionConfig -> {
                                MechanismVariable to = mechanismConditionConfig.getRight().getTo();
                                DynamicParam param = new DynamicParam();
                                param.setParam_name(to.getConfigItem());
                                param.setConfigType(to.getConfigType());
                                param.setParam_value(String.valueOf(to.getValue()));
                                taskInfo.add(param);
                            });
                            dynamicParam.setParam_value(JsonUtil.toJsonString(taskInfo));
                            rule.getStaticParams().add(dynamicParam);
                        }
                    });
                }
                //调用action对应的接口信息（step1）
                ActivityWidget activityWidget1 = new ActivityWidget();
                activityWidget1.setType("script");
                activityWidget1.setConfig(new HashMap<>());
                activityWidget1.getConfig().put("executionMode", "script");
                Map<String, String> scriptMode = new HashMap<>();
                scriptMode.put("requestScript", "");
                String responseScript = "var data = $(data);var taskInfo = data[0]['" + dataName + "']; return {processVariable: { taskBizData: taskInfo} }";
                scriptMode.put("responseScript", responseScript);
                activityWidget1.getConfig().put("scriptMode", scriptMode);
                activityWidget1.setName(getActionLocaleResponseDTO.getName());
                logic.getPreActivities().add(activityWidget1);
                checkPart.setActivityWidget0(activityWidget1);

            }
        }

    }
    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart) part;
        CheckCompleteParam widget = checkPart.getCheckComplete();
        ActivityWidget activityWidget0 = checkPart.getActivityWidget0();
        ActivityWidget activityWidget1 = checkPart.getActivityWidget1();
        if(null!=activityWidget0){
            super.generateCypherActivity(context,activityWidget0,parentNode);
        }
        if(null!=activityWidget1){
            super.generateCypherActivity(context,activityWidget1,parentNode);
        }

    }

}
