package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.pre.MechanismCapacityCodes;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.SourceTaskDecisionPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.jayway.jsonpath.JsonPath;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Description
 * @Author liugl
 * @Date 2024/6/27 10:06
 **/
@Service
public class SourceTaskDecisionObjectParser extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return MechanismCapacityCodes.sourceTaskDecisionObject.equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        SourceTaskDecisionPart sourcePart = (SourceTaskDecisionPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        DecisionAbilityBO logic = (DecisionAbilityBO) context.getLogic();
        logic.setCheckSource(targetSource);
        logic.setVariable(sourcePart.getVariable());

        Map map = JSON.parseObject(JSON.toJSONString(context));
        // 获取条件判断
        Object condObj = JsonPath.read(map, "$.capacity.action.decisionOption.scenes[0].check.groups[0].conditions[0]");
        JSONObject condJsonObj = JSON.parseObject(condObj.toString());
        logic.setSubType(condJsonObj.getString("type"));
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        SourceTaskDecisionPart sourcePart = (SourceTaskDecisionPart) part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context,targetSource,parentNode);
    }
}
