package com.digiwin.athena.knowledgegraph.po;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Author QinQiang
 * @Description
 * @Date 2024/3/11
 **/
@Data
public class CommonDrivenSchemaReq {
    private Model model;

    @Data
    public static class Model {
        private JSONObject appInfo;
        private String code;
        private String description;
        private Schema schema;
    }

    @Data
    public static class AppInfo {
        private String prod;
    }

    @Data
    public static class Schema {
        private List<Field> fields;
        private List<Index> index;
        private JSONObject lang;
        private String name;
        private String pk;
        private SwitchCfg switchCfg;
        private boolean isPublished;
        private boolean isSystem;
        private String comment;
    }

    @Data
    public static class Field {
        private boolean autoIncrement = false;
        private String defaultValue;
        private String fieldId;
        private String fieldName;
        private String fieldType;
        @JsonProperty("isPk")
        private boolean isPk = false;
        @JsonProperty("isSystem")
        private boolean isSystem = false;
        private JSONObject lang;
        private boolean notNull = false;
        private String size = "50";
        private String scale;
        private String type = "SIMPLE";
        private boolean unique = false;
    }

    @Data
    @Accessors(chain = true)
    public static class Index {
        private String id;
        private List<String> member;
        private boolean needCreateIndex;
        private String type;
    }

    @Data
    public static class SwitchCfg {
        private String dataPermission = "N";
        private String triggerEvent = "N";
    }
}
