package com.digiwin.athena.knowledgegraph.repoSystem;

import com.digiwin.athena.kg.activity.ActivityConfig;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ActivityConfigRepository extends MongoRepository<ActivityConfig,String> {
    ActivityConfig findOneByCode(String code);

    Integer  deleteByCode(String code);

    @Query(value="{'code':{$in:?0}}",fields = "{'code':1,'expectedDuration':1}")
    List<ActivityConfig> getCodeAndExpectedDuration(List<String> codes);

}