package com.digiwin.athena.knowledgegraph.rule;

import com.alibaba.fastjson.JSON;

import com.alibaba.fastjson.JSONArray;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kg.monitorRule.product.*;
import com.digiwin.athena.kg.monitorRule.tenant.*;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.data.Neo4jConstants;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.knowledgegraph.product.dao.ProductTenantConfigDAO;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.MonitorVO;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.kg.report.hz.model.sence.RuleSceneDTO;
import com.digiwin.athena.knowledgegraph.rule.dao.*;
import com.digiwin.athena.knowledgegraph.rule.model.*;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.knowledgegraph.service.model.OmMapDTO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.mongodb.client.MongoCollection;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

@Service
@Slf4j
public class MonitorRuleManager {

    @Autowired
    private MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private MonitorRuleProductConfigDAO monitorRuleProductConfigDAO;
    @Autowired
    private MonitorRuleTenantConfigDAO monitorRuleTenantConfigDAO;
    @Autowired
    private ProductTenantConfigDAO productTenantConfigDAO;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private List<AbstractMonitorRuleCategoryService>  monitorRuleCategoryServices;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    IamService iamService;

    private static final String TENANT_CONFIG_COLLECTION_NAME = "monitorRuleTenantConfig";
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "monitorRuleProductConfig";

    public static final String TENANT_CONFIG_INDEX_NAME = "idx_TenantConfig";
    public static final String PRODUCT_CONFIG_INDEX_NAME = "idx_ProductConfig";
    public static final String TENANT_ID_FIELD = "tenantId";
    public static final String PRODUCT_NAME_FIELD = "productName";
    public static final String MONITOR_RULE_ID_FIELD = "monitorRuleId";
    public static final String VERSION_FIELD = "version";
    public static final String STATUS_FIELD = "status";
    @Autowired
    private IAMUtils iAMUtils;

    @Deprecated
    public MonitorRuleDTO get2(String ruleId, String tenantId, String tenantVersion) throws Exception {

        MonitorRuleDTO ruleDTO = new MonitorRuleDTO();
        MonitorRuleTemplateDO templateDO = this.readTemplateFromNeo4j2(ruleId, tenantId, tenantVersion);

        MonitorRuleTenantConfig tenantConfig =
                this.monitorRuleTenantConfigDAO.findTenantConfigByRuleIdAndTenantId(ruleId, tenantId);
        String productName = tenantConfig.getProductName();

        ruleDTO.setRule_id(ruleId);
        ruleDTO.setAction_id(templateDO.getActionId());
        ruleDTO.setMonitor_type(templateDO.getType());
        ruleDTO.setIs_deduplication(tenantConfig.getIs_deduplication());
        ruleDTO.setBk_info(tenantConfig.getBk_info());
        ruleDTO.setProcedure_name(tenantConfig.getProcedure_name());
        ruleDTO.setProcedure_input(tenantConfig.getProcedure_input());
        //如果有用户自定义的定时规则则用用户级的替代
        if (!checkValueEmpty(tenantConfig.getStandardPollingRule())) {
            ruleDTO.setStandard_polling_rule(JSON.parseObject(JSON.toJSONString(tenantConfig.getStandardPollingRule()), TriggerDTO.class));
        } else {
            ruleDTO.setStandard_polling_rule(templateDO.getStandardPollingRule());
        }
        ruleDTO.setProduct_name(productName);
        ruleDTO.setTenant_id(tenantId);
        ruleDTO.setIs_continue(templateDO.isContinue());
        MonitorRuleCategoryEnum category = templateDO.getCategory();
        ruleDTO.setCategory(category);

        MonitorRuleProductConfig productConfig = null;
        if (category == MonitorRuleCategoryEnum.SCAN || templateDO.getType() == MonitorTypeEnum.ATHENA) {
            Criteria criteria = Criteria.where(MONITOR_RULE_ID_FIELD).is(ruleId).and(PRODUCT_NAME_FIELD).is(productName);
            productConfig = dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
            ruleDTO.setTable(productConfig.getEntityMapping().getTable());
            //多表关联结构
            ruleDTO.setAlias(productConfig.getEntityMapping().getAlias());
            ruleDTO.setSelect_type(productConfig.getEntityMapping().getSelectType());
            List<JoinParamDO> joinParams = productConfig.getEntityMapping().getJoinParams();
            if (joinParams != null && !joinParams.isEmpty()) {
                ruleDTO.setJoinParamsFromDO(joinParams);
            }
            //处理字段映射，模板里记录的是field，产品配置里记录的是field与column的对应关系，通过field进行关联，最终MonitorRule中只需要记录column
            String[] returnColumnTemplate = templateDO.getReturnFields();
            List<FieldMappingConfigDO> fieldMappings = productConfig.getFieldMappings();
            List<ReturnColumnDTO> returnColumns = new ArrayList<ReturnColumnDTO>();
            for (FieldMappingConfigDO fieldMapping : fieldMappings) {
                for (String returnFieldName : returnColumnTemplate)
                    if (fieldMapping.getField().equals(returnFieldName)) {
                        ReturnColumnDTO columnDTO = new ReturnColumnDTO();
                        columnDTO.setName(fieldMapping.getColumn());
                        columnDTO.setAlias(fieldMapping.getAlias());
                        returnColumns.add(columnDTO);
                    }
            }
            ruleDTO.setReturn_columns(returnColumns);

            //处理ActionParams，将DO转换成DTO
            List<ActionParamConfigDO> actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty(actionParamConfigDOs)) {
                List<ActionParamDTO> actionParamDTOs = new ArrayList<>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                //应SmartData要求，数组为空时传null
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }

            //处理DefaultParams，将DO转成DTO
            List<DefaultParamConfigDO> defaultParamsConfigDOs = productConfig.getDefaultParams();
            if (defaultParamsConfigDOs != null) {
                List<DefaultParamDTO> defaultParamDTOs = new ArrayList<>();
                for (DefaultParamConfigDO configDO : defaultParamsConfigDOs) {
                    defaultParamDTOs.add(new DefaultParamDTO(configDO.getName(), configDO.getValues()));
                }
                //应SmartData要求，数组为空时传null
                if (defaultParamDTOs.size() > 0) {
                    ruleDTO.setDefault_params(defaultParamDTOs);
                }
            }
            //20201120 新增是否去重字段
            ruleDTO.setIs_polling_ids(productConfig.getIsPollingIds() == null ? false :
                    productConfig.getIsPollingIds());
        }

        if (category == MonitorRuleCategoryEnum.SCAN && templateDO.getType() == MonitorTypeEnum.CUSTOM) {
            List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(productConfig.getDynamicParams(),
                            tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
//            if(!CollectionUtils.isEmpty(allDynamicParams)){
//                ruleDTO.setDynamic_params(allDynamicParams);
//            }
        }
        if (category == MonitorRuleCategoryEnum.API) {
            List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(),
                            tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
//            if(!CollectionUtils.isEmpty(allDynamicParams)){
//                ruleDTO.setDynamic_params(allDynamicParams);
//            }
            //空的时候传空数组
            ruleDTO.setStatic_params((productConfig == null || CollectionUtils.isEmpty(productConfig.getStaticParams()))
                    ? new ArrayList<>() : productConfig.getStaticParams());
            ruleDTO.setMonitor_action_id(templateDO.getMonitorActionId());
        }

//        //处理ProductUid
//        try {
//            ProductTenantConfig productTenant = this.productTenantConfigDAO.findProductTenant(tenantId,
//            productName, tenantConfig.getType());
//            ruleDTO.setProductUid(productTenant.getProductUid());
//        }
//        catch (Exception e){
//            //允许不存在产品配置，此时设置uid为空
//            ruleDTO.setProductUid("");
//        }

        //产品配置中也可能存在固定条件，需要处理并且与租户级动态条件合并
        ruleDTO.setDynamic_condition(this.mergeProductAndUserDynamicCondition(productConfig == null ? null :
                productConfig.getDynamicCondition(), tenantConfig.getDynamicCondition(), new HashMap()));
        // SD迭代9 需要传个空数组
        if (ruleDTO.getDynamic_params() == null) {
            ruleDTO.setDynamic_params(new ArrayList<>());
        }
        if (ruleDTO.getStatic_params() == null) {
            ruleDTO.setStatic_params(new ArrayList<>());
        }

        return ruleDTO;
    }

    /**
     * 根据规则ID获取系统级侦测配置
     * @param monitorRuleIds 规则ID列表
     * @param tenantId 租户ID
     * @param version  版本
     * @return 侦测配置列表
     * @throws DWBusinessException 业务异常
     */
    public List<MonitorRuleProductConfig> getMonitorRuleProductConfigsById(List<String> monitorRuleIds, String tenantId, String version) throws DWBusinessException {
        Criteria criteria = Criteria.where(MONITOR_RULE_ID_FIELD).in(monitorRuleIds);
        if (StringUtils.isNotEmpty(version)) {
            criteria.and(VERSION_FIELD).is(version);
        }
        return dataPickService.find(criteria, tenantId, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
    }


    private boolean checkValueEmpty(Object object) {
        return ObjectUtils.isEmpty(object) || "{}".equals(String.valueOf(object)) || StringUtils.isEmpty(String.valueOf(object));
    }

    private DynamicConditionDTO mergeProductAndUserDynamicCondition(DynamicConditionConfigDO productCondition,
                                                                    TenantDynamicConditionDO userCondition,
                                                                    Map constantMap) throws DWBusinessException {
        if (productCondition != null && productCondition.getType() != null
                && userCondition != null) {  //产品级条件和用户级条件都存在，则合并规则
            if (!CollectionUtils.isEmpty(userCondition.getOrToTarget())) {//把into中的条件与productCondition中匹配到的列组合成Or关系
                List<IntoDynamicConditionDO> orList = userCondition.getOrToTarget();
                for (IntoDynamicConditionDO or : orList) {
                    productCondition = combineOr(productCondition, or);
                }
            }
            if (userCondition.getUnion() != null) {
                DynamicGroupConditionDTO groupConditionDTO = new DynamicGroupConditionDTO();
                groupConditionDTO.setType(DynamicConditionTypeEnum.AND_GROUP);  // 产品和用户级条件是AND关系
                List<DynamicConditionDTO> conditionDTOs = new ArrayList<DynamicConditionDTO>();
                conditionDTOs.add(DynamicConditionDTO.parseFromDO(productCondition, constantMap));
                conditionDTOs.add(DynamicConditionDTO.parseFromDO(userCondition.getUnion(), constantMap));
                groupConditionDTO.setItems(conditionDTOs);
                return groupConditionDTO;
            }
        }

        if (productCondition != null && productCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(productCondition, constantMap);
        }

        if (userCondition != null && userCondition.getUnion() != null) { // 当产品级动态条件为空的时候，用户级条件中的toTarget失效
            return DynamicConditionDTO.parseFromDO(userCondition.getUnion(), constantMap);
        }

        return null;
    }

    private DynamicConditionConfigDO combineOr(DynamicConditionConfigDO productCondition, IntoDynamicConditionDO or) throws DWBusinessException {
        if (StringUtils.equals(productCondition.getLeft(), or.getTargetColumn())) {
            DynamicConditionConfigDO orConditon = new DynamicConditionConfigDO();
            orConditon.setType(DynamicConditionTypeEnum.OR_GROUP);
            List<DynamicConditionConfigDO> conditionDOs = new ArrayList<>();
            conditionDOs.add(productCondition);
            conditionDOs.addAll(or.getItems());
            orConditon.setItems(conditionDOs);
            return orConditon;
        } else {
            if (CollectionUtils.isEmpty(productCondition.getItems())) {
                return productCondition;
            }
            List<DynamicConditionConfigDO> items = productCondition.getItems();
            for (int i = 0; i < items.size(); i++) {
                items.set(i, combineOr(items.get(i), or));
            }
            return productCondition;
        }
    }

    private DynamicConditionDTO mergeProductAndUserDynamicCondition(DynamicConditionConfigDO productCondition,
                                                                    DynamicConditionConfigDO userCondition,
                                                                    Map constantMap) throws DWBusinessException {
        if (productCondition != null && productCondition.getType() != null
                && userCondition != null && userCondition.getType() != null) {  //产品级条件和用户级条件都存在，则合并规则
            DynamicGroupConditionDTO groupConditionDTO = new DynamicGroupConditionDTO();
            groupConditionDTO.setType(DynamicConditionTypeEnum.AND_GROUP);  // 产品和用户级条件是AND关系
            List<DynamicConditionDTO> conditionDTOs = new ArrayList<DynamicConditionDTO>();
            conditionDTOs.add(DynamicConditionDTO.parseFromDO(productCondition, constantMap));
            conditionDTOs.add(DynamicConditionDTO.parseFromDO(userCondition, constantMap));
            groupConditionDTO.setItems(conditionDTOs);
            return groupConditionDTO;
        }

        if (productCondition != null && productCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(productCondition, constantMap);
        }

        if (userCondition != null && userCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(userCondition, constantMap);
        }

        return null;
    }

    private String fetchGroupKey(DynamicParamsDO dynamicParamsDO) {
        return dynamicParamsDO.getParam_name();
    }

    private List<DynamicParamsDO> mergeProductAndUserDynamicParams(List<DynamicParamsDO> productDynamicParams,
                                                                   List<DynamicParamsDO> userDynamicParams) {
        List<DynamicParamsDO> allDynamicParams = new ArrayList<>();
        Map<String, List<DynamicParamsDO>> collect = null;
        if (!CollectionUtils.isEmpty(userDynamicParams)) {
            collect = userDynamicParams.stream().collect(Collectors.groupingBy(e -> fetchGroupKey(e)));
            allDynamicParams.addAll(userDynamicParams);
        }
        if (!CollectionUtils.isEmpty(productDynamicParams)) {
            if (collect != null) {
                for (DynamicParamsDO dynamicParamsDO : productDynamicParams) {
                    if (!collect.containsKey(this.fetchGroupKey(dynamicParamsDO))) { //租户中没有和产品配置一样的条件，使用产品配置的
                        allDynamicParams.add(dynamicParamsDO);
                    }
                }
            } else { //如果没有租户级动态条件，则直接使用产品级的动态条件
                allDynamicParams.addAll(productDynamicParams);
            }
        }
        return allDynamicParams;
    }

    @Deprecated
    public MonitorRule queryMonitorRule(String ruleId, String tenantId, String tenantVersion) throws Exception {
        log.info("queryMonitorRule ruleId:{} tenantId:{} tenantVersion:{}", ruleId, tenantId, tenantVersion);
        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, tenantId,
                tenantVersion);
        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
            monitorRules = dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion), tenantId);//获取标准侦测
        }
        if (monitorRules == null || monitorRules.size() == 0) {
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue("knowledgegraph.monitorNotFound", ruleId));
        }
        //todo 处理两个以上结果的异常情况
        MonitorRule monitorRule = monitorRules.get(0);

        return monitorRule;
    }

    private MonitorRuleTemplateDO readTemplateFromNeo4j2(String ruleId, String tenantId, String tenantVersion) throws Exception {
        //获取个案新增侦测
//        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, tenantId,
//        tenantVersion);
//        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
//            monitorRules = this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion);//获取标准侦测
//        }
//        if (monitorRules==null || monitorRules.size()==0) {
//            throw new DWBusinessException(String.format("Monitor rule %s not found", ruleId));
//        }
//        //todo 处理两个以上结果的异常情况
//        MonitorRule monitorRule = monitorRules.get(0);
        MonitorRule monitorRule = this.queryMonitorRule(ruleId, tenantId, tenantVersion);
        List<Action> actions = monitorRule.getActions();
        String actionId = null;
        if (StringUtils.isNotEmpty(monitorRule.getActionCommonId())) {
            actionId = monitorRule.getActionCommonId();
        }
        if (actions == null || actions.size() == 0) {
            if (StringUtils.isEmpty(actionId) && !monitorRule.isDataCheck()) { //如果不是數據校驗，必須定義觸發的actionId
                throw new DWBusinessException("P.KG.500.0027", I18nUtils.getValue("knowledgegraph.monitorAction", ruleId));
            }
        } else {
            actionId = actions.get(0).getActionId();
        }

        if (!checkMonitorRuleSchema(monitorRule)) {
            throw new DWBusinessException("P.KG.500.0028",I18nUtils.getValue("knowledgegraph.monitorTemplateInvalid", ruleId));
        }
        MonitorRuleTemplateDO templateDO = new MonitorRuleTemplateDO();

        templateDO.setActionId(actionId);
        templateDO.setActionType(monitorRule.getActionType());
        templateDO.setChillInterval(monitorRule.getChillInterval());
        templateDO.setName(monitorRule.getName());
        templateDO.setCode(monitorRule.getCode());
        templateDO.setType(Enum.valueOf(MonitorTypeEnum.class, monitorRule.getType()));
        templateDO.setStandardPollingRule(JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class));
        templateDO.setContinue(monitorRule.getIsContinue());
        templateDO.setExecuteOnStartup(monitorRule.getExecuteOnStartup());
        templateDO.setScene(JSON.parseObject(monitorRule.getScene(), RuleSceneDTO.class));

        MonitorRuleCategoryEnum category = Enum.valueOf(MonitorRuleCategoryEnum.class, monitorRule.getCategory());
        templateDO.setCategory(category);
        if (category == MonitorRuleCategoryEnum.API || category == MonitorRuleCategoryEnum.SQL_SCRIPT) {
            templateDO.setMonitorActionId(monitorRule.getMonitorActionId());
            String dynamicParams = monitorRule.getDynamicParams();
            if (StringUtils.isNotEmpty(dynamicParams)) {
                templateDO.setDynamicParams(JSON.parseArray(dynamicParams, DynamicParamsDO.class));
            }
//            Object apiSettingObj = monitorRule.getApiSetting();
//            if (apiSettingObj != null) {
//                templateDO.setApiSetting(JSON.parseObject(apiSettingObj.toString(), ApiSettingDTO.class));
//            }
        } else if (category == MonitorRuleCategoryEnum.SCAN || category == MonitorRuleCategoryEnum.CHECK_SUM) {
            //目前条件字段和返回字段作为属性存储，将来如果提取为实体这里要修改。
            String returnFieldsStr = monitorRule.getReturnFields();
            templateDO.setReturnFields(returnFieldsStr.split(","));
            String dynamicConditionFields = monitorRule.getDynamicConditionFields();
            if (StringUtils.isNotEmpty(dynamicConditionFields)) {
                templateDO.setDynamicConditionFields(dynamicConditionFields.split(","));
            }
//            // SCAN类型的CUSTOM也需要取TimeSetting
//            if(templateDO.getType() == MonitorTypeEnum.CUSTOM && StringUtils.isNotEmpty(monitorRule.getTimeSetting
//            ())){
//                templateDO.setTimeSetting(JSON.parseObject(monitorRule.getTimeSetting(), TimeSettingDTO.class));
//            }
        }else if(category == MonitorRuleCategoryEnum.MQTT) { //MQTT类型的侦测数据
            templateDO.setMqttSource(monitorRule.getMqttSource());
            templateDO.setMqttTopic(monitorRule.getMqttTopic());
        }

        return templateDO;
    }

    private MonitorRuleTenantConfigDO readTenantConfig(String ruleId, String tenantId) throws DWBusinessException {
        MongoCollection<Document> col =
                MongoDBManager.getMongoDBManager().getCollectionWithKeys(TENANT_CONFIG_COLLECTION_NAME,
                        TENANT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, MONITOR_RULE_ID_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(MONITOR_RULE_ID_FIELD, ruleId), eq(TENANT_ID_FIELD, tenantId), eq(STATUS_FIELD
                , 1))).first();
        if (doc != null) {
//            MonitorRuleTenantConfigDO tenantConfigDO = new MonitorRuleTenantConfigDO();
//            tenantConfigDO.setMonitorRuleId(ruleId);
//            tenantConfigDO.setStatus(1);
//            tenantConfigDO.setTenantId(tenantId);
//            tenantConfigDO.setProductName(doc.getString(PRODUCT_NAME_FIELD));
            MonitorRuleTenantConfigDO tenantConfigDO = JSON.parseObject(doc.toJson(), MonitorRuleTenantConfigDO.class);
            return tenantConfigDO;
        } else
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantNotEnable", tenantId, ruleId));
    }


    private MonitorRuleProductConfigDO readProductConfig(String ruleId, String productName, String tenantVersion) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(
                PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, PRODUCT_NAME_FIELD, MONITOR_RULE_ID_FIELD,
                VERSION_FIELD);
        //获取的配置必须是启用状态
        Document doc = col.find(and(eq(MONITOR_RULE_ID_FIELD, ruleId),
                eq(PRODUCT_NAME_FIELD, productName),
                eq(VERSION_FIELD, tenantVersion))).first();
        if (doc != null) {
            MonitorRuleProductConfigDO productConfigDO = JSON.parseObject(doc.toJson(),
                    MonitorRuleProductConfigDO.class);
            return productConfigDO;
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableConfiguration", ruleId,
                    productName));
        }
    }


    private boolean CheckMonitorRuleSchema(Map<String, Object> entity) {
        return entity.containsKey(Neo4jConstants.PROPERTY_ID)
                && entity.containsKey(Neo4jConstants.PROPERTY_NAME)
                && entity.containsKey(Neo4jConstants.PROPERTY_MONITOR_RULE_TYPE)
                && entity.containsKey(Neo4jConstants.PROPERTY_MONITOR_RULE_STANDARD_POLLING_RULE)
                && entity.containsKey(Neo4jConstants.PROPERTY_MONITOR_CATEGORY);
    }

    private boolean checkMonitorRuleSchema(MonitorRule monitorRule) {
        return StringUtils.isNotEmpty(monitorRule.getCode())
                && StringUtils.isNotEmpty(monitorRule.getName())
                && StringUtils.isNotEmpty(monitorRule.getType())
                && (MonitorTypeEnum.REPORT.toString().equals(monitorRule.getType())
                || StringUtils.isNotEmpty(monitorRule.getStandardPollingRule())
                ||StringUtils.equals(monitorRule.getType(),MonitorTypeEnum.MQTT.name()))
                && StringUtils.isNotEmpty(monitorRule.getCategory());
    }

    public MonitorRuleDTO getMonitorRule(Map<String, Object> config, String tenantVersion) throws Exception {
        String ruleId = (String) config.get("ruleId");
        String tenantId = (String) config.get("tenantId");
        Map map = (Map) config.get("eocMap");
        EocMapDTO eocMap = null;
        if (map != null && !map.isEmpty()) {
            eocMap = new EocMapDTO();
            eocMap.setEocCompanyId((String) map.get("eocCompanyId"));
            eocMap.setEocSiteId((String) map.get("eocSiteId"));
            eocMap.setEocRegionId((String) map.get("eocRegionId"));
            if (map.get("operation_unit_v2") != null) {
                OperationUnitV2 operationUnitV2 = new OperationUnitV2();
                String eocMappingId = Optional.ofNullable(map.get("operation_unit_v2")).map(o -> {
                    Map unitV2 = MapUtils.getMap(map, "operation_unit_v2");
                    return MapUtils.getString(unitV2, "eoc_mapping_id");
                }).orElse(null);
                operationUnitV2.setEoc_mapping_id(eocMappingId);
                eocMap.setOperation_unit_v2(operationUnitV2);
            }
        }

        MonitorRuleDTO ruleDTO = new MonitorRuleDTO();
        MonitorRuleTemplateDO templateDO = this.readTemplateFromNeo4j2(ruleId, tenantId, tenantVersion);

        MonitorRuleTenantConfig tenantConfig = this.monitorRuleTenantConfigDAO.findTenantConfigByRuleTenantEoc(ruleId
                , tenantId, eocMap);
        String productName = tenantConfig.getProductName();

        ruleDTO.setIs_deduplication(tenantConfig.getIs_deduplication());
        ruleDTO.setBk_info(tenantConfig.getBk_info());
        ruleDTO.setProcedure_name(tenantConfig.getProcedure_name());
        ruleDTO.setProcedure_input(tenantConfig.getProcedure_input());

        //从esp mdc获取运营单元对应的 地端OM数据
        Map ouMap = new HashMap();
        if (eocMap != null) {
            ouMap.put("$eoc_company_id", eocMap.getEocCompanyId());
            ouMap.put("$eoc_site_id", eocMap.getEocSiteId());
            ouMap.put("$eoc_region_id", eocMap.getEocRegionId());

            OmMapDTO omMap = getOM(tenantId, productName, eocMap);
            if (omMap != null && !omMap.isEmpty()) {
                ouMap.put("$om_company_id", omMap.getOmCompanyId());
                ouMap.put("$om_site_id", omMap.getOmSiteId());
                ouMap.put("$om_region_id", omMap.getOmRegionId());
            }
        }

        ruleDTO.setRule_id(ruleId);
        ruleDTO.setAction_id(templateDO.getActionId());
        ruleDTO.setMonitor_type(templateDO.getType());
        ruleDTO.setAction_type(templateDO.getActionType());
        ruleDTO.setChill_interval(templateDO.getChillInterval());

        //支持多个排程日期
        if (tenantConfig.getStandardPollingRules() != null && !CollectionUtils.isEmpty((List) tenantConfig.getStandardPollingRules())) {
            ruleDTO.setStandard_polling_rules(JSON.parseArray(JSON.toJSONString(tenantConfig.getStandardPollingRules()), TriggerDTO.class));
        } else {//没有定义多个排程日期 则按原来单个排程日期处理
            //将单个排程日期也作为数组返回
            List<TriggerDTO> triggers = new ArrayList<>();
            TriggerDTO trigger = templateDO.getStandardPollingRule();
            //如果有用户自定义的定时规则则用用户级的替代
            if (!checkValueEmpty(tenantConfig.getStandardPollingRule())) {
                trigger = JSON.parseObject(JSON.toJSONString(tenantConfig.getStandardPollingRule()), TriggerDTO.class);
            }
            triggers.add(trigger);
            ruleDTO.setStandard_polling_rules(triggers);
        }

        ruleDTO.setProduct_name(productName);
        ruleDTO.setTenant_id(tenantId);
        ruleDTO.setIs_continue(templateDO.isContinue());
        MonitorRuleCategoryEnum category = templateDO.getCategory();
        ruleDTO.setCategory(category);

        Criteria criteria = Criteria.where(MONITOR_RULE_ID_FIELD).is(ruleId).and(PRODUCT_NAME_FIELD).is(productName);
        MonitorRuleProductConfig productConfig = dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");

        if (null == ruleDTO.getIs_deduplication()) {
            ruleDTO.setIs_deduplication(productConfig.getIs_deduplication());
        }
        if (null == ruleDTO.getBk_info()) {
            ruleDTO.setBk_info(productConfig.getBk_info());
        }
        if (null == ruleDTO.getProcedure_name()) {
            ruleDTO.setProcedure_name(productConfig.getProcedure_name());
        }
        if (null == ruleDTO.getProcedure_input()) {
            ruleDTO.setProcedure_input(productConfig.getProcedure_input());
        }

        // 返回给 MonitorEngine 用
        String application = productConfig.getApplication();
        ruleDTO.setApplication(application);

        if (category == MonitorRuleCategoryEnum.PROCEDURE) {
            List<ActionParamConfigDO> actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty(actionParamConfigDOs)) {
                List<ActionParamDTO> actionParamDTOs = new ArrayList<>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                //应SmartData要求，数组为空时传null
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }

        }

        if (category == MonitorRuleCategoryEnum.SCAN || templateDO.getType() == MonitorTypeEnum.ATHENA || category == MonitorRuleCategoryEnum.CDC
                || category == MonitorRuleCategoryEnum.CHECK_SUM) {
//            productConfig = this.monitorRuleProductConfigDAO.findProductConfigByRuleIdAndProductName(ruleId,
//            productName, tenantVersion);
            ruleDTO.setTable(productConfig.getEntityMapping().getTable());


            //多表关联结构
            ruleDTO.setAlias(productConfig.getEntityMapping().getAlias());
            ruleDTO.setSelect_type(productConfig.getEntityMapping().getSelectType());
            List<JoinParamDO> joinParams = productConfig.getEntityMapping().getJoinParams();
            if (joinParams != null && !joinParams.isEmpty()) {
                ruleDTO.setJoinParamsFromDO(joinParams);
            }
            //处理字段映射，模板里记录的是field，产品配置里记录的是field与column的对应关系，通过field进行关联，最终MonitorRule中只需要记录column
            String[] returnColumnTemplate = templateDO.getReturnFields();
            List<FieldMappingConfigDO> fieldMappings = productConfig.getFieldMappings();
            List<ReturnColumnDTO> returnColumns = new ArrayList<ReturnColumnDTO>();
            if (null != returnColumnTemplate) {
                for (FieldMappingConfigDO fieldMapping : fieldMappings) {
                    for (String returnFieldName : returnColumnTemplate)
                        if (fieldMapping.getField().equals(returnFieldName)) {
                            ReturnColumnDTO columnDTO = new ReturnColumnDTO();
                            columnDTO.setName(fieldMapping.getColumn());
                            columnDTO.setAlias(fieldMapping.getAlias());
                            returnColumns.add(columnDTO);
                        }
                }
            }

            ruleDTO.setReturn_columns(returnColumns);

            //处理ActionParams，将DO转换成DTO
            List<ActionParamConfigDO> actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty(actionParamConfigDOs)) {
                List<ActionParamDTO> actionParamDTOs = new ArrayList<>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                //应SmartData要求，数组为空时传null
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }

            //处理DefaultParams，将DO转成DTO
            List<DefaultParamConfigDO> defaultParamsConfigDOs = productConfig.getDefaultParams();
            if (defaultParamsConfigDOs != null) {
                List<DefaultParamDTO> defaultParamDTOs = new ArrayList<>();
                for (DefaultParamConfigDO configDO : defaultParamsConfigDOs) {
                    defaultParamDTOs.add(new DefaultParamDTO(configDO.getName(), configDO.getValues()));
                }
                //应SmartData要求，数组为空时传null
                if (defaultParamDTOs.size() > 0) {
                    ruleDTO.setDefault_params(defaultParamDTOs);
                }
            }
            //20201120 新增是否去重字段
//            ruleDTO.setIs_polling_ids(productConfig.getIsPollingIds() == null ? false : productConfig
//            .getIsPollingIds());
            ruleDTO.setEocLevel(productConfig.getEocLevel());
        }

        if (category == MonitorRuleCategoryEnum.SQL_SCRIPT) {
            //处理ActionParams，将DO转换成DTO
            List<ActionParamConfigDO> actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty(actionParamConfigDOs)) {
                List<ActionParamDTO> actionParamDTOs = new ArrayList<>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                //应SmartData要求，数组为空时传null
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }

           /* List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(productConfig.getDynamicParams(),
                            tenantConfig.getDynamicParams());*/

            List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(),
                            tenantConfig.getDynamicParams());
            if (null != productConfig && !CollectionUtils.isEmpty(productConfig.getDynamicParams())) {
                ruleDTO.setDynamic_params(productConfig.getDynamicParams());
            }else{
                ruleDTO.setDynamic_params(allDynamicParams);
            }

//            ruleDTO.setDynamic_params(allDynamicParams);
            ruleDTO.setScript(StringUtils.isNotEmpty(tenantConfig.getScript()) ? tenantConfig.getScript() :
                    productConfig.getScript());
            ruleDTO.setDb_tag(productConfig.getDbTag());
            ruleDTO.setDb_name(productConfig.getDbName());
        }

        if ((category == MonitorRuleCategoryEnum.SCAN && templateDO.getType() == MonitorTypeEnum.CUSTOM)
                || category == MonitorRuleCategoryEnum.PROCEDURE) {
            List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(productConfig.getDynamicParams(),
                            tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
//            if(!CollectionUtils.isEmpty(allDynamicParams)){
//                ruleDTO.setDynamic_params(allDynamicParams);
//            }
        }
        if (category == MonitorRuleCategoryEnum.API) {
            List<DynamicParamsDO> allDynamicParams =
                    this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(),
                            tenantConfig.getDynamicParams());
            if (null != productConfig && !CollectionUtils.isEmpty(productConfig.getDynamicParams())) {
                ruleDTO.setDynamic_params(productConfig.getDynamicParams());
            }else{
                ruleDTO.setDynamic_params(allDynamicParams);
            }

//            if(!CollectionUtils.isEmpty(allDynamicParams)){
//                ruleDTO.setDynamic_params(allDynamicParams);
//            }
//            productConfig = this.monitorRuleProductConfigDAO.findProductConfigByRuleIdAndProductName(ruleId,
//            productName, tenantVersion);
            if (productConfig != null) {
                //空的时候传空数组
                ruleDTO.setStatic_params(CollectionUtils.isEmpty(productConfig.getStaticParams())
                        ? new ArrayList<>() : productConfig.getStaticParams());
                ruleDTO.setEocLevel(productConfig.getEocLevel());
                ruleDTO.setObserve(productConfig.getObserve());
            }
            ruleDTO.setMonitor_action_id(templateDO.getMonitorActionId());
        }
        if (category == MonitorRuleCategoryEnum.SCHEDULE) {
//            productConfig = this.monitorRuleProductConfigDAO.findProductConfigByRuleIdAndProductName(ruleId,
//            productName, tenantVersion);
            if (productConfig != null) {
                ruleDTO.setEocLevel(productConfig.getEocLevel());
            }
            if (null != templateDO.getScene()) {
                ruleDTO.setScene(templateDO.getScene());
            }
            if (!CollectionUtils.isEmpty(productConfig.getActionParamDefine())) {
                ruleDTO.setActionParamDefine(productConfig.getActionParamDefine());
            }

            if (!CollectionUtils.isEmpty(productConfig.getRecast())) {
                ruleDTO.setRecast(productConfig.getRecast());
            }
        }
        if (productConfig != null) {//20220321  新增是否去重字段
            ruleDTO.setIs_polling_ids(productConfig.getIsPollingIds() == null ? false :
                    productConfig.getIsPollingIds());
        }
//        //处理ProductUid
//        try {
//            ProductTenantConfig productTenant = this.productTenantConfigDAO.findProductTenant(tenantId,
//            productName, tenantConfig.getType());
//            ruleDTO.setProductUid(productTenant.getProductUid());
//        }
//        catch (Exception e){
//            //允许不存在产品配置，此时设置uid为空
//            ruleDTO.setProductUid("");
//        }

        //产品配置中也可能存在固定条件，需要处理并且与租户级动态条件合并
        ruleDTO.setDynamic_condition(this.mergeProductAndUserDynamicCondition(productConfig == null ? null :
                productConfig.getDynamicCondition(), tenantConfig.getDynamicCondition(), ouMap));
        // SD迭代9 需要传个空数组
        if (ruleDTO.getDynamic_params() == null) {
            ruleDTO.setDynamic_params(new ArrayList<>());
        }
        if (ruleDTO.getStatic_params() == null) {
            ruleDTO.setStatic_params(new ArrayList<>());
        }

        // 当侦测创建后需要立即执行时，按sd要求在查询规则详情的时候添加如下结构
        if (BooleanUtils.isTrue(templateDO.getExecuteOnStartup())) {
            Event event = new Event();
            event.setEventType("detect_after_create");
            Extension extension = new Extension();
            List<Event> events = new ArrayList<>();
            events.add(event);
            extension.setEvents(events);
            ruleDTO.setExtension(extension);
        }

        ruleDTO.setExecute_page_size(productConfig.getExecutePageSize());

        if (category == MonitorRuleCategoryEnum.CDC ) {
            ruleDTO.setTable_name(productConfig.getTable_name() == null ? productConfig.getEntityMapping().getTable() : productConfig.getTable_name());

            ruleDTO.setChange_type(productConfig.getChange_type());

            ruleDTO.setEoc_company_id((String)ouMap.get("$eoc_company_id"));

            ruleDTO.setEoc_site_id((String)ouMap.get("$eoc_site_id"));

            ruleDTO.setOperation_unit_v2(eocMap != null ? eocMap.getOperation_unit_v2() : null);

            ruleDTO.setChange_fields(productConfig.getChange_fields());

            ruleDTO.setFilter_condition(productConfig.getFilter_condition());

            ruleDTO.setFilter_params(productConfig.getFilter_params());

            ruleDTO.setIs_need_eoc(productConfig.getIs_need_eoc());

            ruleDTO.setEoc_company_key(productConfig.getEoc_company_key());

            ruleDTO.setEoc_site_key(productConfig.getEoc_site_key());

            ruleDTO.setStart_time(productConfig.getStart_time());

            ruleDTO.setValid(productConfig.getValid());
        }
        //采用策略方式处理，以便后续的扩展，上面原有的实现方式逻辑上不清晰,后续逐步替换
        //后续新增侦测类型只需要继承此类，进行对应的子类实现即可
        AbstractMonitorRuleCategoryService abstractMonitorRuleCategoryService = monitorRuleCategoryServices.stream()
                .filter(service -> service.support(category)).findFirst().orElse(null);
        if(!Objects.isNull(abstractMonitorRuleCategoryService)){
            abstractMonitorRuleCategoryService.execute(ruleDTO,productConfig,templateDO,tenantConfig);
        }
        return ruleDTO;
    }

    private boolean isTenantV2(String tenantId) throws DWBusinessException {
        String tenantToken = null;
        try {
            tenantToken = this.iamService.getTenantToken(tenantId);
        } catch (Exception e) {
            log.error("初始化租户:{}获取token出错，出错原因：{}", tenantId, e.toString());
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getTenantTokenFail"));
        }
        String tenantOperationUnitVersion = iamUtils.getTenantOperationUnitVersion(tenantToken);
        return "v2".equals(tenantOperationUnitVersion);
    }

    public OmMapDTO getOM(String tenantId, String productName, EocMapDTO eocMap) throws ParseException,
            DWBusinessException, IOException {
        OmMapDTO omMap = new OmMapDTO();
        if (StringUtils.isEmpty(productName)) {
            return omMap;
        }
        if (eocMap != null) {
            boolean tenantOperationUnitV2 = isTenantV2(tenantId);
            if (tenantOperationUnitV2 && (eocMap.getOperation_unit_v2() == null || StringUtils.isEmpty(eocMap.getOperation_unit_v2().getEoc_mapping_id()))) {
                return omMap;
            }
            Map re = espUtils.getTenantProductOperationList(tenantId, productName, tenantOperationUnitV2);
            if (tenantOperationUnitV2) {
                List<Map> eocList = (List<Map>) re.get("org_type_mapping");
                for (Map eoc : eocList) {
                    if (eocMap.getOperation_unit_v2().getEoc_mapping_id().equals(MapUtils.getString(eoc, "eoc_mapping_id"))) {
                        String type = MapUtils.getString(eoc, "type");
                        String omMappingId = MapUtils.getString(eoc, "om_mapping_id");
                        if ("company_id".equals(type)) {
                            omMap.setOmCompanyId(omMappingId);
                        } else if ("site_id".equals(type)) {
                            omMap.setOmSiteId(omMappingId);
                        }  else if ("region_id".equals(type)) {
                            omMap.setOmRegionId(omMappingId);
                        }
                    }
                }
            } else {
                List<Map> orgCompany = (List<Map>) re.get("org_type_company");
                if (StringUtils.isNotEmpty(eocMap.getEocCompanyId()) && orgCompany != null && !orgCompany.isEmpty()) {
                    for (Map company : orgCompany) {
                        String eocCompanyId = (String) company.get("eoc_company_id");
                        if (eocMap.getEocCompanyId().equals(eocCompanyId)) {
                            omMap.setOmCompanyId((String) company.get("om_company_id"));

                            if (StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
                                List<Map> orgSite = (List<Map>) company.get("org_type_site");
                                for (Map site : orgSite) {
                                    String eocSiteId = (String) site.get("eoc_site_id");
                                    if (eocMap.getEocSiteId().equals(eocSiteId)) {
                                        omMap.setOmSiteId((String) site.get("om_site_id"));
                                        break;
                                    }
                                }
                            }

                            break;
                        }
                    }
                }
                List<Map> orgRegion = (List<Map>) re.get("org_type_region");
                if (StringUtils.isNotEmpty(eocMap.getEocRegionId()) && orgRegion != null && !orgRegion.isEmpty()) {
                    for (Map region : orgRegion) {
                        String eocRegion = (String) region.get("eoc_region_id");
                        if (eocMap.getEocRegionId().equals(eocRegion)) {
                            omMap.setOmRegionId((String) region.get("om_region_id"));
                            break;
                        }
                    }
                }
            }
        }

        return omMap;
    }

    public Object queryAllMonitor() throws Exception {
        String currentLocale = AthenaUtils.getCurrentLocale();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);

        Query query = new Query();
        query.addCriteria(Criteria.where(MonitorRuleManager.TENANT_ID_FIELD).is(tenantId)
                .and(MonitorRuleManager.STATUS_FIELD).is(1));
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = mongoTemplate.find(query,
                MonitorRuleTenantConfig.class);
        Criteria criteria = Criteria.where("displayType").in("PERIODIC", "PERIODIC_MULTIPLE").and("version").is(tenantVersion);
        List<VariableDefinition> variableDefinitions = dataPickService.find(criteria, VariableDefinition.class, "variableDefinition");
        //CommonUtils.dealLangRecusive(variableDefinitions, currentLocale);
        LanguageUtil.processLocaleLanguage(variableDefinitions,currentLocale);
        Map<String, VariableDefinition> variableDefinitionMap =
                variableDefinitions.stream().collect(Collectors.toMap(VariableDefinition::getExtendData,
                        Function.identity(),
                        (oldValue, newValue) -> newValue));

        List<Application> applications = dataPickService.find(new Criteria(), Application.class, "application");
        List<FieldDescription> paramDescriptions = new ArrayList<>();
        for (Application application : applications) {
            List<FieldDescription> paramDescription = application.getParamDescription();
            if (ObjectUtils.isEmpty(paramDescription)) {
                continue;
            }
            List<FieldDescription> collect = paramDescription.stream().filter(v -> Arrays.asList("PERIODIC",
                    "PERIODIC_MULTIPLE").contains(v.getDisplayType())).collect(Collectors.toList());
            TranslateUtil.dealLangRecusive(collect, currentLocale);
            paramDescriptions.addAll(collect);
        }
        Map<String, FieldDescription> descriptionMap =
                paramDescriptions.stream().collect(Collectors.toMap(FieldDescription::getExtendData,
                        Function.identity(),
                        (oldValue, newValue) -> newValue));

        List<MonitorRule> byVersion = monitorRuleRepository.findByVersion(tenantVersion);
        Map<String, MonitorRule> map = byVersion.stream().collect(Collectors.toMap(MonitorRule::getCode,
                Function.identity(),
                (oldValue, newValue) -> newValue));

        ArrayList<MonitorVO> list = new ArrayList<>();
        for (MonitorRuleTenantConfig m : monitorRuleTenantConfigs) {
            String monitorRuleId = m.getMonitorRuleId();
            if (variableDefinitionMap.containsKey(monitorRuleId)) {
                list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(variableDefinitionMap.get(monitorRuleId).getName()).build());
            } else if (descriptionMap.containsKey(monitorRuleId)) {
                list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(descriptionMap.get(monitorRuleId).getName()).build());
            } else if (map.containsKey(monitorRuleId)) {
                list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(map.get(monitorRuleId).getName()).build());
            }
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    public Object getAllTenantMonitorRule() {
        List<Map> allMonitorRuleCodes = monitorRuleRepository.getAllMonitorRuleCodes();

        List<MonitorRule> monitorRuleList = JSONArray.parseArray(JSON.toJSONString(allMonitorRuleCodes), MonitorRule.class);

        Map<String, MonitorRule> monitorRuleMap = monitorRuleList.stream()
                .collect(Collectors.toMap(MonitorRule::getCode, Function.identity(), (a, b)->b));


        Query query = new Query();

        query.fields().include("tenantId").include("monitorRuleId").include("status").include("eocMap");

        query.addCriteria(Criteria.where("closed").ne(true));

        List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);

        List<Map<String, Object>> result = new ArrayList();

        for(MonitorRuleTenantConfig e: tenantConfigList) {
            MonitorRule monitorRule = monitorRuleMap.get(e.getMonitorRuleId());

            if(monitorRule != null && monitorRule.isDataCheck()){
                continue;
            }

            Map<String, Object> map = new HashMap<>();
            map.put("tenantId", e.getTenantId());
            map.put("ruleId", e.getMonitorRuleId());
            if(e.getEocMap() != null){
                map.put("eocCompanyId", e.getEocMap().getEocCompanyId());
                map.put("eocSiteId", e.getEocMap().getEocSiteId());
            }

            map.put("enable", (e.getStatus() != null && 1 == e.getStatus()) ? "Y" : "N");


            if(monitorRule == null){
                map.put("hasDelete", true);
            }else{
                map.put("backtrackDate", monitorRule.getBacktrackDate());
                map.put("ruleType", StringUtils.equalsIgnoreCase("CDC", monitorRule.getCategory()) ? "2" : "1");
            }

            result.add(map);
        }
        return result;
    }
}
