package com.digiwin.athena.knowledgegraph.rule.category;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleCategoryService;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.rule.model.*;
import com.digiwin.athena.kg.monitorRule.product.ActionParamConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionTypeEnum;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/***
 * @author wangbj
 * 侦测类型为：MQTT的服务实现
 * @Date 2024-07-04
 */
@Service
@Slf4j
public class MQTTMonitorRuleCategoryService extends AbstractMonitorRuleCategoryService {

    @Override
    public MonitorRuleCategoryEnum monitorRuleCategory() {
        return MonitorRuleCategoryEnum.MQTT;
    }

    @Override
    public void execute(MonitorRuleDTO ruleDTO, MonitorRuleProductConfig productConfig, MonitorRuleTemplateDO templateDO, MonitorRuleTenantConfig tenantConfig) throws DWBusinessException {
        log.info("开始封装{}类型的侦测", ruleDTO.getCategory());
        ruleDTO.setMqttSource(templateDO.getMqttSource());
        ruleDTO.setMqttTopic(templateDO.getMqttTopic());
        ruleDTO.setChange_type(StringUtils.isBlank(productConfig.getChange_type())?"create":productConfig.getChange_type());
        //处理ActionParams，将DO转换成DTO
        setActionParams(ruleDTO, productConfig);
        List<TriggerDTO> standardPollingRules = ruleDTO.getStandard_polling_rules();
        if(CollectionUtils.isNotEmpty(standardPollingRules)){
            TriggerDTO triggerDTO = standardPollingRules.stream().findFirst().orElse(null);
            ruleDTO.setStart_time(triggerDTO.getStart_time());
        }
        ruleDTO.setFilter_condition(productConfig.getFilter_condition());
        //List<DynamicConditionConfigDO> filterCondition =productConfig.getFilter_condition();
        List<JSONObject> conversionFilterCondition = new ArrayList<>();
        conversionFilterCondition(ruleDTO, conversionFilterCondition);
  /*      if (CollectionUtils.isNotEmpty(filterCondition)) {
            List<DynamicConditionConfigDO> tmpList = new ArrayList<>();
            //应用端直接配置的filter_condition直接放置到新增的字段
            filterCondition.forEach(res -> {
                originalFilterConditionConversion(tmpList, res, conversionFilterCondition);
            });
            outputItems(tmpList, conversionFilterCondition);
        }*/
        ruleDTO.setConversionFilterCondition(conversionFilterCondition);
        log.info("封装{}类型的侦测结束", ruleDTO.getCategory());
    }

    /***
     * 应用级配置的侦测参数中的过滤条件
     * @param tmpList
     * @param dynamicConditionConfig
     * @param conversionFilterCondition
     */
    private void originalFilterConditionConversion(List<DynamicConditionConfigDO> tmpList,
                                                   DynamicConditionConfigDO dynamicConditionConfig,
                                                   List<JSONObject> conversionFilterCondition) {
        if ((DynamicConditionTypeEnum.SINGLE == dynamicConditionConfig.getType())) {
            DynamicConditionConfigDO dynamicConditionConfigDO = new DynamicConditionConfigDO();
            dynamicConditionConfigDO.setLeft(dynamicConditionConfig.getLeft());
            dynamicConditionConfigDO.setOp(dynamicConditionConfig.getOp());
            dynamicConditionConfigDO.setType(dynamicConditionConfig.getType());
            dynamicConditionConfigDO.setRight(dynamicConditionConfig.getRight());
            dynamicConditionConfigDO.setLeftValueType(dynamicConditionConfig.getLeftValueType());
            dynamicConditionConfigDO.setRightValueType(dynamicConditionConfig.getRightValueType());
            tmpList.add(dynamicConditionConfigDO);
        }
        if (DynamicConditionTypeEnum.AND_GROUP == dynamicConditionConfig.getType()
                || DynamicConditionTypeEnum.OR_GROUP == dynamicConditionConfig.getType()) {
            List<DynamicConditionConfigDO> items = dynamicConditionConfig.getItems();
            if (CollectionUtils.isNotEmpty(items)) {
                List<DynamicConditionConfigDO> groupList = new ArrayList<>();
                items.forEach(res -> originalFilterConditionConversion(groupList, res, conversionFilterCondition));
                outputItems(groupList, conversionFilterCondition);
            }
        }
    }

    /***
     * 基于应用级和租户级的Dynamic_condition转换成新的MQTT的过滤条件
     * @param ruleDTO
     * @param conversionFilterCondition
     */
    private void conversionFilterCondition(MonitorRuleDTO ruleDTO, List<JSONObject> conversionFilterCondition) {
        DynamicConditionDTO dynamicCondition = ruleDTO.getDynamic_condition();
        if(!Objects.isNull(dynamicCondition)){
            DynamicConditionTypeEnum type = dynamicCondition.getType();
            if (DynamicConditionTypeEnum.AND_GROUP == type || DynamicConditionTypeEnum.OR_GROUP == type) {
                dealCondition(conversionFilterCondition, (DynamicGroupConditionDTO) dynamicCondition);
            }else{
                List<DynamicConditionConfigDO> groupList = new ArrayList<>();
                generateConditionConfigDO(dynamicCondition, groupList, conversionFilterCondition);
                outputItems(groupList, conversionFilterCondition);
            }
        }
    }

    private void dealCondition(List<JSONObject> conversionFilterCondition, DynamicGroupConditionDTO dynamicCondition) {
        DynamicGroupConditionDTO dynamicGroupConditionDTO = dynamicCondition;
        List<DynamicConditionDTO> items = dynamicGroupConditionDTO.getItems();
        if (CollectionUtils.isNotEmpty(items)) {
            List<DynamicConditionConfigDO> groupList = new ArrayList<>();
            items.forEach(res -> generateConditionConfigDO(res, groupList, conversionFilterCondition));
            outputItems(groupList, conversionFilterCondition);
        }
    }

    private void outputItems(List<DynamicConditionConfigDO> groupList, List<JSONObject> conversionFilterCondition) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("items", groupList);
        conversionFilterCondition.add(jsonObject);
    }

    private void generateConditionConfigDO(DynamicConditionDTO dynamicCondition, List<DynamicConditionConfigDO> tmpList, List<JSONObject> conversionFilterCondition) {
        if (DynamicConditionTypeEnum.SINGLE == dynamicCondition.getType()) {
            DynamicSingleConditionDTO dynamicSingleConditionDTO = (DynamicSingleConditionDTO) dynamicCondition;
            DynamicConditionConfigDO dynamicConditionConfigDO = new DynamicConditionConfigDO();
            dynamicConditionConfigDO.setLeft(dynamicSingleConditionDTO.getLeft());
            dynamicConditionConfigDO.setOp(dynamicSingleConditionDTO.getOp());
            dynamicConditionConfigDO.setType(dynamicSingleConditionDTO.getType());
            dynamicConditionConfigDO.setRight(dynamicSingleConditionDTO.getRight());
            dynamicConditionConfigDO.setLeftValueType(dynamicSingleConditionDTO.getLeft_value_type());
            dynamicConditionConfigDO.setRightValueType(dynamicSingleConditionDTO.getRight_value_type());
            tmpList.add(dynamicConditionConfigDO);
        } else {
            dealCondition(conversionFilterCondition, (DynamicGroupConditionDTO) dynamicCondition);
        }
    }

    /***
     * 设置actionParams
     * @param ruleDTO
     * @param productConfig
     * @throws DWBusinessException
     */
    private void setActionParams(MonitorRuleDTO ruleDTO, MonitorRuleProductConfig productConfig) throws DWBusinessException {
        List<ActionParamConfigDO> actionParamConfigDOs = productConfig.getActionParams();
        if (CollectionUtils.isNotEmpty(actionParamConfigDOs)) {
            List<ActionParamDTO> actionParamDTOs = new ArrayList<>();
            for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
            }
            //应SmartData要求，数组为空时传null
            if (CollectionUtils.isNotEmpty(actionParamDTOs)) {
                ruleDTO.setAction_params(actionParamDTOs);
            }
        }
    }
}
