package com.digiwin.athena.knowledgegraph.rule.dao;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class MonitorRuleTenantConfigDAO {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private OperationUnitService operationUnitService;

    public MonitorRuleTenantConfig findTenantConfigByRuleIdAndTenantId(String ruleId, String tenantId) throws DWBusinessException {
        return this.findTenantConfigByRuleIdAndTenantIdWithStatus(ruleId, tenantId, 1);
    }

    public MonitorRuleTenantConfig findTenantConfigByRuleIdAndTenantIdWithStatus(String ruleId, String tenantId,
                                                                                 Integer status) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria(Criteria.where(MonitorRuleManager.MONITOR_RULE_ID_FIELD).is(ruleId)
                .and(MonitorRuleManager.TENANT_ID_FIELD).is(tenantId)
                .and(MonitorRuleManager.STATUS_FIELD).is(status));
        MonitorRuleTenantConfig monitorRuleTenantConfig = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if (monitorRuleTenantConfig != null) {
            return monitorRuleTenantConfig;
        } else {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantNotEnable",tenantId,ruleId));
        }
    }

    public MonitorRuleTenantConfig findTenantConfigByRuleTenantEoc(String ruleId, String tenantId, EocMapDTO eocMap) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = Criteria.where(MonitorRuleManager.MONITOR_RULE_ID_FIELD).is(ruleId)
                .and(MonitorRuleManager.TENANT_ID_FIELD).is(tenantId);
//                .and(MonitorRuleManager.STATUS_FIELD).is(1);
//        if (eocMap != null) {
//            Criteria c = null;
//            if (StringUtils.isNotEmpty(eocMap.getEocCompanyId())) {
//                c = Criteria.where("eocMap.eocCompanyId").is(eocMap.getEocCompanyId());
//            }
//            if (StringUtils.isNotEmpty(eocMap.getEocSiteId())) {
//                if (c == null) {
//                    c = Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId());
//                } else {
//                    c = new Criteria().andOperator(c, Criteria.where("eocMap.eocSiteId").is(eocMap.getEocSiteId()));
//                }
//            }
//            if (StringUtils.isNotEmpty(eocMap.getEocRegionId())) {
//                if (c == null) {
//                    c = Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId());
//                } else {
//                    c = new Criteria().andOperator(c, Criteria.where("eocMap.eocRegionId").is(eocMap.getEocRegionId()));
//                }
//            }
//            if (c != null) {
//                criteria = new Criteria().andOperator(criteria, c);
//            }
//        }
        criteria = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(eocMap), criteria);
        query.addCriteria(criteria);

        MonitorRuleTenantConfig monitorRuleTenantConfig = this.mongoTemplate.findOne(query, MonitorRuleTenantConfig.class);
        if(monitorRuleTenantConfig != null){
            return monitorRuleTenantConfig;
        }else{
            throw new DWBusinessException("P.KG.500.0029",I18nUtils.getValue("knowledgegraph.tenantNotEnableWithEoc",tenantId,JSON.toJSONString(eocMap),ruleId));
        }
    }
}
