package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.po.DimensionParam;

import java.util.List;
/**
 * 元数据相关服务
 * @javadoc
 */
public interface IActionService extends DWService {

    /**
     * 根据actionID从neo4元数据删除数据
     * @param actionId 元数据id
     * @return
     * @throws Exception
     */
    Object delete(String actionId) throws Exception;

    /**
     * 根据服务名称获取产品信息
     * @param serviceName
     * @return
     * @throws Exception
     */
    String getProductName(String serviceName) throws Exception;

    /**
     * 根据actionId获取元数据
     * @param actionId 元数据id
     * @return
     * @throws Exception
     */
    Object getMetadata(String actionId) throws Exception;

    /**
     * 根据规则id获取元数据
     * @param ruleId 规则id
     * @return
     * @throws Exception
     */
    Object getActionRule(String ruleId) throws Exception;

    /**
     * 根据元数据id和租户id获取元数据
     * @param actionId 元数据id
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    Object getCompositAction(String actionId, String tenantId) throws Exception;

    /**
     * 获取元数据
     * @param actionId 元数据id
     * @param language 多语言
     * @return
     * @throws Exception
     */
    Object getMetadata(String actionId, String language) throws Exception;

    /**
     * 保存api元数据
     * @param apiName api名称
     * @param productName 产品名称
     * @param productVersion 产品版本号
     * @return
     * @throws Exception
     */
    Object put(String apiName, String productName, String productVersion) throws Exception;

    /**
     * 同步API
     * @param tenantId
     * @return
     * @throws Exception
     */
    Object put(String tenantId) throws Exception;

    /**
     * 根据元数据id获取元数据定义
     * @param actionId
     * @return
     * @throws Exception
     */
    Object getDefinition(String actionId) throws Exception;

    /**
     * 根据元数据id和租户id获取执行路径
     * @param actionId 元数据id
     * @param tenantId 租户id
     * @param existingActionParams 元数据参数
     * @return
     * @throws Exception
     */
    Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams) throws Exception;

    /**
     * 根据元数据id和租户id获取执行路径
     * @param actionId 元数据id
     * @param tenantId 租户id
     * @param existingActionParams 元数据参数
     * @param existingSysParams 系统参数
     * @return
     * @throws Exception
     */
    Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams, List<String> existingSysParams) throws Exception;

    /**
     * 保存元数据配置
     * @param data 元数据
     * @return
     * @throws Exception
     */
     Object postActionConfig(DimensionParam data) throws Exception;

    /**
     * 根据元数据id查询执行信息
     * @param actionId 元数据id
     * @return
     * @throws Exception
     */

     Object postQueryExecutionInfo(String actionId) throws Exception;

     /**
     * 获取全量api
     * @return
     * @throws Exception
     */
    Object getEspApi() throws Exception;

    /**
     * 根据服务名称获取产品
     * @param serviceName 服务名称
     * @return
     * @throws Exception
     */
    Object getProduct(String serviceName) throws Exception;

    /**
     * 将服务名称和产品名称更新到租户服务配置
     * @param serviceName 服务名称
     * @param productName 产品名称
     * @return
     * @throws Exception
     */
    Object postSetProduct(String serviceName, String productName) throws Exception;

    /**
     * 根据元数据id查询元数据信息
     * @param actionId 元数据id
     * @return
     * @throws Exception
     */
    Object postQueryActionInfo(String actionId) throws Exception ;

    /**
     * 根据租户id获取产品集合
     * @return
     * @throws Exception
     */
    List<String> getTenantProductList() throws Exception;

    /**
     * 根据ruleCode获取侦测规则中的sourceIdKey
     * @param ruleCode
     * @return
     * @throws Exception
     */
    Object getSourceIdKey(String ruleCode) throws Exception;

    /**
     * 根据元数据集合id获取执行路径
     * @param actionIds 元数据id集合
     * @return
     * @throws Exception
     */
    Object postQueryExecutionInfo(List<String> actionIds) throws Exception;

    /**
     * 保存mdc api元数据
     * @param messageStr 元数据
     * @return
     */
    @AllowAnonymous
    Object postAddMdcApiMetadataToNeo4j(String messageStr);

    /**
     * 根据节点类型获取敏数问答结果显示样式
     * @param nodeType 比较："1"，分布："2"，构成："3"，联系："4"
     * @param reportRelationFir 关系联系1
     * @param reportRelationSec 关系联系2
     * @param reportRelationThi 关系联系3
     * @param reportRelationFou 关系联系4
     * @return
     */
    @AllowAnonymous
    String postFindLastNodeShapeType(String nodeType,String reportRelationFir,String reportRelationSec,String reportRelationThi,String reportRelationFou);

    /**
     * ADE调用获取元数据的平铺结构
     * @param actionIds 元数据id集合
     * @return
     * @throws Exception
     */
    Object postMetaDataStruct(List<String> actionIds) throws Exception;

    /**
     * 批量获取多个actionId对应的执行路径
     * @param actionIds 元数据集合
     * @return
     * @throws Exception
     */
    Object postMetricActionData(List<String> actionIds) throws Exception;
}
