package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;

import java.util.List;
import java.util.Map;

/**
 * 任务相关服务
 * @javadoc
 */
public interface IActivityService extends DWService {
    /**
     * 根据任务code从mongeDB获取任务输入数据
     * 替换至接口：/restful/standard/datamap/view/taskInputData
     * @param activityId 任务code
     * @return 输入流
     * @throws DWBusinessException
     */
    @Deprecated
    Object getInputData(String activityId) throws DWBusinessException;

    /**
     * 根据任务code从neo4j获取输入流，并设置活动id
     * @param taskId 项目code
     * @param activityId 任务code
     * @return 输入流
     * @throws DWBusinessException
     */
    Object getInputData(String taskId,String activityId) throws DWBusinessException;

    /**
     * 根据异常排除计划id在neo4j获取活动信息
     * @param planId 异常排除计划id
     * @param dataName 数据表名
     * @return 活动信息
     * @throws DWBusinessException
     */
    Object postQueryCompositionBySolvePlan(String planId, String dataName) throws DWBusinessException;

    /**
     *
     * @param taskId
     * @param sequenceFields
     * @param keyFields
     * @param conditionFields
     * @param dueDateField
     * @param data
     * @return
     * @throws Exception
     */
    Object postComposition(String taskId, List<String> sequenceFields, List<String> keyFields, Map<String, String> conditionFields, String dueDateField, List<Map> data) throws Exception;

    /**
     * 获取组合任务
     * @param compositionId
     * @return
     * @throws Exception
     */
    Object getComposition(String compositionId) throws Exception;

    /**
     * 更新 task
     * 替换至接口：/restful/standard/datamap/view/updateTask
     * @param data 任务数据
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postUpdateActivity(Activity data) throws Exception;

    /**
     * 更新 task
     * 替换至接口：/restful/standard/datamap/view/updateTask
     * @param data 任务数据
     * @param operationUnit 运营单元
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postUpdateActivity(Activity data, OperationUnit operationUnit) throws Exception;

    /**
     * 获取复制API的配置数据
     * @param codeList 组件code列表
     * @param tenantId 租户id
     * @param appCode 应用code
     * @return
     * @throws Exception
     */
    Object postCopyApiStatus(List<String> codeList,String tenantId,String appCode) throws Exception;

    /**
     * 根据应用code获取签核任务
     * 替换至接口：/restful/standard/datamap/activity/allApproveActivityByApp
     * @param applicationCode 应用code
     * @param locale 语言
     * @return 任务
     * @throws Exception
     */
    @Deprecated
    Object getAllApproveActivityByApp(String applicationCode, String locale) throws Exception;

    /**
     * 根据应用code
     * @param applicationCode 应用code
     * @return
     * @throws Exception
     */
    Object getManualActivityByApp(String applicationCode) throws Exception;

    /**
     * 根据 project 找 task列表
     * 替换至接口：/restful/standard/datamap/view/tasksByProject
     * @param taskCode 项目code
     * @param locale 多语言
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getActivityByTask(String taskCode, String locale) throws Exception;

    /**
     * 根据活动id获取活动配置
     * @param activityIdList
     * @return
     * @throws Exception
     */
    Object postAuthorityConfigs(List<String> activityIdList) throws Exception;

    /**
     * 利用应用参数值、产品、条件筛选获取的签核任务信息
     * @param applicationCode 应用code
     * @param locale 多语言
     * @param paramCodeAndValue 参数
     * @return
     * @throws Exception
     */
    Object postAllApproveActivityByApp(String applicationCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception;

    /**
     * 根据 project 找 task列表
     * 替换至接口：/restful/standard/datamap/activity/activityByTask
     * @param taskCode 任务code
     * @param appCode 应用code
     * @param locale 多语言
     * @param paramCodeAndValue 参数
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postActivityByTask(String taskCode, String appCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception;

    /**
     * 根据插件id增加活动配置
     * @param code 活动id
     * @param variableId 变量id
     * @param pluginId 插件id
     * @return
     * @throws DWBusinessException
     */
    Object getAddActionsByPluginId(String code,String variableId,String pluginId) throws DWBusinessException;

    /**
     * 根据插件id清除活动配置
     * @param code 活动code
     * @param pluginId 插件id
     * @return
     * @throws DWBusinessException
     */
    Object getCleanActionsByPluginId(String code,String pluginId) throws DWBusinessException;
}