package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.report.hz.model.dataCollectGroup.DelConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.report.dataBoard.DataBoardGroupConfig;

import java.util.List;
/**
 * 敏数2.0 - 收藏数据分组服务
 * @javadoc
 */
public interface IDataBoardGroupService extends DWService {
    /**
     * 保存收藏数据分组配置
     * @param config 配置数据
     * @return
     */
    Object postAddDataBoardGroupConfig(List<DataBoardGroupConfig> config) throws DWException;

    /**
     * 删除收藏数据分组配置
     * @param delConfig 配置信息
     * @return
     * @throws Exception
     */
    Object postRemoveDataBoardGroupConfig(DelConfigDTO delConfig) throws Exception;

    /**
     * 查询收藏数据分组配置
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     * @throws Exception
     */
    Object getQueryDataBoardGroupConfig() throws DWBusinessException, NoSuchFieldException, IllegalAccessException, Exception;
}
