package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.report.hz.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.report.dataBoard.DataBoardConfig;

/**
 * 敏数2.0 - 收藏数据服务
 * @javadoc
 */
public interface IDataBoardService extends DWService {
    /**
     * 新增收藏数据配置
     * @param config
     * @return
     * @throws Exception
     */
    Object postAddDataBoardConfig(DataBoardConfig config) throws Exception;

    /**
     * 获取收藏数据配置
     * @return
     * @throws Exception
     */
    Object getQueryDataBoardConfig() throws Exception;
    Object getQueryDataBoardConfig(String asaCode) throws Exception;
    Object postQueryBoardStep(String questionId);

    Object postQueryBoardById(String boardId) throws Exception;

    /**
     * 查询收藏数据配置
     * @param queryConfig 查询条件
     * @return
     * @throws Exception
     */
    Object postQueryDataBoardConfig(QueryConfigDTO queryConfig) throws Exception;

    /**
     * 删除收藏数据配置
     * @param boardId 配置信息id
     * @return
     * @throws Exception
     */
    Object postRemoveDataBoardConfig(String boardId) throws Exception;

    /**
     * 删除收藏看板的问题
     * @param questionId 问题id
     * @return
     * @throws Exception
     */
    Object postRemoveDataBoardQuestion(String questionId) throws Exception;
}
