package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.report.hz.model.dataCollectGroup.DataCollectGroupConfig;
import com.digiwin.athena.kg.report.hz.model.dataCollectGroup.DelConfigDTO;

import java.util.List;

/**
 * 敏数 - 收藏数据分组服务
 * @javadoc
 */
public interface IDataCollectGroupService extends DWService {
    /**
     * 保存收藏数据分组配置
     * @param config 配置数据
     * @return
     */
    Object postAddDataCollectGroupConfig(List<DataCollectGroupConfig> config);

    /**
     * 删除收藏数据分组配置
     * @param delConfig 配置信息
     * @return
     * @throws Exception
     */
    Object postRemoveDataCollectGroupConfig(DelConfigDTO delConfig) throws Exception;

    /**
     * 查询收藏数据分组配置
     * @param config 配置信息
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     * @throws Exception
     */
    Object postQueryDataCollectGroupConfig(DataCollectGroupConfig config) throws DWBusinessException, NoSuchFieldException, IllegalAccessException, Exception;
}
