package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffDto;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffSumInfoDto;

import java.util.List;

/**
 * 数字员工服务
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @taskId <br>
 * @CreateDate 2021/11/11 <br>
 * @see: com.digiwin.athena.knowledgegraph.service.IDigitalStaffService <br>
 * @javadoc
 */
public interface IDigitalStaffService extends DWService {

    /**
     * 获取数字员工列表视图
     * detialOrNot:Y是列表视图，N是图例视图
     * @return
     * @throws Exception
     */
    List<DigitalStaffDto> getList() throws Exception;

    /**
     * 数字员工图例视图/列表视图
     *     locale:Y是列表视图，N是图例视图
     * @return
     * @throws Exception
     */
    DigitalStaffSumInfoDto getVisualizeList() throws Exception;
}