package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.Duty;

/**
 * 职能服务
 * @javadoc
 */
public interface IDutyService extends DWService {
    /**
     * 根据code获取职能信息
     * @param code 职能code
     * @return
     */
    @AllowAnonymous
    Object getDutyByCode(String code);

    /**
     * 获取全量职能数据
     * @return
     */
    @AllowAnonymous
    Object getList();

    /**
     * 同步职能数据
     * @return
     * @throws DWBusinessException
     */
    Object syncAllDuty() throws DWBusinessException;

    /**
     * 根据应用code和租户id同步职能数据
     * @param token token校验码
     * @param appCode 应用code
     * @param tenantId 租户id
     * @return
     * @throws DWBusinessException
     */
    Object syncAllDuty(String token, String appCode, String tenantId) throws Exception;

    /**
     * 根据token同步职能数据
     * @param token token校验码
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object syncAllDuty(String token) throws DWBusinessException;

    /**
     * 测试方法
     * @param p 参数
     * @return
     */
    @AllowAnonymous
    Object getTest(String p);

}
