package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.knowledgegraph.po.MechanismFunction;
import com.digiwin.athena.knowledgegraph.po.MechanismReq;
import com.digiwin.athena.knowledgegraph.po.PhPMechanismApiCommonConfig;
import com.digiwin.athena.knowledgegraph.vo.mechanism.MechanismApiInfoReqVO;

import java.util.List;

/**
 * 机制设计
 * @author zhangtuo
 * @version 1.0
 * @javadoc
 */
public interface IMechanismDesignService extends DWService {

    /**
     * 通过机制code查询设计时的机制原理以及详情，包含系统级以及组户级合并后结果
     * @param req 查询条件
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object postMechanismDetail(MechanismReq req) throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 通过原理code查询机制参数
     * @param req 查询条件
     * @return
     * @throws Exception
     */
    Object postMechanismVariableByPrinciple(MechanismReq req) throws Exception;

    /**
     * 通过机制设计时能力code查询设计时能力详情
     * @param req
     * @return
     * @throws DWBusinessException
     */
    Object postMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 保存设计时机制原理
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postSaveMechanismTheory(MechanismReq req) throws DWBusinessException;

    /**
     * 保存设计时机制能力
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postSaveMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 通过code删除设计时机制原理
     * @param req 参数
     * @return
     * @throws DWBusinessException
     */
    Object postDeleteMechanismTheory(MechanismReq req) throws DWBusinessException;

    /**
     * 通过code删除设计时机制能力
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postDeleteMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 应用机制设计时转换为logic，同时注意父级原理也需要转化为运行时原理
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postApplyMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 撤销生效，实则删除转换后成果
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postUnApplyMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 重置设计时能力，恢复为系统级，（不确定是否需要提供这个接口）
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postResetTenantMechanismCapacity(MechanismReq req) throws DWBusinessException;

    /**
     * 通过应用code查询项目以及项目下任务
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postProject(MechanismReq req) throws DWBusinessException;

    /**
     * 通过项目或者任务code查询元数据信息
     * @param req 入参
     * @return
     * @throws DWBusinessException
     */
    Object postDataMeta(MechanismReq req) throws DWBusinessException;

    /**
     * 根据应用code和类型获取基础数据
     * @param pattern 类型
     * @param appCode 应用code
     * @return
     * @throws Exception
     */
    Object getBasicDataList(String pattern, String appCode) throws Exception;


    /**
     * 根据应用code，机制类型和零件
     * @param req
     * @return
     * @throws DWBusinessException
     */
    Object postPartInfo(MechanismReq req) throws DWBusinessException;

    /**
     * 获取消息模板
     * @param appCode 应用code
     * @return
     */
    Object postTemplateDataList(String appCode);

    /**
     * 获取应用是否可以选择模板
     * @param appCode 应用code
     * @return
     */
    Object postTemplateSelectResult(String appCode);

    /***
     * 获取API根据appCode【应用编码】获取action列表
     * @param appCode app编码
     */
    List<GetActionLocaleResponseDTO> getControlAbilityOutcomesApi(String appCode);

    /**
     * 获取机制原理下的机制参数
     * @param req 查询参数
     * @return
     */
    Object postMechanismParameterDic(MechanismReq req);

    /**
     * 保存php常规参数
     * @param req
     * @return
     */
    Object postSetPhpApiCommonParam(PhPMechanismApiCommonConfig req);

    /**
     * 获取机制api方法
     * @param code api参数code
     * @param metaFieldType 数据字段类型
     * @return
     */
    Object getMechanismCapacityAdaptation(String code, String metaFieldType);

    /**
     * 获取机制自定义函数
     * @param projectCode 项目code
     * @param taskCode 任务code
     * @param fieldCode 字段code
     * @param dataType 字段类型
     * @return
     * @throws DWException
     */
    Object getMechanismFunction(String projectCode, String taskCode, String fieldCode, String dataType) throws DWException;

    /**
     * 保存机制自定义函数
     * @param req 保存数据元
     * @return
     * @throws DWException
     */
    Object postMechanismFunction(MechanismFunction req) throws DWException;

    /**
     * 获取机制中用的到的api方法
     * @param req 查询入参
     * @return
     * @throws Exception
     */
    Object postQueryApiInfo(MechanismApiInfoReqVO req) throws Exception;

    /**
     * 系统级一次编译
     * @param application 应用code
     * @param mechanismCodes 机制code
     * @throws DWBusinessException 异常
     */
    @Deprecated
    void postApplyMechanisms(String application, List<String> mechanismCodes) throws Exception;

    /**
     * 系统级一次编译
     * @param application 应用code
     * @param mechanismCodes 机制code
     * @param version 版本
     * @throws DWBusinessException 异常
     */
    @AllowAnonymous
    void postApplyMechanisms(String application, String version, List<String> mechanismCodes) throws Exception;

    /**
     * 系统级一次编译，个案应用会绑定租户id
     * @param application 应用code
     * @param mechanismCodes 机制code
     * @param version 版本
     * @param version 租户id
     * @throws DWBusinessException 异常
     */
    @AllowAnonymous
    void postApplyMechanisms(String application, String version, List<String> mechanismCodes, List<String> tenantIds) throws Exception;
}
