package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BacklogVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BatchNoticeVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.NoticeVO;
import com.digiwin.athena.mechanism.widgets.check.CheckAccordingToStandard;
import com.digiwin.athena.mechanism.widgets.condition.BusinessCondition;
import com.digiwin.athena.mechanism.widgets.condition.ByQuantityCondition;
import com.digiwin.athena.mechanism.widgets.condition.ByTimeCondition;

import java.util.List;
import java.util.Map;

/**
 * 机制增强服务
 *
 * @javadoc
 */
public interface IMechanismEnhancementService extends DWService {

    /**
     * 根据运营单元获取任务信息
     * @param taskCode        任务code
     * @param taskList        任务列表
     * @param checkDataSource 数据源
     * @param tenantId        租户
     * @param eocField        eoc业务字段
     * @return
     * @throws Exception
     */
    Object postTaskInformPersonByEoc(String taskCode, List<BacklogVO> taskList, String checkDataSource, String tenantId, String eocField) throws Exception;

    /**
     * 根据条件过滤数据
     *
     * @param taskId                   任务id
     * @param taskList                 任务列表
     * @param checkDataSource          数据源
     * @param tenantId                 租户
     * @param checkAccordingToStandard 检查标准
     * @return
     * @throws DWBusinessException
     * @throws Exception
     */
    @AllowAnonymous
    Object postTaskBizData(String taskId, List<BacklogVO> taskList, String checkDataSource, String tenantId, CheckAccordingToStandard checkAccordingToStandard) throws DWBusinessException, Exception;

    /**
     * 发送消息
     *
     * @param taskList
     * @param tenantId
     * @param msg
     * @return
     */
    Object postMessageHand(List<BacklogVO> taskList, String tenantId, String msg);

    /**
     * 根据条件过滤数据
     *
     * @param dataList          数据集
     * @param businessCondition 业务条件
     * @param quantityCondition 数量条件
     * @return
     */
    Object postFilterByQuantity(List dataList, BusinessCondition businessCondition, ByQuantityCondition quantityCondition);

    /**
     * 根据code获取服务，并调用服务获取数据
     *
     * @param code     活动code
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    Object postControlBaseData(String code, String tenantId) throws Exception;

    /**
     * 调用esp接口
     *
     * @param espApi        esp接口
     * @param requestParams 请求参数
     * @return result
     * @throws Exception
     */
    Map<String, Object> postInvokeEspApi(String espApi, List<Map<String, Object>> requestParams) throws Exception;

    /**
     * 调用esp接口 V2
     *
     * @param espApi        esp接口
     * @return result
     * @throws Exception
     */
    Map<String, Object> postInvokeEspApiV2(String espApi, String jsonBody,Map<String, Object> eocMap,Map<String, Object> headerMap) throws Exception;

    /**
     * 根据条件过滤数据
     *
     * @param dataList          数据集
     * @param businessCondition 业务条件
     * @param byTimeCondition   时间条件
     * @return result
     * @throws DWBusinessException
     */
    JSONArray postFilterByTimeCondition(List dataList, BusinessCondition businessCondition, ByTimeCondition byTimeCondition) throws DWBusinessException;

    /****
     * 发送通知
     * @param taskBizData 业务接口数据集
     * @param tenantId 租户
     * @param message 消息
     * @param businessFields 业务字段
     * @return
     */
    Object postSendNotice(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields);

    /****
     * 发送通知
     * @param taskBizData 业务接口数据集
     * @param tenantId 租户
     * @param message 消息
     * @param businessFields 业务字段
     * @param userIds 页面选择的通知人
     * @return
     */
    Object postSendNotice(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields, List<String> userIds);

    /**
     * 带分组聚合函数的消息推送
     *
     * @param noticeVO
     * @return
     */
    Object postSendNotice(NoticeVO noticeVO) throws Exception;

    /**
     * 批量消息推送
     *
     * @param batchNoticeVOS 批量消息
     * @param tenantId       租户
     * @return
     */
    @AllowAnonymous
    Object postBatchSendNotice(List<BatchNoticeVO> batchNoticeVOS, String tenantId) throws Exception;

    /**
     * 根据code获取服务，并调用服务获取数据
     *
     * @param code 活动code
     * @return
     * @throws Exception
     */
    Object postControlBaseData(String code) throws Exception;
}
