package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;

import java.util.List;

/**
 * 指标服务
 *
 * @javadoc
 */
public interface IMetricService extends DWService {
    /**
     * 根据应用code查询指标数据源
     *
     * @param appCode 应用编码
     * @param version 版本号
     * @return 发布结果
     * @throws Exception 异常
     */
    Object postMetricDataSource(String appCode, String version) throws Exception;

    /**
     * 根据指标ID查询指标数据源
     *
     * @param indicatorIds 指标ID列表
     * @return 发布结果
     * @throws DWBusinessException 业务异常
     */
    Object postMetricDataSource(List<String> indicatorIds) throws DWBusinessException;

    /**
     * 根据指标ID查询指标数据源
     *
     * @param indicatorIds 指标ID列表
     * @return 发布结果
     * @throws DWBusinessException    业务异常
     * @throws NoSuchFieldException   字段异常
     * @throws IllegalAccessException 访问异常
     */
    Object postMetricQuerySchema(List<String> indicatorIds) throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 根据指标ID查询指标业务
     * @param tenantId 租户ID
     * @param appCode 应用编码
     * @param codes 指标编码列表
     * @return
     * @throws DWBusinessException
     */
    Object postMetricBusinessByCode(String tenantId, String appCode, List<String> codes) throws DWBusinessException;
}