package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleGroup;
import com.digiwin.athena.knowledgegraph.service.model.EocMapAndProductDTO;

import java.util.List;
import java.util.Map;

/**
 * 侦测规则服务
 * @javadoc
 */
public interface IMonitorRuleService extends DWService {
    /**
     * 待废除接口
     * @param conditions
     * @param count
     * @param language
     * @return
     * @throws Exception
     */
    @Deprecated
    @AllowAnonymous
    Object getQuery(Map<String, Object> conditions, int count, String language) throws Exception;

    /**
     * 待废除接口
     * @param language
     * @return
     * @throws Exception
     */
    @Deprecated
    @AllowAnonymous
    Object getList(String language) throws Exception;

    /**
     * 根据规则id获取规则数据
     * @param ruleId 规则id
     * @param tenantId 租户id
     * @param language 多语言
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object get(String ruleId, String tenantId, String language) throws Exception;

    /**
     * 根据规则id获取规则数据
     * @param ruleId 规则id
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object get(String ruleId, String tenantId) throws Exception;

    /***
     * SD服务回调的接口：SD下的ME和CDME两个服务都会调用
     * 业务逻辑：根据侦测相关的参数获取具体的侦测全部数据
     * @author
     *  wangbj
     * @param config
     * {
     *         "ruleId":"ud_c_d145f20d8de347f7a38e1f27ef5aa258AthenaQCTestW",
     *         "tenantId":"AthenaQCTestW",
     *         "eocMap":{
     *             "eocCompanyId":"",
     *             "eoSiteId":"",
     *             "eocRegionId":""
     *     }
     * }
     * @return
     * @throws Exception
     */
    Object postQuery(Map<String, Object> config) throws Exception;

    /**
     * 通过云端运营单元获取地端运营单元工厂信息
     * @param eocMapAndProduct 云端运营单元
     * @return
     * @throws Exception
     */
    List<Map> postOmSiteInfo(EocMapAndProductDTO eocMapAndProduct) throws Exception;

    /**
     * 获取数据映射监控配置
     * @param actionId
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object getDataMapMonitorConfig(String actionId) throws Exception;

    /**
     * 获取租户生效过的侦测信息
     * @return
     * @throws Exception
     */
    Object getTenantMonitor() throws Exception;


    /**
     * 获取所有租户生效过的侦测信息，用于数据比对
     */
    Object getAllTenantMonitorRule() throws Exception;

    /***
     * 对侦测类型进行分组初始化接口
     * @param dataList
     * @return
     * @throws Exception
     */
    Object postInitMonitorRuleGroup(List<InitMonitorRuleGroup> dataList)throws Exception;

    /**
     * 按照应用返回该应用下的所有的侦测信息
     * @param appCode 应用code
     * @return 侦测信息
     * @throws Exception 抛出异常
     */
    Object getTenantMonitorRuleByApp(String appCode) throws Exception;
}
