package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.ActionIntentions;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kg.report.hz.model.sence.ActionRelation;
import com.digiwin.athena.kg.report.hz.model.sence.ActionReportConfig;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.SceneTemplate;

import java.io.IOException;
import java.util.List;

/**
 * 场景服务
 * @title: ISceneService
 * @author: linc
 * @date 2023/12/4 15:03
 * @version: 1.0
 * @javadoc
 */
public interface ISceneService extends DWService {
    /**
     * 创建场景图谱
     * @param reportScene 报表场景数据
     * @return
     * @throws DWBusinessException
     */
    Object postCreateSceneMaps(ReportSceneDTO reportScene) throws DWBusinessException;

    /**
     * 查询场景图谱
     * @param code 场景code
     * @return
     * @throws Exception
     */
    Object postQuerySceneMaps(String code) throws Exception;

    /**
     * 根据模板查询场景
     * @param templateCode 模板code
     * @param targetId 目标id
     * @param dimension 维度集合
     * @return
     * @throws Exception
     */
    Object postQuerySceneByTemplateAndTarget (String templateCode,String targetId,List<String> dimension) throws Exception;

    /**
     * 场景图谱转换侦测
     * @param code 场景code
     * @param name 场景名称
     * @param appCode 应用code
     * @param appName 应用名称
     * @param productName 产品名称
     * @return
     * @throws Exception
     */
    Object postCreateMonitorRule(String code, String name, String appCode, String appName, String productName) throws Exception;

    /**
     *  设计器发版，切版调用, 向语义推送action元数据信息
     * @param appCodes 应用code集合
     * @param tenantId 租户id
     * @param version 版本
     * @return
     */
    Object postPushData(List<String> appCodes,String tenantId,String version);

    /**
     * 删除数据源
     * @param type 类型
     * @param sceneCode 场景code
     * @return
     */
    Object postRemoveData(String type, String sceneCode);

    /**
     * 创建action和代表性话术的关系
     * @param actionIntentions
     * @return
     */
    Object postCreateActionIntentions(ActionIntentions actionIntentions);

    /**
     * 查询action和代表性话术的关系
     * @param actionIds 元数据id集合
     * @return
     */
    Object postQueryActionIntentions(List<String> actionIds );

    /**
     * 创建action的二次计算定义
     * @param actionRecast 元数据
     * @return
     */
    Object postCreateActionRecast(ActionRecast actionRecast);

    /**
     * 查询action的二次计算的定义
     * @param actionIds 元数据id集合
     * @return
     */
    List<ActionRecast> postQueryActionRecast(List<String> actionIds );

    /**
     * 创建元数据
     * @param actionRelation 元数据关系
     * @return
     */
    Object postCreateActionRelation(ActionRelation actionRelation);

    /**
     * 查询action关系 并按约定返回数据
     * @param actionIds 元数据id集合
     * @return
     * @throws Exception
     */
    Object postQueryActionRelation(List<String> actionIds) throws Exception;

    /**
     * 创建action和场景报表的呈现关系
     * @param actionReportConfig 元数据和场景报表配置
     * @return
     */
    Object postCreateActionReportConfig(ActionReportConfig actionReportConfig);

    /**
     * 查询action和场景报表的呈现关系
     * @param actionIds 元数据id
     * @return
     * @throws IllegalAccessException
     * @throws NoSuchFieldException
     * @throws DWBusinessException
     */
    List<Object> postQueryActionReportConfig(List<String> actionIds ) throws IllegalAccessException, NoSuchFieldException, DWBusinessException;

    /**
     * 查询资产中心模型数据的元数据
     * @param modelIds 模型id集合
     * @return
     * @throws IOException
     */
    @Deprecated
    List<GetActionLocaleResponseDTO> postModelCenterMetaData (List<String> modelIds) throws IOException;

    /**
     * 创建pulling 的图谱
     * @return
     * @throws DWBusinessException
     */
    @Deprecated
    Object getCreatePullingDataMap() throws DWBusinessException;

    /**
     * 创建图谱action的MapsTo
     * @return
     */
    @Deprecated
    Object getCreatePullingDataRelation();

    /**
     * 查询场景模板
     * @param templateCodes 模板code
     * @return
     */
    @Deprecated
    Object postQuerySceneTemplate(List<String> templateCodes);

    /**
     * 创建场景模板
     * @param sceneTemplate 场景模板
     * @return
     */
    @Deprecated
    Object postCreateSceneTemplate(SceneTemplate sceneTemplate);

    /**
     * 根据场景code获取
     * @param sceneCode 场景code
     * @return
     * @throws Exception
     */
    Object getSceneSchema(String sceneCode) throws Exception;

    /**
     * 根据目标名称分组取场景
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object postQuerySceneIntention() throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 根据场景code和目标名称分组取场景
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object postQuerySceneIntentions() throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 根据租户id查询所有可用的场景和指标
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object postQuerySceneByTenantId(String tenantId);

    /**
     * 根据大屏code查询应用信息
     * @param sceneCode 大屏code
     * @return 应用信息
     * @throws Exception
     */
    Object postQueryApplicationByCode(String sceneCode) throws Exception;

    /**
     * 根据应用code查询数据集信息
     * @param appCode 应用code
     * @return 数据集信息
     * @throws Exception
     */
     Object postQueryDataSetsByApp(String appCode) throws Exception;
}
