package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.knowledgegraph.domain.activity.ExportAndImportConfig;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.config.MergeRule;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardLabel;
import com.digiwin.athena.knowledgegraph.domain.task.CardOrder;
import com.digiwin.athena.knowledgegraph.domain.task.TBBReportReplacer;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.knowledgegraph.task.model.CardConditionQueryDTO;
import com.digiwin.athena.knowledgegraph.task.model.CardConfigQueryDTO;
import com.digiwin.athena.knowledgegraph.vo.FindTaskFromUserRequest;
import com.digiwin.athena.knowledgegraph.vo.SemcDictOption;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldRequest;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldVO;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 任务定义接口
 *
 * @javadoc
 */
public interface ITaskService extends DWService {

    /**
     * 获取项目定义
     * 替换至接口：/restful/standard/datamap/task/definition
     * @param taskId
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getDefinition(String taskId) throws Exception;

    /**
     * 获取项目定义，含租户级配置
     * 替换至接口：/restful/standard/datamap/task/definitionWithMultiLanguage
     * @param taskId 项目定义编码
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getDefinitionWithMultiLanguage(String taskId) throws Exception;

    /**
     * 获取项目定义，含租户级配置
     * 替换至接口：/restful/standard/datamap/task/definitionWithMultiLanguage
     * @param taskId 项目定义编码
     * @param pageCode 页面类型了；例如：project-card
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getDefinitionWithMultiLanguage(String taskId, String pageCode) throws Exception;

    /**
     * 根据项目编码和运营单元获取项目（pageView视图数据，项目任务目标，里程碑），过滤里程碑中无授权任务数据
     * 替换至接口：/restful/standard/datamap/task/definitionWithMultiLanguage
     * @param taskId 项目编码
     * @param operationUnit 运营单元
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postDefinitionWithMultiLanguage(String taskId, OperationUnit operationUnit) throws Exception;

    /**
     * 根据项目code获取项目及其下任务
     * 替换至接口：/restful/standard/datamap/task/activities
     * @param taskId 项目code
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getActivities(String taskId) throws Exception;

    /**
     * 根据项目code获取项目及其下任务
     * 替换至接口：/restful/standard/datamap/task/activitiesWithMultiLanguage
     * @param taskId 项目code
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getActivitiesWithMultiLanguage(String taskId) throws Exception;

    /**
     * 模糊查询报表, 基础数据录入, 手动创建项目
     * @param condition 查询条件 - name
     * @return
     * @throws Exception
     */
    Object getQueryItem(String condition) throws Exception;

    /**
     * 根据任务code从neo4j中获取任务
     * @param activityCode 任务code
     * @return
     * @throws Exception
     */
    Object getActivityNamesByCode(String activityCode) throws Exception;

    /**
     * 根据产品code更新TBB报表数据
     * @param reportReplacer
     * @return
     * @throws Exception
     */
    Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception;

    /**
     * 根据mode类型和productCode获取报表
     * @param mode mode类型
     * @param productCode 产品code
     * @return
     * @throws Exception
     */
    Object getTBBReports(String mode, String productCode) throws Exception;

    /**
     * 获取公共基础资料
     * @return
     * @throws Exception
     */
    Object getBaseDataApplication() throws Exception;

    /**
     * 根据类型获取报表/基础资料/手动创建项目
     * @param pattern
     * @return
     * @throws Exception
     */
    Object getActivitiesByPattern(String pattern) throws Exception;

    /**
     * 获取导入导出配置
     */
    List<ExportAndImportConfig> getExportAndImportConfig() throws Exception;

    /**
     * 获取报表/基础资料/手动创建项目
     * @return
     * @throws Exception
     */
    Object getActivitiesInfoByPattern() throws Exception;

    /**
     * 根据类型,应用code获取报表/基础资料/手动创建项目
     * @param pattern
     * @param appCode
     * @return
     * @throws Exception
     */
    Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception;

    /**
     * 根据类型获取报表/基础资料/手动创建项目并排序
     * @param pattern
     * @return
     * @throws Exception
     */
    Object getActivitiesAndSortByPattern(String pattern) throws Exception;

    /**
     * 根据任务code获取任务，包含页面设计数据和租户级配置数据
     * 替换至接口：/restful/service/datamap/task/activityDefinition
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return 任务
     * @throws Exception
     */
    @Deprecated
    Object getActivityDefinition(String activityId, String pageCode) throws Exception;

    /**
     * 从neo4j中获取任务定义
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面类型code
     * @return
     * @throws Exception
     */
    Object getActivityDefinition(String taskId, String activityId, String pageCode) throws Exception;

    /**
     * 根据任务code获取任务配置 - 是否合并
     * @param taskId 项目code
     * @param activityId 任务code
     * @return 任务配置 - 是否合并
     * @throws Exception
     */
    Object getActivityConfig(String taskId, String activityId) throws Exception;

    /**
     * 根据code获取合并规则
     * @param type 类型
     * @param code 项目/任务code
     * @return
     * @throws Exception
     */
    Object getTenantMergeConfig(String type, String code) throws Exception;

    /**
     * 保存合并规则
     * @param mergeRule 合并规则
     * @return
     * @throws Exception
     */
    Object postTenantMergeRule(MergeRule mergeRule) throws Exception;

    /**
     * 根据code和类型删除合并规则
     * @param type 类型
     * @param code 项目/任务code
     * @param application 应用
     * @return
     * @throws Exception
     */
    Object postDeleteTenantMergeRule(String type, String code, String application) throws Exception;

    /**
     * 查询任务定义，包含任务流程和页面信息
     * 替换至接口：/restful/standard/datamap/task/activityDefinition
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面类型code
     * @param operationUnit 运营单元
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception;

    /**
     * 根据项目code和任务code获取发起当前签核任务的任务code
     * 替换至接口：/restful/service/datamap/task/activityStartTargetCode
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面类型code
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception;

    /**
     * 根据活动id查询任务
     * 替换至接口：/restful/service/datamap/task/taskInfoFromDataMap
     * @param activityId 活动id
     * @return
     */
    @Deprecated
    Object getTaskInfoFromDataMap(String activityId);

    /**
     * 获取任务定义
     * @param taskId 项目code
     * @param activityId 任务code
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getActivityDefinitionWithMultiLanguage(String taskId, String activityId, String tenantId) throws Exception;

    /**
     * 获取租户授权下的项目和任务
     * 替换至接口：/restful/service/datamap/task/manualList
     * @return
     * @throws DWBusinessException
     */
    @Deprecated
    Object getManualList() throws DWBusinessException;

    /**
     * 获取项目/任务详情
     * 替换至接口：/restful/service/datamap/task/detail
     * @param taskId 项目/任务code
     * @return
     * @throws DWBusinessException
     */
    @Deprecated
    Object getDetail(String taskId) throws DWBusinessException;

    /**
     * 根据项目code获取输入流
     * 替换至接口：/restful/service/datamap/task/inputData
     * @param taskId
     * @return
     * @throws DWBusinessException
     */
    @Deprecated
    Object getInputData(String taskId) throws DWBusinessException;

    /**
     * 根据任务code获取异常排除计划
     * @param taskId 项目code
     * @param activityId 任务code
     * @return
     * @throws DWBusinessException
     */
    Object getSolvePlan(String taskId, String activityId) throws DWBusinessException;

    /**
     * 根据任务code获取异常排除计划
     * @param activityId 任务code
     * @return
     * @throws DWBusinessException
     */
    Object getSolvePlan(String activityId) throws DWBusinessException;

    /**
     * 获取异常排除计划
     * @param dataName
     * @return
     * @throws DWBusinessException
     */
    Object getSolvePlanByData(String dataName) throws DWBusinessException;

    /**
     * 活动动态任务
     * @param taskId 任务code
     * @param compositionId 合成id
     * @return
     * @throws Exception
     */
    Object getActivitiesWithMultiLanguage(String taskId, String compositionId) throws Exception;

    /**
     * 从neo4j中获取任务
     * @return
     * @throws DWBusinessException
     */
    Object getAllTasks() throws DWBusinessException;

    /**
     * 根据项目code获取应用数据
     * @param taskId 项目code
     * @return
     * @throws DWBusinessException
     */
    Object getAppSubscription(String taskId) throws DWBusinessException;

    /**
     * 保存任务数据
     * @param data 任务待更新数据
     * @return
     * @throws DWBusinessException
     */
    Object postUpdateTaskConfig(Task data) throws DWBusinessException;

    /**
     * 保存任务数据
     * @param data 任务待更新数据
     * @param operationUnit 运营单元数据
     * @return
     * @throws DWBusinessException
     */
    Object postUpdateTaskConfig(Task data, OperationUnit operationUnit) throws DWBusinessException;

    /**
     * 根据活动编号获取关联任务
     * @param tenantId 租户
     * @param activityId 活动code
     * @return
     * @throws Exception
     */
    Object postQueryRelatedTask(String tenantId, String activityId) throws Exception;

    /**
     * 根据应用code获取租户授权下的任务
     * 替换至接口：/restful/service/datamap/task/taskByApp
     * @param applicationCode 应用code
     * @return
     * @throws Exception
     */
    @Deprecated
    Object getTaskByApp(String applicationCode) throws Exception;

    /**
     * 根据应用code获取租户授权下的任务
     * @param applicationCode 应用code
     * @param operationUnit 运营单元数据
     * @return
     * @throws Exception
     */
    Object postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception;

    /**
     * 根据项目code设置完成时间
     * @param taskId 项目code
     * @param operationUnit 运营单元
     * @return
     * @throws Exception
     */
    Object postFixTask(String taskId, OperationUnit operationUnit) throws Exception;

    /**
     * 根据业务code获取报表
     * @param bizCode 业务code
     * @param type 类型
     * @return
     * @throws Exception
     */
    Object getReportsByBizCodeNType(String bizCode, Integer type) throws Exception;

    /**
     * 根据业务code获取报表
     * @param bizCode 业务code
     * @param type 类型
     * @param userId 用户id
     * @return
     * @throws Exception
     */
    Object getReportsByBizCodeNType(String bizCode, Integer type, String userId) throws Exception;
// TODO liugla 2024/10/29 17:45 注释
    /**
     *
     * @param code
     * @param type
     * @return
     * @throws Exception
     */
    Object getDataEntryByBizCodeNType(String code, Integer type) throws Exception;
// TODO liugla 2024/10/29 17:45 注释
    /**
     *
     * @param bizCode
     * @param type
     * @param reportCode
     * @return
     * @throws Exception
     */
    Object getReportByBizCodeNTypeNReportCode(String bizCode, Integer type, String reportCode) throws Exception;
// TODO liugla 2024/10/29 17:45 注释
    /**
     *
     * @param reportCode
     * @param type
     * @return
     * @throws Exception
     */
    Object getBizsByReportCodeNType(String reportCode, Integer type) throws Exception;

    /**
     * 查 project
     * 替换至接口：/restful/service/datamap/view/projectListBasic
     * @param taskIdList
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postAuthorityConfigs(List<String> taskIdList) throws Exception;

    /**
     * 批量查询任务定义，包含任务流程和页面信息
     * 替换至接口：/restful/service/datamap/batch/taskDetails
     * @param taskId 项目code
     * @param activityIds 任务code集合
     * @param pageCode 页面类型code
     * @return
     * @throws Exception
     */
    @Deprecated
    Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode) throws Exception;

    /**
     * 批量查询任务定义，包含任务流程和页面信息
     * @param taskId 项目code
     * @param activityIds 任务code集合
     * @param pageCode 页面类型code
     * @param operationUnit 运营单元
     * @return
     * @throws Exception
     */
    Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode, OperationUnit operationUnit) throws Exception;

    /**
     * 从neo4j中获取全量的任务和活动
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postQueryTaskAndActivityInfo() throws Exception;

    // TODO liugla 2024/10/29 13:14 注释
    /**
     *
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postQueryAllProjectAndTaskInfo() throws Exception;

    /**
     * 保存租户级摘要配置
     * @param tenantSummaryFields
     * @return
     * @throws Exception
     */
    Object postTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception;

    /**
     * 删除租户级摘要配置
     * @param tenantSummaryFields
     * @return
     * @throws Exception
     */
    Object deleteTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception;

    /**
     * 根据组件类型以及组件code集合获取应用组件关系
     * @param type
     * @param codes
     * @return
     * @throws DWBusinessException
     */
    Object postApplicationRelation(String type, Set<String> codes) throws DWBusinessException;

    /**
     * 根据视图code获取视图数据
     * @param viewCodes  视图code
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object postDataViewList(List<String> viewCodes) throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 获取任务卡卡片标签
     * @param code 任务code
     * @return
     * @throws DWBusinessException
     */
    Object getCardLabel(String code) throws DWBusinessException;

    /**
     * 根据任务code和页面code类型获取卡片标签
     * @param code 任务code
     * @param pageCode 页面类型code
     * @return
     * @throws DWBusinessException
     */
    Object getCardLabel(String code,String pageCode) throws DWBusinessException;

    /**
     * 保存卡片标签
     * @param cardLabel 卡片标签源数据
     * @return
     * @throws Exception
     */
    Object postSaveCardLabel(CardLabel cardLabel) throws Exception;

    /**
     * 根据任务code删除标签
     * @param code 任务code
     * @return
     * @throws Exception
     */
    Object getDeleteCardLabel(String code) throws Exception;

    /**
     * 根据任务code和页面类型code删除卡片标签
     * @param code 任务code
     * @param pageCode 页面类型code
     * @return
     * @throws Exception
     */
    Object getDeleteCardLabel(String code,String pageCode) throws Exception;

    /**
     * 获取卡片分组配置
     * @return
     * @throws DWBusinessException
     */
    Object getCardGroup() throws Exception;

    /**
     * 保存卡片分组配置
     * @param cardGroup 卡片分组配置
     * @return
     * @throws DWBusinessException
     */
    Object postSaveCardGroup(CardGroup cardGroup) throws DWBusinessException;

    /**
     * 获取卡片分组配置数据状态
     * @return
     * @throws DWBusinessException
     */
    Object getCardGroupStatus() throws DWBusinessException;

    /**
     * 删除分组卡片设置
     * @return
     * @throws DWBusinessException
     */
    Object getDeleteCardGroup() throws Exception;

    /**
     * 获取卡片配置，包含分组，标签和排序信息
     * @return
     * @throws Exception
     */
    Object getCardConfig() throws Exception;

    /**
     * 敏捷任务卡 - 获取租户授权下的应用和任务
     * @return
     * @throws Exception
     */
    Object getTenantTask() throws Exception;

    /**
     * 保存任务卡片排序配置数据
     * @param cardOrder 卡片排序
     * @return
     * @throws Exception
     */
    Object postSaveTaskOrder(CardOrder cardOrder) throws Exception;

    /**
     * 删除CardOrder，并清空缓存
     * @return 任务数据
     * @throws DWBusinessException
     */
    Object getDeleteTaskOrder() throws DWBusinessException;

    /**
     * 查询任务排序状态
     * @return 任务数据
     * @throws Exception
     */
    Object getTaskOrderStatus() throws Exception;

    /**
     * 敏捷任务卡 --- 根据任务类型排序
     * @return 任务数据，包含排序orderWeight
     * @throws Exception
     */
    Object getTaskOrder() throws Exception;

    /**
     * 查询当前租户授权的应用
     * 将交付设计器排序，改为阶梯查询，达到优化性能目的
     * @return
     * @throws Exception
     */
    Object getTenantApplications() throws Exception;

    /**
     * 根据应用code从应用组件关系表中查询任务
     * @param code 应用code
     * @return 任务数据
     * @throws Exception
     */
    Object getTenantTasksByAppCode(String code) throws Exception;

    /**
     * 我的任务/我的项目/团队任务/团队项目，查询租户级/应用级别的自定义配置
     *
     * @param cardConfigQuery
     * @return {@link Object}
     * @date 2024/4/28 11:03
     * @author gengwei
     **/
    Object postCardConfigByType(CardConfigQueryDTO cardConfigQuery) throws DWBusinessException;

    /**
     * 查询交付设计器，待办工作台配置条件
     * @param cardConditionQuery
     * @return
     */
    Object postQueryCondition(CardConditionQueryDTO cardConditionQuery);

    /**
     * 查任务卡项目卡页面设定
     * 替换至接口：/restful/service/datamap/task/pageUIElement
     * @param code pageUI表的唯一code  原先pageView表的code
     * @param activityId 任务卡code
     * @param pageCode 类型
     * @return UIElement
     * @throws Exception
     */
    @Deprecated
    Object getPageUIElement(String code, String activityId, String pageCode) throws Exception;

    /**
     * 根据tenantId获取SystemHooks元素
     *
     * @param tenantId 租户id
     * @param pageCodes 页面设计code
     * @return
     * @throws Exception
     */
    Object postSystemHooksByTenantId(String tenantId, List<String> pageCodes) throws Exception;

    /**
     * 获取SystemHooks元素
     *
     * @param md5 activityIds通过md5加密变成长32位，用于缓存key，减少key长度
     * @param activityIds 任务code集合
     * @param pageCodes 页面设计code集合
     * @return
     * @throws Exception
     */
    Object postSystemHooks(String md5, List<String> activityIds, List<String> pageCodes) throws Exception;

    /**
     * 查询pageView中taskCardField字段里的值
     * @return
     * @throws DWException
     */
    List<TaskCardFieldVO> postViewTaskCardField(@Valid TaskCardFieldRequest taskCardFieldRequest);

    /**
     * 获取分组编码值
     * @param type
     * @return
     * @throws Exception
     */
    List<SemcDictOption> getCodeOptions(String type) throws Exception;

    /**
     * 获取分组编码
     * @return
     * @throws DWBusinessException
     */
    List<SemcDictOption> getTenantGroupConfigCode() throws DWBusinessException;

    /**
     * 根据应用 code 查询基础资料/报表
     *
     * @param pattern
     * @return
     * @throws Exception
     */
    Object postDataEntryAndReportByAppCode(String appCode, String pattern) throws Exception;

    /**
     * 查询任务
     * 调 datamap /view/taskList
     * 包装一下，是因为直接调 datamap，language 没有处理，需要通过 kg 包装一下才行
     *
     * @return
     * @throws Exception
     */
    Object postTaskList(Map<String, Object> query) throws Exception ;

    /**
     * 查询项目（排查手动发起的项目）
     * 调 datamap /business/projectExcludeMainlineByAppCode
     * 包装一下，是因为直接调 datamap，language 没有处理，需要通过 kg 包装一下才行
     *
     * @param appCode
     * @return
     */
    Object postProjectExcludeMainlineByAppCode(String appCode);

    /**
     * 查询项目
     * 调 datamap /view/projectListBasic
     * 包装一下，是因为直接调 datamap，language 没有处理，需要通过 kg 包装一下才行
     *
     * @param query
     * @return
     */
    Object postProjectListBasic(Map<String, Object> query);

    /**
     * 查询项目
     * 调 datamap /view/projectList
     * 包装一下，是因为直接调 datamap，language 没有处理，需要通过 kg 包装一下才行
     *
     * @param query
     * @return
     */
    Object postProjectList(Map<String, Object> query);

    /**
     * 查询用户拥有权限的任务列表
     * @param findTaskFromUserRequest
     * @return
     * @throws Exception
     */
    Object postFindTaskFromUser(FindTaskFromUserRequest findTaskFromUserRequest) throws Exception;

}

