package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;

/**
 * 测试类
 * @author : Tuo
 * @create: 2022-05-12 16:45
 * @version 1.0
 * @javadoc
 **/
@DWRestfulService
public interface ITestService  extends DWService {

    /**
     * 测试方法1
     * @param input 参数
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test01", method = {DWRequestMethod.GET})
    String getTest01(String input);
    /**
     * 测试方法2
     * @param input 参数
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test02", method = {DWRequestMethod.GET})
    String getTest02(String input,String paas);
    /**
     * 测试方法3
     * @param input 参数
     * @return
     */
    @DWRequestMapping(path = "/test/test03", method = {DWRequestMethod.GET})
    String getTest03(String input) throws DWBusinessException;
    /**
     * 测试方法4
     * @param input 参数
     * @return
     */
    @DWRequestMapping(path = "/test/test04", method = {DWRequestMethod.GET})
    String getTest04(String input);

    /**
     * 测试方法5
     * @param input 参数
     * @return
     */
    @DWRequestMapping(path = "/test/test05", method = {DWRequestMethod.POST})
    String postTest05(String input);

    /**
     * 测试方法 - 制程
     * @param key 键值
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/mock01", method = {DWRequestMethod.GET})
    Object getMock01(String key);

    /**
     * 获取Redis中所有key，并解析出string类型key的value，并统计value的大小，并统计大于10KB的value的数量
     * @param pattern    匹配的key
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/bigRedisKeyValue", method = {DWRequestMethod.GET})
    String getBigRedisKeyValue(String pattern);

    /**
     * 获取Redis中所有key，并解析出string类型key的value，并统计value的大小，并统计大于10KB的value的数量
     * @param pattern    匹配的key
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/bigRedisKeyValueScan", method = {DWRequestMethod.GET})
    String getBigRedisKeyValueScan(String pattern);

    /**
     * 测试DAP升级Json问题
     * @param content    content
     * @return
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/test/test06", method = {DWRequestMethod.GET})
    String getTest06(String content) throws DWBusinessException;

    /**
     * 测试方法 - 查询mock数据
     * @param type mock数据类型
     * @param condition 查询条件
     * @return
     */
    @DWRequestMapping(path = "/test/mockMetaData", method = {DWRequestMethod.GET})
    Object getMockMetaData(String type, String condition);
}
