package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BacklogVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BatchNoticeVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.NoticeVO;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismEnhancementService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.mechanismEnum.VariableTypeEnum;
import com.digiwin.athena.mechanism.widgets.check.CheckAccordingToStandard;
import com.digiwin.athena.mechanism.widgets.condition.*;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.*;
import java.util.Map.Entry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class MechanismEnhancementService implements IMechanismEnhancementService {

    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    ESPUtils espUtils;
    @Autowired
    IamService iamService;
    @Autowired
    EocService eocService;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    DataMapService dataMapService;

    @Autowired
    IMechanismService iMechanismService;

    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object postTaskInformPersonByEoc(String taskCode, List<BacklogVO> taskList, String checkDataSource, String tenantId, String eocField) throws Exception {
        Activity taskDto = getActivity(taskCode);
        //从定义中获取数据源对应的actionId和组装请求的入参
        Map<String, Object> dataSource = (Map<String, Object>) taskDto.getDataSources().get("data");
        if (CollectionUtils.isEmpty(dataSource)) {
            return null;
        }
        Map<String, Object> result = new HashMap<>();
        if(CollectionUtils.isEmpty(taskList)){
            result.put("data", new ArrayList<>());
            return result;
        }
        Set<String> eocIds = new HashSet<>();
        if (!CollectionUtils.isEmpty(taskList)) {
            taskList.forEach(task -> {
                String checkField = eocField;
                String[] checkFieldArray = checkField.split("\\.");
                String checkFieldHead = checkFieldArray[0]; //project_info
                String checkFieldBody = checkFieldArray[1]; //executor_no
                Map<String, Object> executeResult = task.getExecuteResult();
                if (!CollectionUtils.isEmpty(executeResult)) {
                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) executeResult.get(
                        checkFieldHead);
                    dataList.forEach(dataItem -> {
                        if (dataItem.get(checkFieldBody) instanceof Collection) {
                            eocIds.addAll(
                                (Collection<? extends String>) dataItem.get(checkFieldBody));
                        } else {
                            eocIds.add((String) dataItem.get(checkFieldBody));
                        }
                    });
                }
            });
        }
        Set<String> strings = transformToUserId(eocIds, tenantId);
        List<String> collect = strings.stream().collect(Collectors.toList());
        result.put("data", collect);
        return result;
    }

    private Activity getActivity(String taskCode) {
        Object taskDef = taskService.getTaskInfoFromDataMap(taskCode);
        return JsonUtil.toObject(JSON.toJSONString(taskDef), Activity.class);
    }

    private Set<String> transformToUserId(Set<String> eocIds, String tenantId) throws Exception {
        String token = iamService.getTenantToken(tenantId);
        List<String> userIds = eocService.getUserIdsByStaffs(new ArrayList<>(eocIds), token);
        return new HashSet<>(userIds);
    }

    @Override
    public Object postTaskBizData(String taskCode, List<BacklogVO> taskList, String checkDataSource, String tenantId, CheckAccordingToStandard checkAccordingToStandard) throws Exception {
        //校验参数的合法性
        HashMap<String, Object> result = new HashMap<>();
        if (!StringUtils.equals("fixInterval", checkAccordingToStandard.getStandardPollingRule().getTimeType())
                || CollectionUtils.isEmpty(taskList)
                || !StringUtils.equals("day", checkAccordingToStandard.getStandardPollingRule().getInterval())) {
            result.put("data", Collections.EMPTY_LIST);
            return result;
        }

        Activity taskDto = getActivity(taskCode);

        Map<String, Object> dataSource = (Map<String, Object>) taskDto.getDataSources().get("data");
        if (CollectionUtils.isEmpty(dataSource)) {
            return Collections.EMPTY_LIST;
        }

        //获取应用服务名
        String serviceName = getServiceName(tenantId, dataSource);
        String token = iamService.getTenantToken(tenantId);
        String finalServiceName = serviceName;

        // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(taskDto.getApplication())) {
            loginInfo.setApplication(taskDto.getApplication());
        }
        //填充任务列表的执行结果
        fillTaskExecuteResult(taskList, tenantId, dataSource, token, finalServiceName);

        //根据checkAccordingToStandard,检验异常数据
        List<BacklogVO> taskResult = checkFilterTaskData(taskList, checkAccordingToStandard,tenantId);
        result.put("data", taskResult);
        return result;
    }

    @SneakyThrows
    @Override
    public Object postSendNotice(List taskBizData, String tenantId, String message,String businessFields) {
        // TODO 调查消息重复发送问题，临时修改为 warn 级别日志
        log.warn("开始发送信息：{}", message);
        // 正则表达式匹配 ${}
        Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");
        if (!containsExpression(message, pattern)) {
            return degradeToBatchSend(taskBizData, tenantId, message, businessFields);
        }
        if(!CollectionUtils.isEmpty(taskBizData)){
            String token = iamService.getTenantToken(tenantId);
            taskBizData.forEach(res->{
                Map object = JsonUtil.toObject(JsonUtil.toJsonString(res), Map.class);
                Object acceptList = object.get(businessFields);
                if(!Objects.isNull(object.get(businessFields))){
                    if(acceptList instanceof  List){
                      List  executorNoList=(List)acceptList;
                        for (Object executorNo : executorNoList) {
                            ObjectMapper objectMapper=new ObjectMapper();
                            Map map = objectMapper.convertValue(res, Map.class);
                            Set<String> userIds = null;
                            try {
                                userIds = transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                                String msgReplace = symbolStringMessage(message, map);
                                log.warn("替换后的消息：{}",msgReplace);
                                if(!CollectionUtils.isEmpty(userIds)){
                                    iamService.dispatcherMessage(token,  userIds.stream().collect(
                                        Collectors.toList()), msgReplace, tenantId);
                                }
                            } catch (Exception e) {
                                log.error("发送信息失败{}",e);
                            }
                        }
                    } else if (acceptList instanceof String) {
                        ObjectMapper objectMapper=new ObjectMapper();
                        Map map = objectMapper.convertValue(res, Map.class);
                        try {
                            String msgReplace = symbolStringMessage(message, map);
                            log.warn("替换后的消息：{}",msgReplace);
                            Set<String> userIds = transformToUserId(new HashSet<>(Collections.singletonList(String.valueOf(acceptList))), tenantId);
                            iamService.dispatcherMessage(token, new ArrayList<>(userIds), msgReplace, tenantId);
                        } catch (Exception e) {
                            log.error("发送信息失败{}",e);
                        }
                    }
                    /*   */
                }
            });
        }
        return ResultBean.success(null);
    }

    private Object degradeToBatchSend(List taskBizData, String tenantId, String message, String businessFields) throws Exception {
        return degradeToBatchSend(taskBizData, tenantId, message, businessFields, null);
    }

    private Object degradeToBatchSend(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields, List<String> userIds) throws Exception {
        //降级为整批发送,所有用户相同消息,且去重
        List<BatchNoticeVO> batchNoticeVOS = new LinkedList<>();
        if (!CollectionUtils.isEmpty(userIds)) {
            BatchNoticeVO batchNoticeVO = new BatchNoticeVO();
            batchNoticeVO.setReceivers(new HashSet<>(userIds));
            batchNoticeVO.setMsg(message);
            batchNoticeVOS.add(batchNoticeVO);
            return postBatchSendNotice(batchNoticeVOS, tenantId);
        }
        Set<String> userSet = new HashSet<>();
        taskBizData.forEach(bizData -> {
            Map object = JsonUtil.toObject(JsonUtil.toJsonString(bizData), Map.class);
            Object acceptList = object.get(businessFields);
            if(!Objects.isNull(object.get(businessFields))) {
                if (acceptList instanceof List) {
                    List executorNoList = (List) acceptList;
                    for (Object executorNo : executorNoList) {
                        Set<String> userIdSet = new HashSet<>();
                        try {
                            userIdSet = transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                        } catch (Exception e) {
                            log.error("发送信息失败{}",e);
                        }
                        userSet.addAll(userIdSet);
                    }
                } else if (acceptList instanceof String) {
                    Set<String> userIdSet = new HashSet<>();
                    try {
                        userIdSet = transformToUserId(new HashSet<>(Collections.singletonList(String.valueOf(acceptList))), tenantId);
                    } catch (Exception e) {
                        log.error("发送信息失败{}",e);
                    }
                    userSet.addAll(userIdSet);
                }
            }
        });
        BatchNoticeVO batchNoticeVO = new BatchNoticeVO();
        batchNoticeVO.setReceivers(userSet);
        batchNoticeVO.setMsg(message);
        batchNoticeVOS.add(batchNoticeVO);
        return postBatchSendNotice(batchNoticeVOS, tenantId);
    }

    @SneakyThrows
    @Override
    public Object postMessageHand(List<BacklogVO> taskList, String tenantId, String msg) {
        //获取需要分发的用户已及变量信息
        IdentityHashMap<String, Map<String, Object>> mockPhpHashMap =
            CollectionUtils.isEmpty(taskList) ? new IdentityHashMap<>()
                : getMockPhpHashMap(taskList);
        String token = iamService.getTenantToken(tenantId);
        //重新组装msg消息
        //Set<String> eocIds = mockPhpHashMap.keySet();
        for (Entry<String, Map<String, Object>> outerEntry : mockPhpHashMap.entrySet()) {
          Set<String> userIds = transformToUserId(Stream.of(outerEntry.getKey()).collect(Collectors.toSet()), tenantId);

            Map<String, Object> innerMap = outerEntry.getValue();
            String msgReplace = symbolStringMessage(msg, innerMap);
            if (!CollectionUtils.isEmpty(userIds)) {
                iamService.dispatcherMessage(token, userIds.stream().collect(Collectors.toList()),
                    msgReplace, tenantId);
            }
        }
        return ResultBean.success(null);
    }

    @SneakyThrows
    @Override
    public Object postSendNotice(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields, List<String> userIds) {
        log.warn("开始发送信息：{}", message);
        if(!CollectionUtils.isEmpty(taskBizData)){
            // 正则表达式匹配 ${}
            Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");
            if (!containsExpression(message, pattern)) {
                return degradeToBatchSend(taskBizData, tenantId, message, businessFields, userIds);
            }
            String token = iamService.getTenantToken(tenantId);
            taskBizData.forEach(res->{
                Map object = JsonUtil.toObject(JsonUtil.toJsonString(res), Map.class);
                Object acceptList = object.get(businessFields);
                ObjectMapper objectMapper=new ObjectMapper();
                Map map = objectMapper.convertValue(res, Map.class);
                String msgReplace = symbolStringMessage(message, map);
                if (!CollectionUtils.isEmpty(userIds)) {
                    iamService.dispatcherMessage(token,  userIds, msgReplace, tenantId);
                } else if(!Objects.isNull(object.get(businessFields))){
                    if(acceptList instanceof  List){
                        List  executorNoList=(List)acceptList;
                        for (Object executorNo : executorNoList) {

                            Set<String> userIdSet = null;
                            try {
                                userIdSet = transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                                log.warn("替换后的消息：{}",msgReplace);
                                if(!CollectionUtils.isEmpty(userIdSet)){
                                    iamService.dispatcherMessage(token,  userIdSet.stream().collect(
                                            Collectors.toList()), msgReplace, tenantId);
                                }
                            } catch (Exception e) {
                                log.error("发送信息失败{}",e);
                            }
                        }
                    }
                    /*   */
                }
            });
        }
        return ResultBean.success(null);
    }

    @Override
    public Object postSendNotice(NoticeVO noticeVO) throws Exception {
        if (!CollectionUtils.isEmpty(noticeVO.getGroupFields())) {
            return postSendNoticeByGroup(noticeVO);
        } else {
            return postSendNotice(noticeVO.getTaskBizData(), noticeVO.getTenantId(), noticeVO.getMessage(), noticeVO.getBusinessFields());
        }
    }

    public Object postSendNoticeByGroup(NoticeVO noticeVO) throws Exception {
        if (CollectionUtils.isEmpty(noticeVO.getTaskBizData()) || StringUtils.isEmpty(noticeVO.getMessage())) {
            return null;
        }
//        String message = "预测偏差追踪，${date}预计生产{{FOREACH(${itemNo}数量${number})}}，请确认。";
        // 正则表达式匹配 {{FOREACH(...)}}
        Pattern foreachPattern = Pattern.compile("\\{\\{FOREACH\\((.*?)\\)}}");
        Matcher foreachMatcher = foreachPattern.matcher(noticeVO.getMessage());
        // 查找所有 {{FOREACH(...)}} 匹配项
        // 存储 {{FOREACH(...)}} 匹配到的内容
        StringBuffer foreachContentBuffer = new StringBuffer();
        String itemStr = "";
        if (foreachMatcher.find()) {
            itemStr = foreachMatcher.group(1);
            foreachMatcher.appendReplacement(foreachContentBuffer, "#itemsStr#");
        }
        foreachMatcher.appendTail(foreachContentBuffer);

        // 按照groupFields中所有字段分组，转成map
        Map<String, List<Map<String, Object>>> groupMap = noticeVO.getTaskBizData().stream().collect(Collectors.groupingBy(data -> {
            StringBuilder sb = new StringBuilder();
            for (String groupField : noticeVO.getGroupFields()) {
                // 预防业务数据中没有分组字段的值
                String value = "#placeholeder#";
                if (data.get(groupField) != null && StringUtils.isNotEmpty(data.get(groupField).toString())) {
                    value = data.get(groupField).toString();
                }
                sb.append(value).append(",");
            }
            // 去掉末尾逗号
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }));

        List<BatchNoticeVO> batchNoticeVOS = new ArrayList<>();
        // 遍历groupMap，替换调itemStr中的占位符
        for (Entry<String, List<Map<String, Object>>> entry : groupMap.entrySet()) {
            BatchNoticeVO vo = new BatchNoticeVO();
            String handledMsg = foreachContentBuffer.toString();
            Set<String> receivers = new HashSet<>();
            List<String> replacedItemList = new ArrayList<>();
            for (Map<String, Object> item : entry.getValue()) {
                if (StringUtils.isNotEmpty(itemStr)) {
                    replacedItemList.add(symbolStringMessage(itemStr, item));
                }
                if (CollectionUtils.isEmpty(noticeVO.getUserIds()) && StringUtils.isNotEmpty(noticeVO.getBusinessFields())) {
                    // 界面没选择通知人，则使用业务数据中的字段作为通知人
                    Object o = item.get(noticeVO.getBusinessFields());
                    if (o != null) {
                        if(o instanceof List) {
                            List<String> list = (List<String>) o;
                            receivers.addAll(list);
                        } else {
                            receivers.add(o.toString());
                        }
                    }
                }
            }
            // 默认使用“、”拼接
            handledMsg = handledMsg.replace("#itemsStr#", Joiner.on("、").join(replacedItemList));
            // 替换分组字段
            Map<String, Object> map = new HashMap<>();
            String[] split = entry.getKey().split(",");
            for (int i = 0; i < noticeVO.getGroupFields().size(); i++) {
                map.put(noticeVO.getGroupFields().get(i), "#placeholeder#".equals(split[i]) ? "" : split[i]);
            }
            handledMsg = symbolStringMessage(handledMsg, map);
            vo.setMsg(handledMsg);
            if (!CollectionUtils.isEmpty(noticeVO.getUserIds())) {
                // 界面已经选定通知人，则直接使用
                vo.setReceivers(new HashSet<>(noticeVO.getUserIds()));
            } else {
                vo.setReceivers(receivers);
            }
            batchNoticeVOS.add(vo);

        }
        postBatchSendNotice(batchNoticeVOS, noticeVO.getTenantId());
        return ResultBean.success(null);
    }

    /**
     * 批量发送IM消息
     * @param batchNoticeVOS 消息入参
     * @param tenantId 租户id
     * @return 结果
     */
    @Override
    public Object postBatchSendNotice(List<BatchNoticeVO> batchNoticeVOS, String tenantId) throws Exception {
        log.info("批量发送IM消息，batchNoticeVOS：{}， tenantId：{}", JSON.toJSONString(batchNoticeVOS), tenantId);
        if (!CollectionUtils.isEmpty(batchNoticeVOS)) {
            String token = iamService.getTenantToken(tenantId);
            for (BatchNoticeVO batchNoticeVO : batchNoticeVOS) {
                if (StringUtils.isNotEmpty(batchNoticeVO.getMsg()) && !CollectionUtils.isEmpty(batchNoticeVO.getReceivers())) {
                    iamService.dispatcherMessage(token, new ArrayList<>(batchNoticeVO.getReceivers()), batchNoticeVO.getMsg(), tenantId);
                }
            }
        }
        return ResultBean.success(null);
    }

    @Override
    public Object postFilterByQuantity(List dataList, BusinessCondition businessCondition, ByQuantityCondition quantityCondition) {
        Map<String, Object> query = new HashMap<>();
        query.put("groups", businessCondition.getGroups());
        query.put("dataList", JSONArray.parseArray(JSON.toJSONString(dataList)));
        DapResponse dapResponse = dataMapService.filterListByBusinessCondition(query);
        JSONArray result = (JSONArray) dapResponse.getResponse();
        filterByQuantity(result, quantityCondition);
        return result;
    }

    private void filterByQuantity(JSONArray result, ByQuantityCondition quantityCondition) {
        //实现该方法对result进行过滤,过滤条件为quantityCondition
        if (quantityCondition == null) {
            return;
        }

        String quantityField = quantityCondition.getQuantityField();
        String operator = quantityCondition.getOperator();
        String valueType = quantityCondition.getValueType();

        if (quantityField == null || operator == null || valueType == null) {
            return;
        }

        JSONArray filteredResult = new JSONArray();

        for (int i = 0; i < result.size(); i++) {
            JSONObject obj = result.getJSONObject(i);
            if (obj.containsKey(quantityField)) {
                Object fieldValue = obj.get(quantityField);

                boolean match = false;
                if (valueType.equals("fixed")) {
                    match = checkFixedCondition(fieldValue, quantityCondition.getFixed(), operator);
                } else if (valueType.equals("var")) {
                    match = checkVarCondition(fieldValue, obj, quantityCondition.getVar(), operator);
                }

                if (!match) {
                    filteredResult.add(obj);
                }
            }
        }

        result.clear();
        result.addAll(filteredResult);

    }

    private boolean checkFixedCondition(Object fieldValue, QuantityFixed fixed, String operator) {
        if (fixed == null) {
            return false;
        }

        Object fixedValue;

        switch (operator) {
            case "eq":
                fixedValue = getFixedValue(fixed.getValue().getValueSource(),fixed.getValue().getValue());
                return compare(fieldValue, fixedValue) == 0;
            case "gte":
                fixedValue = getFixedValue(fixed.getValue().getValueSource(),fixed.getValue().getValue());
                return compare(fieldValue, fixedValue) >= 0;
            case "gt":
                fixedValue = getFixedValue(fixed.getValue().getValueSource(),fixed.getValue().getValue());
                return compare(fieldValue, fixedValue) > 0;
            case "lte":
                fixedValue = getFixedValue(fixed.getValue().getValueSource(),fixed.getValue().getValue());
                return compare(fieldValue, fixedValue) <= 0;
            case "lt":
                fixedValue = getFixedValue(fixed.getValue().getValueSource(),fixed.getValue().getValue());
                return compare(fieldValue, fixedValue) < 0;
            case "between":
                Object fromValue = getFixedValue(fixed.getFrom().getValueSource(),fixed.getFrom().getValue());

                Object toValue = getFixedValue(fixed.getTo().getValueSource(),fixed.getTo().getValue());
                return compare(fieldValue, fromValue) >= 0 && compare(fieldValue, toValue) <= 0;
            default:
                return false;
        }
    }

    @Override
    public Map<String, Object> postInvokeEspApi(String espApi, List<Map<String, Object>> requestParams) throws Exception {
        if (espApi.startsWith("esp_")) {
            espApi = espApi.substring(4);
        }
        Map<String, Object> finalRequestParams = new HashMap<>();
        if (requestParams != null && !requestParams.isEmpty()) {
            for (Map<String, Object> each : requestParams) {
                finalRequestParams.putAll(each);
            }
        }
        return espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), espApi, finalRequestParams);
    }

    @Override
    public Map<String, Object> postInvokeEspApiV2(String espApi, String jsonBody, Map<String, Object> eocMap,Map<String, Object> headerMap) throws Exception {
        if (espApi.startsWith("esp_")) {
            espApi = espApi.substring(4);
        }
        return espUtils.executeV2(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), espApi, jsonBody,eocMap,headerMap);
    }

    @Override
    public JSONArray postFilterByTimeCondition(List dataList, BusinessCondition businessCondition, ByTimeCondition byTimeCondition) throws DWBusinessException {
        Map<String, Object> query = new HashMap<>();
        query.put("groups", businessCondition == null ? null : businessCondition.getGroups());
        query.put("dataList", JSONArray.parseArray(JSON.toJSONString(dataList)));
        DapResponse dapResponse = dataMapService.filterListByBusinessCondition(query);
        JSONArray result = (JSONArray) dapResponse.getResponse();
        return filterByTimeCondition(result, byTimeCondition);
    }

    public JSONArray filterByTimeCondition(JSONArray result, ByTimeCondition byTimeCondition) throws DWBusinessException {
        if (byTimeCondition == null || result == null) {
            return result;
        }
        String checkField = byTimeCondition.getCheckField();
        OnTimeCheckRange checkRange = byTimeCondition.getCheckRange();
        Optional<Long> duration = getDuration(byTimeCondition);
        return duration
                .map(timeDuration ->
                        doFilter(result, checkField, checkRange, timeDuration))
                .orElseGet(JSONArray::new);
    }

    private Optional<Long> getDuration(ByTimeCondition byTimeCondition) throws DWBusinessException {
        if (byTimeCondition.getCheckType() == OnTimeCheckType.MECHANISM_PARAMETER) {
            String tenantId = AthenaUtils.getTenantId();
            Object value = iMechanismService.postSelectVariable(byTimeCondition.getCheckVariableCode(), tenantId);
            if (value == null) {
                return Optional.empty();
            }
            long checkNumber = ((Double) Double.parseDouble(value.toString())).longValue();
            return Optional.of(checkNumber * byTimeCondition.getCheckUnit().getFactor());
        }
        return Optional.of(byTimeCondition.getCheckNumber() * byTimeCondition.getCheckUnit().getFactor());
    }

    private JSONArray doFilter(JSONArray result, String checkField, OnTimeCheckRange checkRange, long durationTime) {
        JSONArray filteredResult = new JSONArray();
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < result.size(); i++) {
            JSONObject obj = result.getJSONObject(i);
            if (obj.containsKey(checkField) && obj.get(checkField) != null) {
                Object fieldValue = obj.get(checkField);
                Optional<Long> fieldTime = parseToLongTime(fieldValue);
                if (!fieldTime.isPresent()) {
                    continue;
                }
                if (checkRange == OnTimeCheckRange.BEFORE ? fieldTime.get() - currentTime > durationTime : currentTime - fieldTime.get() > durationTime) {
                    filteredResult.add(obj);
                }
            }
        }
        return filteredResult;
    }

    private static Optional<Long> parseToLongTime(Object fieldValue) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder()
                .appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd[' 'HH:mm:ss]"))
                .appendOptional(DateTimeFormatter.ofPattern("yyyy/MM/dd[' 'HH:mm:ss]"))
                .appendOptional(DateTimeFormatter.ofPattern("dd/MM/yyyy[' 'HH:mm:ss]"))
                .parseDefaulting(java.time.temporal.ChronoField.HOUR_OF_DAY, 0)
                .parseDefaulting(java.time.temporal.ChronoField.MINUTE_OF_HOUR, 0)
                .parseDefaulting(java.time.temporal.ChronoField.SECOND_OF_MINUTE, 0)
                .toFormatter();

        if (fieldValue instanceof Long) {
            return Optional.of((Long) fieldValue);
        }
        if (fieldValue instanceof String) {
            String dateString = (String) fieldValue;
            try {
                return Optional.of(LocalDateTime.parse(dateString, formatter)
                        .atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            } catch (Exception e) {
                log.error("parse time error for value: {}", dateString);
            }
        }
        return Optional.empty();
    }

    /**
     * 获取字段内容
     * @param valueSource 内容值类型,可以是机制参数或者输入的自定义值
     * @param value 机制参数或者输入的自定义值
     * 参考值：
     *       "fixed":{"value":{"value":"2","valueSource":"input"}},
     *       "fixed":{"value":{"value":"codeing_kk","valueSource":"MechanismVariable"}},
     *       "var": { "value": { "calOperator": "+", "quantityField": "student_score", "value": "003", "valueSource": "MechanismVariable" } }
     */
    private Object getFixedValue(String valueSource,String value) {
        Object fixedValue;
        //fixedValue 判断是自定义还是机制变量，做统一处理
        if("MechanismVariable".equals(valueSource)){
            //根据机制变量code 获取value
            try {
                String tenantId = AthenaUtils.getTenantId();
                fixedValue = iMechanismService.postSelectVariable(value, tenantId);
            } catch (DWBusinessException e) {
                //找不到给个空
                fixedValue="";
                log.error("Route==>MechanismEnhancementService method=getValue error:", e);
            }
        }else {
            fixedValue = value;
        }
        return fixedValue;
    }

    private boolean checkVarCondition(Object fieldValue, JSONObject varObj, QuantityVar var, String operator) {
        if (var == null) {
            return false;
        }

        Object varValue;
        switch (operator) {
            case "eq":
                varValue = varObj.get(var.getValue().getQuantityField());
                varValue = applyCalOperator(varValue, var.getValue());
                return compare(fieldValue, varValue) == 0;
            case "gte":
                varValue = varObj.get(var.getValue().getQuantityField());
                varValue = applyCalOperator(varValue, var.getValue());
                return compare(fieldValue, varValue) >= 0;
            case "gt":
                varValue = varObj.get(var.getValue().getQuantityField());
                varValue = applyCalOperator(varValue, var.getValue());
                return compare(fieldValue, varValue) > 0;
            case "lte":
                varValue = varObj.get(var.getValue().getQuantityField());
                varValue = applyCalOperator(varValue, var.getValue());
                return compare(fieldValue, varValue) <= 0;
            case "lt":
                varValue = varObj.get(var.getValue().getQuantityField());
                varValue = applyCalOperator(varValue, var.getValue());
                return compare(fieldValue, varValue) < 0;
            case "between":
                Object fromValue = varObj.get(var.getFrom().getQuantityField());
                Object toValue = varObj.get(var.getTo().getQuantityField());
                fromValue = applyCalOperator(fromValue, var.getFrom());
                toValue = applyCalOperator(toValue, var.getTo());
                return compare(fieldValue, fromValue) >= 0 && compare(fieldValue, toValue) <= 0;
            default:
                return false;
        }
    }
    private int compare(Object a, Object b) {
        // Implement comparison logic
        // Assuming both are of the same type (e.g., Number, String)
        Double aa = Double.parseDouble(a.toString());
        Double bb = Double.parseDouble(b.toString());
        return aa.compareTo(bb);
    }

    private Object applyCalOperator(Object value, QuantityVarDetail quantityVarDetail) {
        // Implement calOperator logic here
        // Assuming value is a Number
        String calOperator = quantityVarDetail.getCalOperator();
        //获取字段内容
        String calValue =null;
        Object fixedValue = getFixedValue(quantityVarDetail.getValueSource(), quantityVarDetail.getValue());
        if(fixedValue!=null){
            calValue =  String.valueOf(fixedValue);
        }
        Double douVal = StringUtils.isEmpty(calValue) ? 0.0 : Double.parseDouble(calValue);
        double doubleValue = Double.parseDouble(value.toString());
        if ("+".equals(calOperator)) {
            // Implement addition logic
            return doubleValue + douVal; // Example: add 1
        } else if ("-".equals(calOperator)) {
            // Implement subtraction logic
            return doubleValue - douVal; // Example: subtract 1
        }
        return value;
    }

    @Override
    public Object postControlBaseData(String code, String tenantId) throws Exception {
        return postControlBaseData(code);
    }

    @Override
    public Object postControlBaseData(String code) throws Exception {
        String tenantIdFromToken = AthenaUtils.getTenantId();
        String token = iamService.getTenantToken(tenantIdFromToken);
        ActivityConfig activityConfig = dataPickService.findOneByCondition(Criteria.where("code").is(code), ActivityConfig.class, "activityConfigs");
        Map<String, Object> dataSources = activityConfig.getDataSources();
        Map dataSource = getRealDataSource(dataSources);
        Preconditions.checkArgument(dataSource.containsKey("actionId"));
        String actionId = (String) dataSource.get("actionId");
        String espServiceName = getServiceNameByActionId(actionId);
        // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(activityConfig.getApplication())) {
            loginInfo.setApplication(activityConfig.getApplication());
        }
        Map<String, Object> result = espUtils.execute(token, tenantIdFromToken, espServiceName, new HashMap<>());
        replaceDateKey(result);
        log.info("invoke result is:{}", result);
        return result;
    }

    private void replaceDateKey(Map<String, Object> map) {
        Map.Entry<String, Object> firstEntry = map.entrySet().iterator().next();

        // 旧的键和值
        String oldKey = firstEntry.getKey();
        Object value = firstEntry.getValue();

        // 删除旧键
        map.remove(oldKey);

        // 插入新键和值
        String newKey = "data";
        map.put(newKey, value);
    }

    private String getServiceNameByActionId(String actionId) throws DWBusinessException {
        if (actionId.startsWith("esp_")) {
            return actionId.substring(4);
        } else {
            throw new DWBusinessException("unsupported action");
        }
    }


    private Map getRealDataSource(Map<String, Object> dataSources) {
        //简单起见,先实现为取第一个
        if (dataSources == null || dataSources.isEmpty()) {
            return Collections.emptyMap();
        }
        return JSON.parseObject(JSON.toJSONString(dataSources.entrySet().iterator().next().getValue()), Map.class);
    }

    public static void main(String[] args) {
        String str1 = "Hello, ${[user]}!";
        String str2 = "Hello, user!";

        // 正则表达式匹配 ${}
        Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");

        // 检查 str1
        boolean contains1 = containsExpression(str1, pattern);
        System.out.println("String 1 contains ${}: " + contains1); // 输出: true

        // 检查 str2
        boolean contains2 = containsExpression(str2, pattern);
        System.out.println("String 2 contains ${}: " + contains2); // 输出: false
    }

    public static boolean containsExpression(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }
    /**
     * 消息模板替换  例如：${task_classification_no}
     * @param msg
     * @param innerMap
     * @return
     */
    private static String symbolStringMessage(String msg, Map<String, Object> innerMap){
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(msg);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            if (innerMap.containsKey(key)) {
                String replacement;
                /*
                    针对于API接口入参传的是55，dap框架转换类型为double，导致在55后面加了.0，不符合期望的业务需求
                    1.短期方案
                        1.1.针对于double类型的参数，做一个取模判断，判断该入参后面的小数点如果都是0，则去除后面的0
                    2.长期方案
                        2.1需要等待po出一个方案，8.21讨论在输入框旁边加类型方便计算
                 */
                if(innerMap.getOrDefault(key, matcher.group()) instanceof Double){
                    Double value= (Double) innerMap.getOrDefault(key, matcher.group());
                    // 将 Double 转换为 String，并去除尾部的多余零
                    replacement = formatValue(value);
                }else {
                    replacement = String.valueOf(innerMap.getOrDefault(key, matcher.group()));
                }

                matcher.appendReplacement(result, replacement);
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    /**
     * 方法使用取模来处理尾部的零部分，同时确保处理多种情况，如 .0、.00 等。
     */
    private static String formatValue(Double value) {

        //value % 1 计算 value 除以 1 的余数。对于整数，余数应为 0，而对非整数，余数则不为 0。
        if (value % 1 == 0) {
            // 如果是整数，返回格式化的整数值
            return String.valueOf(value.intValue());
        }else {

            // 转换为 BigDecimal 以保持原始精度
            BigDecimal bdValue = new BigDecimal(value.toString());
            // 返回原始的 BigDecimal 字符串表示，保留所有小数位
            return bdValue.toString();
        }
    }

    private IdentityHashMap<String, Map<String, Object>> getMockPhpHashMap(List<BacklogVO> taskList) {
        IdentityHashMap<String, Map<String, Object>> mockPhpHashMap = new IdentityHashMap<>();
        BacklogVO backlogVO = taskList.stream().findFirst().orElse(null);
        if (backlogVO != null) {
            Map<String, Object> executeResult = backlogVO.getExecuteResult();
            if (executeResult != null) {
                Object projectInfoObj = executeResult.get(ComponentConstants.PROJECT_INFO);
                // 类型检查，避免ClassCastException
                if (projectInfoObj instanceof List) {
                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) projectInfoObj;
                    dataList.forEach(stringObjectMap -> processExecutorNo(mockPhpHashMap, stringObjectMap));
                }
            }
        }
        return mockPhpHashMap;
    }


    private void processExecutorNo(IdentityHashMap<String, Map<String, Object>> mockPhpHashMap, Map<String, Object> stringObjectMap) {
        Object executorNoObj = stringObjectMap.get(ComponentConstants.EXECUTOR_NO);
        if (executorNoObj instanceof Collection) {
            List<String> executorNoList = (List<String>) executorNoObj;
            executorNoList.forEach(ids -> {
                // 创建新的Map实例以避免修改原始数据
                Map<String, Object> clonedMap = new HashMap<>(stringObjectMap);
                clonedMap.remove(ComponentConstants.EXECUTOR_NO);
                mockPhpHashMap.put(ids, clonedMap);
            });
        }
    }


    /***
     * 按照指定的检测条件进行检查和筛选数据
     * @param taskList
     *        任务列表
     * @param checkAccordingToStandard
     *        按标准完成
     * @return
     */

    private List<BacklogVO> checkFilterTaskData(List<BacklogVO> taskList, CheckAccordingToStandard checkAccordingToStandard,String tenantId) {
        Integer intervalTime = parseTimeValue(checkAccordingToStandard.getStandardPollingRule().getTimeValue());
        List<BacklogVO> taskResult = new LinkedList<>();
        BusinessCondition businessCondition = checkAccordingToStandard.getBusinessCondition();
        List<MechanismConditionGroup> mechanismConditionGroups;
        if (!CollectionUtils.isEmpty(businessCondition.getGroups())) {
            mechanismConditionGroups = businessCondition.getGroups();
            String checkField = checkAccordingToStandard.getCheckField();
            String[] checkFieldArray = checkField.split("\\.");
            String checkFieldHead = checkFieldArray[0];//project_info
            String checkFieldDetails = checkFieldArray[1];//last_report_date
            List<MechanismConditionGroup> finalMechanismConditionGroups = mechanismConditionGroups;
            //将type为2的参数查询机制参数实际值替换到right.to value
            processMechanismConditionGroups(finalMechanismConditionGroups,tenantId);

            taskList.forEach(task -> {
                Map<String, Object> executeResult = task.getExecuteResult();
                if (!CollectionUtils.isEmpty(executeResult)) {
                    // 获取待检查的日期列表
                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) executeResult.get(
                            checkFieldHead);
                    // 获取当前日期
                    LocalDate currentDate = LocalDate.now();
                    // 格式化日期的 DateTimeFormatter
                    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    // 遍历数据列表,保留符合规则的数据
                    dataList.removeIf(data ->
                            checkIfRemoveByData(intervalTime, checkFieldDetails,
                                    currentDate, dateFormatter, data)
                    );
                    dataList.removeIf(
                            data -> checkByRule(finalMechanismConditionGroups, data));
                    if (!CollectionUtils.isEmpty(dataList)) {
                        task.setVariables(null);
                        taskResult.add(task);
                    }
                }
            });
        }
        return taskResult;
    }

    /***
     * 获取任务执行的结果
     * @param taskList
     * @param tenantId
     * @param dataSource
     * @param token
     * @param finalServiceName
     */
    private void fillTaskExecuteResult(List<BacklogVO> taskList, String tenantId, Map<String, Object> dataSource, String token, String finalServiceName) {
        taskList.forEach(task -> {
            try {
                Map<String, Object> variables = task.getVariables();
                Map<String, Object> requestObj = buildRequestObj(variables, dataSource);
                Map<String, Object> executeResult = espUtils.execute(token, tenantId, finalServiceName, requestObj);
                task.setExecuteResult(executeResult);
            } catch (Exception e) {
                log.error("invoke esp error for service:{}, request:{}", finalServiceName, task.getVariables());
            }
        });
    }

    /***
     * 获取服务名
     * @param tenantId
     * @param dataSource
     * @return
     */
    private String getServiceName(String tenantId, Map<String, Object> dataSource) {
        //serviceName
        String actionId = (String) dataSource.get("actionId");
        String serviceName;
        try {
            Map<String, Object> profile = new HashMap<>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
            GetActionLocaleResponseDTO getActionLocaleResponseDTO = (GetActionLocaleResponseDTO) actionService.getMetadata(actionId);
            serviceName = getActionLocaleResponseDTO.getServiceName();
        } catch (Exception e) {
            log.error("getActionError for actionId:{},{}", actionId, e);
            serviceName = degradeToParseByActionId(actionId);
        }
        return serviceName;
    }

    private boolean checkByRule(List<MechanismConditionGroup> mechanismConditionGroups, Map<String, Object> data) {
        HashSet<Object> set = new HashSet<>();
        if (!CollectionUtils.isEmpty(mechanismConditionGroups)) {
            //满足该需求只需支持一条结构
            MechanismConditionGroup mechanismConditionGroup = mechanismConditionGroups.get(0);
            List<MechanismConditionConfig> mechanismConditionConfigs = mechanismConditionGroup.getConditions();
            for (int i = 0; i < mechanismConditionConfigs.size(); i++) {
                MechanismConditionConfig config = mechanismConditionConfigs.get(i);
                String dataType = config.getLeft().getData_type();
                // 获取需要比较的左值和右值
                Object leftValue = extractValue(config.getLeft(), data);
                Object rightValue = extractValue(config.getRight());

                // 根据操作符进行比较
                if (leftValue == null || rightValue == null) {
                    // 如果左值或右值为空，则返回false
                    return false;
                }
                // 获取操作符
                String opType = config.getOpType();

                // 根据操作符进行比较
                switch (opType) {
                    case "eq":
                        set.add(StringUtils.equals(String.valueOf(leftValue),String.valueOf(rightValue))
                                ? Boolean.TRUE : Boolean.FALSE);
                        break;
                    case "gt":
                        return compareValues(dataType, leftValue, rightValue) > 0;
                    case "lt":
                        return compareValues(dataType, leftValue, rightValue) < 0;
                    case "gte":
                        return compareValues(dataType, leftValue, rightValue) >= 0;
                    case "lte":
                        return compareValues(dataType, leftValue, rightValue) <= 0;
                    case "between":
                        // 在范围内，左值小于等于右值且右值小于等于左值
                        return compareValues(dataType, leftValue, rightValue) <= 0 && compareValues(dataType, rightValue, leftValue) <= 0;
                    default:
                        // 如果操作符不匹配任何已知操作符，则返回false
                        return false;
                }
            }
        }
        return set.contains(Boolean.FALSE);
    }

    private Object extractValue(MechanismVariable right) {
        return right.getTo().getValue();
    }

    private Object extractValue(MechanismVariable variable, Map<String, Object> data) {
        // 获取字段路径
        String path = variable.getPath();
        path = path.substring(path.lastIndexOf(".") + 1);
        return data.get(path);
    }

    private int compareValues(String dataType, Object leftValue, Object rightValue) {
        // 这里假设比较的是数字类型，如果需要支持其他数据类型，请根据实际情况进行修改
        switch (dataType) {
            case "string":
                return -1;
            default:
                Double left = Double.parseDouble(leftValue.toString());
                Double right = Double.parseDouble(rightValue.toString());
                return Double.compare(left, right);
        }

    }

    private boolean checkIfRemoveByData(Integer intervalTime, String checkFieldBody, LocalDate currentDate, DateTimeFormatter dateFormatter, Map<String, Object> data) {
        // 获取数据中的日期字符串
        String dateString = String.valueOf(data.get(checkFieldBody));
        // 解析日期字符串为 LocalDate
        LocalDate dataDate = LocalDate.parse(dateString, dateFormatter);
        // 计算日期差
        long daysDiff = java.time.temporal.ChronoUnit.DAYS.between(dataDate, currentDate);
        // 如果日期差大于 interval，则移除该条数据
        boolean ifRemove = Math.abs(daysDiff) < intervalTime;
        return ifRemove;
    }

    private Integer parseTimeValue(String timeValue) {
        try {
            if (timeValue.indexOf(";") != -1) {
                String subStrOfTime = timeValue.substring(0, timeValue.indexOf(";"));
                return Integer.parseInt(subStrOfTime);
            } else {
                return 1;
            }
        } catch (Exception e) {
            return 1;
        }
    }

    private Map<String, Object> buildRequestObj(Map<String, Object> variables, Map<String, Object> dataSource) throws DWBusinessException {
        String actionParamsJSON = JSON.toJSONString(dataSource.get("actionParams"));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actionParamsNode;
        try {
            actionParamsNode = mapper.readTree(actionParamsJSON);
        } catch (IOException e) {
            log.error("parse actionParams error:{}", actionParamsJSON);
            throw new DWBusinessException();
        }

        Map<String, Object> paramMap = new HashMap<>();
        for (JsonNode paramNode : actionParamsNode) {
            String name = paramNode.get("name").asText();
            String type = paramNode.get("type").asText();
            String value = paramNode.get("value").asText();

            if ("PROCESS_VARIABLE".equals(type)) {
                paramMap.put(name, variables.get(value));
            } else if ("CONSTANT".equals(type)) {
                paramMap.put(name, value);
            }
        }
        return paramMap;
    }

    private String degradeToParseByActionId(String actionId) {
        //通过降级方式获取serviceName
        String espPrefix = "esp_";
        if (actionId.startsWith(espPrefix)) {
            return actionId.substring(4);
        }
        return actionId;
    }

    public void processMechanismConditionGroups(
        List<MechanismConditionGroup> mechanismConditionGroups, String tenantId) {
        if (mechanismConditionGroups == null || mechanismConditionGroups.isEmpty()) {
            return;
        }
        //过滤出conditionValueType为机制参数的集合信息
        List<MechanismConditionConfig> mechanismConditionConfigList = mechanismConditionGroups.stream()
            .flatMap(group -> Optional.ofNullable(group.getConditions())
                .map(conditionList -> conditionList.stream())
                .orElseGet(Stream::empty))
            .filter(condition -> condition.getConditionValueType()
                == VariableTypeEnum.VARIABLE_VALUE.getKey())
            .collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(mechanismConditionConfigList)) {
            //塞入机制参数信息
            mechanismConditionConfigList.forEach(
                condition -> processCondition(condition, tenantId));
        }
    }

    private void processCondition(MechanismConditionConfig condition, String tenantId) {
        String variableValue = Optional.ofNullable(
                iMechanismService.postSelectVariable(condition.getVariableCode(), tenantId))
            .orElse(null)
            .toString();
        MechanismVariable mechanismVariable = (MechanismVariable) JSONPath.eval(condition,
            "$.right.to");
        mechanismVariable.setValue(variableValue);
    }

}
