package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kg.action.StartDataEventAction;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleGroup;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMonitorRuleService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.EocMapAndProductDTO;
import com.digiwin.athena.knowledgegraph.service.model.OmMapDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Lang
@MyExceptionHandler
@Service
public class MonitorRuleService implements IMonitorRuleService {

    private static Log log = LogFactory.getLog(ScheduleRuleConfigService.class);
    @Autowired
    private MonitorRuleManager monitorRuleManager;
    @Autowired
    TenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ESPUtils espUtils;

    @Autowired
    ActionRepository actionRepository;

    @Autowired
    private DataMapService dataMapService;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private AppService appService;

    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getQuery(Map<String, Object> conditions, int count, String language) throws Exception {
        return null;
    }

    @Override
    public Object getList(String language) throws Exception {
        return null;
    }

    @Override
    public Object get(String ruleId, String tenantId) throws Exception {
        return get(ruleId, tenantId, "zh_CN");
    }

    @Override
    public Object get(String ruleId, String tenantId, String language) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        //return DWServiceResultBuilder.build(this.monitorRuleManager.get2(ruleId, tenantId));
        return this.monitorRuleManager.get2(ruleId, tenantId, tenantVersion);
    }

    @Override
    public Object postQuery(Map<String, Object> config) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        return this.monitorRuleManager.getMonitorRule(config, tenantVersion);
    }

    @Override
    public List<Map> postOmSiteInfo(EocMapAndProductDTO eocMapAndProduct) throws Exception {
        List<Map> factoriesList = new ArrayList<>();

        String tenantId = AthenaUtils.getTenantId();
        OmMapDTO omMap = monitorRuleManager.getOM(tenantId, eocMapAndProduct.getProductName(), eocMapAndProduct.getEocMap());
        // 地端公司id
        String omCompanyId = omMap.getOmCompanyId() != null ? omMap.getOmCompanyId() : "";
        // 产品对应的uid
        Map re = espUtils.getTenantProductOperationList(tenantId, eocMapAndProduct.getProductName(), false);
        String uid = (String) re.get("uid");
        Map<String, Object> omOperation = espUtils.getOMOperationInfo(tenantId, eocMapAndProduct.getProductName(), uid);
        // 从omOperationInfo中找到属于地端公司id的地端工厂id
        Object companyInfo = JSONPath.eval(omOperation, "intg_info.org_type_company");
        if (ObjectUtils.isEmpty(companyInfo)) {
            return factoriesList;
        }
        List<Map> companyInfoList = (List<Map>) companyInfo;
        companyInfoList.forEach(cil -> {
            if (omCompanyId.equals(cil.get("company_no"))) {
                Object siteInfo = cil.get("org_type_site");
                factoriesKeyMapping(siteInfo, factoriesList);
            }
        });

        return factoriesList;
    }

    @Override
    public Object getDataMapMonitorConfig(String actionId) throws Exception {
        StartDataEventAction action = dataPickService.chooseOneWithSameCode(actionRepository.getDataMapAction(actionId));
        if(null!=action && null!=action.getDataEventId()){
            return dataMapService.geMonitorConfig(action.getDataEventId());
        }
        return null;
    }

    // 地端工厂信息的key映射为云端工厂信息的key（目前只有id和name）
    private void factoriesKeyMapping(Object siteInfo, List<Map> factoriesList) {
        if (!ObjectUtils.isEmpty(siteInfo)) {
            List<Map> siteList = (List<Map>) siteInfo;
            siteList.forEach(s -> {
                Map factoryInfo = new HashMap();
                factoryInfo.put("id", s.get("site_no"));
                factoryInfo.put("name", s.get("site_name"));
                factoriesList.add(factoryInfo);
            });
        }
    }

    @Override
    public Object getTenantMonitor() throws Exception {
        //查询
        return monitorRuleManager.queryAllMonitor();
    }

    @Override
    public Object getAllTenantMonitorRule() throws Exception {
        return monitorRuleManager.getAllTenantMonitorRule();
    }
    @Override
    public Object postInitMonitorRuleGroup(List<InitMonitorRuleGroup> dataList) {
        //初始化数据，数据量小，采用遍历操作
        if(CollectionUtils.isNotEmpty(dataList)){
            dataList.forEach(item->{
                Query query = Query.query(Criteria.where("category").is(item.getCategory()));
                this.mongoTemplateSystem.remove(query, InitMonitorRuleGroup.class);
                this.mongoTemplateSystem.save(item);
            });
        }
        return dataList;
    }

    /**
     * 按照应用返回该应用下的所有的侦测信息
     * @param appCode 应用code
     * @return 侦测信息
     * @throws Exception 抛出异常
     */
    @Override
    public Object getTenantMonitorRuleByApp(String appCode) throws Exception {
        List<ApplicationRelation> relations = appService.getParadigmByTypeAndAppCode("monitorRule", appCode);
        if (CollectionUtils.isEmpty(relations)) {
            return Collections.emptyList();
        }
        // relations转成map，key为code
        List<String> ruleIds = relations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId).and("monitorRuleId").in(ruleIds));
        List<MonitorRuleTenantConfig> monitorRuleTenantConfigs = mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
        // monitorRuleTenantConfigs转成map，key为monitorRuleId，value为list
        if (CollectionUtils.isEmpty(monitorRuleTenantConfigs)) {
            return Collections.emptyList();
        }
        Map<String, List<MonitorRuleTenantConfig>> monitorRuleTenantConfigMap = monitorRuleTenantConfigs.stream().collect(Collectors.groupingBy(MonitorRuleTenantConfig::getMonitorRuleId));
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantName = MapUtils.getString(profile, "tenantName", "");
        List<JSONObject> result = new ArrayList<>();
        for (ApplicationRelation relation : relations) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("appCode", appCode)
                    .fluentPut("appName", relation.getAppName())
                    .fluentPut("ruleId", relation.getCode())
                    .fluentPut("monitorRuleName", relation.getName())
                    .fluentPut("tenantId", tenantId)
                    .fluentPut("tenantName", tenantName);
            if (monitorRuleTenantConfigMap.containsKey(relation.getCode())) {
                List<MonitorRuleTenantConfig> configs = monitorRuleTenantConfigMap.get(relation.getCode());
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : configs) {
                    JSONObject configObj = JSONObject.parseObject(jsonObject.toJSONString());
                    configObj.fluentPut("status", monitorRuleTenantConfig.getStatus())
                            .fluentPut("productName", monitorRuleTenantConfig.getProductName())
                            .fluentPut("standardPollingRule", monitorRuleTenantConfig.getStandardPollingRule())
                            .fluentPut("standardPollingRules", monitorRuleTenantConfig.getStandardPollingRules());
                    if (monitorRuleTenantConfig.getEocMap() != null) {
                        configObj.fluentPut("eocCompanyId", monitorRuleTenantConfig.getEocMap().getEocCompanyId())
                                .fluentPut("eocSiteId", monitorRuleTenantConfig.getEocMap().getEocSiteId());
                    }
                    result.add(configObj);
                }
            } else {
                jsonObject.fluentPut("status", 2)
                        .fluentPut("productName", null)
                        .fluentPut("eocMap", null)
                        .fluentPut("standardPollingRule", null)
                        .fluentPut("standardPollingRules", null);
                result.add(jsonObject);
            }
        }
        return result;
    }
}
