package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kg.activity.Package;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.repository.neo4j.PackageRepository;
import com.digiwin.athena.knowledgegraph.service.IPackageService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
public class PackageService implements IPackageService {

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    PackageRepository packageRepository;

    @Override
    @Deprecated
    //应用闭环将该接口移除
    public List<String> getTenantAll() throws Exception {
        try {
            String tenantId = AthenaUtils.getTenantId();
            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
            List<Package> packages = packageRepository.getTenantPackages(tenantId, "DATA_ENTRY", tenantVersion);
            if (CollectionUtils.isEmpty(packages)) {
                return Collections.emptyList();
            }
            return packages.stream().map(Package::getCode).collect(Collectors.toList());
        } catch (Exception e) {
            // 打印token，用于排查问题
            HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            String token = request.getHeader("token");
            if(null==token){
                token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if(null==token){
                LoginInfo loginInfo = KgFilter.getLoginInfo();
                if(null!=loginInfo){
                    token = loginInfo.getToken();
                }
            }
            log.error("getTenantAll error, token: {}", token, e);
            throw e;
        }
    }
}
