package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.action.*;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.*;
import com.digiwin.athena.kg.report.hz.model.sence.*;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.knowledgegraph.dto.report.PushDataSetDTO;
import com.digiwin.athena.knowledgegraph.dto.report.PushTableDTO;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.pullingMap.model.DataPullingActionDO;
import com.digiwin.athena.knowledgegraph.pullingMap.model.FormulaActionDO;
import com.digiwin.athena.knowledgegraph.pullingMap.model.PullingData;
import com.digiwin.athena.knowledgegraph.pullingMap.model.PullingDataRelation;
import com.digiwin.athena.knowledgegraph.pullingMap.service.EntityAndDependencyGeneratorService;
import com.digiwin.athena.knowledgegraph.report.MonitorPartParser;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.ReportSceneRepository;

import com.digiwin.athena.kg.report.hz.model.ReportMonitorRuleDTO;
import com.digiwin.athena.kg.report.hz.model.SceneDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.DataModelDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.ModelFieldDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.ModelTableDTO;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.knowledgegraph.service.ISceneService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.*;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * @title: SceneService
 * @author: linc
 * @date 2023/12/4 15:05
 * @version: 1.0
 */
@Lang
@Service
@Slf4j
@MyExceptionHandler
public class SceneService implements ISceneService {

    @Autowired
    KgHelpService kgHelpService;

    @Autowired
    private MonitorPartParser monitorPartParser;

    @Autowired
    private ActionRepository actionRepository;

    @Autowired
    private ActionService actionService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    KgInnerService kgInnerService;

    @Value("${iamApToken}")
    private String iamApToken;

    @Autowired
    @Qualifier("cacRestTemplate")
    RestTemplate restTemplate;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    EntityAndDependencyGeneratorService entityAndDependencyGeneratorService;

    @Autowired
    ReportSceneRepository reportSceneRepository;

    @Value("${scrumbiUrl}")
    private String scrumbiUrl;

    @Autowired
    SessionFactory neo4jSessionFactory;

    @Autowired
    ActionMetadataManager actionMetadataManager;

    @Autowired
    CACUtils cacUtils;
    @Autowired
    private DataPickService dataPickService;

    @Autowired
    ScreenService screenService;

    @Autowired
    SectorService sectorService;

    @Autowired
    private CacService cacService;

    @Autowired
    AppService appService;

    @Autowired
    MetricService metricService;

    @Value("${deploy.cloud:''}")
    private String deployCloud;

    // 创建场景图谱
    @Override
    public Object postCreateSceneMaps(ReportSceneDTO reportScene) {
        Map<String, Object> props = new HashMap<>();
        props.put("code", reportScene.getCode());
        String deleteQuery = "match(t:ReportScene) where t.code=$code detach delete t";

        kgHelpService.executeCyhper(deleteQuery, props);

        String createQuery = "CREATE (n:ReportScene {code:$code,actionId:$actionId,scene: $scene, sceneTitle: $sceneTitle, " +
                "showType: $showType, show: $show,version:$version,actionParamDefine:$actionParamDefine," +
                "recast:$recast,intentions:$intentions,incrementalPatch:$incrementalPatch," +
                "useRecast:$useRecast,relatedIntention:$relatedIntention,templateCode:$templateCode," +
                "targetId:$targetId,targetName:$targetName,dimension:$dimension})";

        props.put("actionId", reportScene.getActionId());
        props.put("scene", Objects.isNull(reportScene.getScene()) ? null : JSON.toJSONString(reportScene.getScene()));
        props.put("sceneTitle", reportScene.getSceneTitle());
//        props.put("showType", CollectionUtils.isEmpty(reportScene.getShowType()) ? null : JSON.toJSONString(reportScene.getShowType()));
//        props.put("show", CollectionUtils.isEmpty(reportScene.getShow()) ? null : JSON.toJSONString(reportScene.getShow()));
//        props.put("actionRelation", CollectionUtils.isEmpty(reportScene.getActionRelation()) ? Collections.emptyList() : JSON.toJSONString(reportScene.getActionRelation()));
        props.put("version", StringUtils.isNotEmpty(reportScene.getVersion()) ? reportScene.getVersion() : "2.0");
        props.put("actionParamDefine", CollectionUtils.isEmpty(reportScene.getActionParamDefine()) ? null : JSON.toJSONString(reportScene.getActionParamDefine()));
        props.put("recast", CollectionUtils.isEmpty(reportScene.getRecast()) ? null : JSON.toJSONString(reportScene.getRecast()));

        props.put("intentions", CollectionUtils.isEmpty(reportScene.getIntentions()) ? null : JSON.toJSONString(reportScene.getIntentions()));

        props.put("incrementalPatch", CollectionUtils.isEmpty(reportScene.getIncrementalPatch()) ? null : JSON.toJSONString(reportScene.getIncrementalPatch()));
//        props.put("description",reportScene.getDescription());
        props.put("useRecast", Objects.isNull(reportScene.getUseRecast()) ? true : reportScene.getUseRecast());
        props.put("relatedIntention", reportScene.getRelatedIntention());

        props.put("templateCode", reportScene.getTemplateCode());
        props.put("targetId", reportScene.getTargetId());
        props.put("targetName", reportScene.getTargetName());
        props.put("dimension", reportScene.getDimension());

        kgHelpService.executeCyhper(createQuery, props);
        return "success";
    }

    // 查询场景图谱
    @Override
    public Object postQuerySceneMaps(String code) throws Exception {
        String tenantVersion = kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();
        ReportSceneDTOs reportSceneDTOs = new ReportSceneDTOs();
        ReportSceneDTO reportScene = null;
        ReportSceneDTOs dataSet = mongoTemplate.findOne(Query.query(Criteria.where("version").is(tenantVersion).and("code").is(code)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (Objects.isNull(dataSet)) {
            UserScreenConfig userScreen = screenService.postQueryUserScreen(code);
            if (ObjectUtils.isEmpty(userScreen)) {
                reportScene = querySceneMaps(Collections.singletonList(code), tenantVersion);
            } else {
                reportScene = sectorService.getReportSceneByBkCode(tenantId,userScreen);
            }
            BeanUtil.copyProperties(reportScene, reportSceneDTOs);
        }else {
            reportSceneDTOs = dataSet;
        }

        if (StringUtils.isNotEmpty(reportSceneDTOs.getCode())) {
            // 查询应用的数据源
            String appCode = reportSceneDTOs.getAppCode();
            // 根据appCode和version查询应用的数据来源

            // 大屏场景查询刷新频率
            if (Objects.equals(reportSceneDTOs.getViewType(), "screen")) {
                BigScreenViewConfig bigScreenViewConfig =
                        mongoTemplateUser.findOne(Query.query(Criteria.where("tenantId").is(tenantId)
                                .and("bigScreenCode").is(reportSceneDTOs.getCode())), BigScreenViewConfig.class);
                if (Objects.nonNull(bigScreenViewConfig)) {
                    reportSceneDTOs.setDataFlowFrequency(bigScreenViewConfig.getDataFlowFrequency());
                    reportSceneDTOs.setFlashFrequency(bigScreenViewConfig.getFlashFrequency());
                    reportSceneDTOs.setPageTurningFrequency(bigScreenViewConfig.getPageTurningFrequency());
                }
            }

            Application application = dataPickService.findOneByCondition(Criteria.where("code").is(appCode), Application.class, "application");
            if (application != null && StringUtils.isNotEmpty(application.getSource())) {
                reportSceneDTOs.setDataSource(application.getSource());
                reportSceneDTOs.setBillingGoodsId(StringUtils.isEmpty(application.getBillingGoodsId()) ? "" : application.getBillingGoodsId());
            }
            reportSceneDTOs.setBusinessType(metricService.getBusinessType(reportSceneDTOs));
            // 多语言处理
            return getTranslateContent(reportSceneDTOs);
        }
        return null;
    }

    ReportSceneDTO querySceneMaps(List<String> code, String tenantVersion) throws DWBusinessException {
        List<ReportSceneDTO> reportSceneData = querySceneMapsData(code, tenantVersion);
        if (!CollectionUtils.isEmpty(reportSceneData)) {
            return reportSceneData.get(0);
        }
        return null;
    }

    List<ReportSceneDTO> querySceneMapsData(List<String> code, String tenantVersion) throws DWBusinessException {
        if (CollectionUtils.isEmpty(code)) {
            return null;
        }

        List<String> uniqueAppCodes = getUniqueAppCodes();
        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return null;
        }

        String query = "MATCH (n:ReportScene) WHERE n.code in $code and n.version = $version and n.appCode in $appCode and n.status = '1'  RETURN n";
        Map<String, Object> param = new HashMap<>();
        param.put("code", code);
        param.put("version", tenantVersion);
        param.put("appCode", uniqueAppCodes);

        return querySceneData(query, param);

/*        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();

        List<ReportSceneDTO> reportSceneDTOS = new ArrayList<>();
        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map<String, Object> record = iterator.next();
            Node node = (Node) record.get("n");
            List<Property<String, Object>> propertyList = node.getPropertyList();

            for (Property<String, Object> property : propertyList) {
                setReportSceneProperty(reportScene, property);
            }

            reportSceneDTOS.add(reportScene) ;
        }
        return reportSceneDTOS;*/
    }

    private List<String> getUniqueAppCodes() throws DWBusinessException {
        return dataPickService.tenantInitializedAppCodes(AthenaUtils.getTenantId());
    }

    @Override
    public Object postQuerySceneByTemplateAndTarget(String templateCode, String targetId, List<String> dimension) throws Exception {
        List<ReportSceneDTO> reportSceneList = new ArrayList<>();

        String tenantVersion = kgInnerService.currentTenantVersion();

        List<String> uniqueAppCodes = getUniqueAppCodes();
        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return null;
        }

        // 获取应用对应的计费商品id
        Criteria criteria = Criteria.where("version").is(tenantVersion).and("appType").in(6,12).and("code").in(uniqueAppCodes);
        List<Application> applications = dataPickService.find(criteria, Application.class, "application");
        Map<String, String> applicationCodeToSource = applications.stream()
                .collect(Collectors.toMap(
                        Application::getCode, // keyMapper: 提取key的函数
                        app -> Optional.ofNullable(app.getBillingGoodsId()).orElse("")
                ));

        Map<String, Object> param = new HashMap<>();
        String query = getQueryCql(param, uniqueAppCodes, templateCode, targetId, dimension, tenantVersion);

        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();

        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map<String, Object> record = iterator.next();
            Node node = (Node) record.get("n");
            // 将node转成ReportSceneDTO对象
            List<Property<String, Object>> propertyList = node.getPropertyList();

            for (Property<String, Object> property : propertyList) {
                setReportSceneProperty(reportScene, property);
            }

            reportScene.setBillingGoodsId(applicationCodeToSource.get(reportScene.getAppCode()));

            // 完全匹配所有维度
            if (!CollectionUtils.isEmpty(reportScene.getActionDimension())) {
                // 默认一个数据流
                ActionDimension actionDimension = reportScene.getActionDimension().get(0);
                if (actionDimension.getDimension().size() == dimension.size()) {
                    reportSceneList.add(reportScene);
                }
            } else {
                reportSceneList.add(reportScene);
            }

//            reportSceneList.add(reportScene) ;
        }
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return null;
        } else {
            return getTranslateContent(reportSceneList);
        }

    }

    private String getQueryCql(Map<String, Object> param, List<String> uniqueAppCodes,
                               String templateCode, String targetId, List<String> dimension,
                               String tenantVersion) {
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.templateCode = $templateCode and n.targetId = $targetId and n.version = $version and n.status = '1' ";
        param.put("appCode", uniqueAppCodes);
        param.put("templateCode", templateCode);
        param.put("targetId", targetId);
        param.put("version", tenantVersion);

        // dimension分成有值和空的情况
        if (CollectionUtils.isEmpty(dimension)) {
            query = query + " AND NOT EXISTS(n.dimension) AND NOT EXISTS(n.actionDimension) ";
        } else {
            query = query + " AND (ALL(id IN $dimension WHERE id IN n.dimension) " +
                    "OR ALL(keyword in $keyword WHERE ANY(dim in n.actionDimension WHERE dim CONTAINS keyword)))";
            param.put("dimension", dimension);
            param.put("keyword", dimension);
        }
        query = query + " RETURN n ";
        return query;
    }


    // 多语言处理
    public Object getTranslateContent(Object o) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        if (Objects.equals(deployCloud, "local")) {
            LanguageUtil.processLocaleLanguage(o, localeStr);
            return o;
        }else {
            Object dataStr = translateUtils.translateSmartDataContent(JSON.parseObject(JSON.toJSONString(o, SerializerFeature.DisableCircularReferenceDetect), Object.class));
            LanguageUtil.processLocaleLanguage(dataStr, localeStr);
            return dataStr;
        }
    }

    private void setReportSceneProperty(ReportSceneDTO reportScene, Property<String, Object> property) {
        if (Objects.isNull(property.getValue())) {
            return;
        }

        switch (property.getKey()) {
            case "code":
                reportScene.setCode((String) property.getValue());
                break;
            case "status":
                reportScene.setStatus((String) property.getValue());
                break;
            case "appCode":
                reportScene.setAppCode((String) property.getValue());
                break;
            case "show":
                reportScene.setShow(JSON.parseArray(property.getValue().toString(), Object.class));
                break;
            case "showType":
                reportScene.setShowType(JSON.parseArray(property.getValue().toString(), Object.class));
                break;
            case "actionRelation":
                reportScene.setActionRelation(JSON.parseArray(property.getValue().toString(), ActionRelationDTO.class));
                break;
            case "intentions":
                // 去除字符串中的方括号和空格
                String input = property.getValue().toString().replace("[", "").replace("]", "").replace(" ", "");
                ;
                if (StringUtils.isNoneBlank(input)) {
                    reportScene.setIntentions(Arrays.asList(input.split(",")));
                }
                break;
            case "incrementalPatch":
                reportScene.setIncrementalPatch(JSON.parseArray(property.getValue().toString(), IncrementalPatch.class));
                break;
            case "sceneTitle":
                reportScene.setSceneTitle((String) property.getValue());
                break;
            case "scene":
                reportScene.setScene(JSON.parseObject(property.getValue().toString(), SceneDTO.class));
                break;
            case "actionParamDefine":
                reportScene.setActionParamDefine(JSON.parseObject(property.getValue().toString(), Map.class));
                break;
            case "recast":
                reportScene.setRecast(JSON.parseObject(property.getValue().toString(), Map.class));
                break;
            case "actionId":
                reportScene.setActionId((String) property.getValue());
                break;
            case "targetId":
                reportScene.setTargetId((String) property.getValue());
                break;
            case "targetName":
                reportScene.setTargetName((String) property.getValue());
                break;
            case "templateCode":
                reportScene.setTemplateCode((String) property.getValue());
                break;
            case "templateName":
                reportScene.setTemplateName((String) property.getValue());
                break;
            case "version":
                reportScene.setVersion((String) property.getValue());
                break;
            case "description":
                reportScene.setDescription((String) property.getValue());
                break;
            case "useRecast":
                reportScene.setUseRecast((Boolean) property.getValue());
                break;
            case "relatedIntention":
                List<RelatedIntentionDTO> relatedIntention = JSON.parseArray(property.getValue().toString(), RelatedIntentionDTO.class);
                reportScene.setRelatedIntention(relatedIntention);

                List<String> relatedIntentionList = relatedIntention.stream()
                        .map(RelatedIntentionDTO::getRelatedIntentions)
                        .flatMap(List::stream)
                        .collect(Collectors.toList());

                String relatedIntentionsStr = relatedIntentionList.stream()
                        .collect(Collectors.joining(";"));
                reportScene.setRelatedIntentions(relatedIntentionsStr);
                break;
            case "dimension":
                reportScene.setDimension((List<String>) property.getValue());
                break;
            case "actionDimension":
                List<ActionDimension> actionDimensions = JSON.parseArray(property.getValue().toString(), ActionDimension.class);
                reportScene.setActionDimension(actionDimensions);
                break;
            case "lang":
                reportScene.setLang(JSON.parseObject(property.getValue().toString(), Map.class));
                break;

            case "viewType":
                reportScene.setViewType((String) property.getValue());
                break;
            case "prod":
                reportScene.setProd((String) property.getValue());
                break;
            case "businessType":
                reportScene.setBusinessType(JSON.parseObject(property.getValue().toString(), BusinessTypeDTO.class));
                break;
            case "formula":
                reportScene.setFormula((String) property.getValue());
                break;
            case "fieldSchema":
                reportScene.setFieldSchema(JSON.parseArray(property.getValue().toString(), Object.class));
                break;
            case "productLine":
                reportScene.setProductLine((List<String>) property.getValue());
                break;
            case "classification":
                String valueOf = String.valueOf(property.getValue());
                if (StringUtils.isNotBlank(valueOf)) {
                    Map<String, Object> map = JsonUtils.readValue(valueOf, new TypeReference<Map<String, Object>>() {
                    });
                    reportScene.setClassification(map);
                }
                break;
           /* case "products" :
                List<ReportSceneProductDTO> products = JSON.parseArray(property.getValue().toString(), ReportSceneProductDTO.class);
                ReportSceneProductDTO product = products.get(0);
                Map<String, List<ReportSceneProductDTO>> groupedProductsConfig = products.stream()
                        .collect(Collectors.groupingBy(ReportSceneProductDTO::getProductName));

                String productName = product.getProductName();
                ReportSceneProductDTO productData = groupedProductsConfig.get(productName).get(0);
                List<DataFlowsDTO> dataFlows = productData.getDataFlows();
                for (DataFlowsDTO dataFlow : dataFlows) {
                    reportScene.setActionId(dataFlow.getActionId());
                    reportScene.setShow(dataFlow.getShow());
                    reportScene.setShowType(dataFlow.getShowType());
                }*/

            default:
                // 处理其他未知属性
                break;
        }
    }

    // 场景图谱转换侦测
    @Override
    public Object postCreateMonitorRule(String code, String name, String appCode, String appName, String productName) throws Exception {
        // 获取场景数据进行转换侦测
        Object sceneData = this.postQuerySceneMaps(code);
        if (Objects.nonNull(sceneData)) {
            ReportSceneDTO reportScene = JSON.parseObject(sceneData.toString(), ReportSceneDTO.class);
            ReportMonitorRuleDTO reportMonitorRuleDTO = new ReportMonitorRuleDTO();
            reportMonitorRuleDTO.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            reportMonitorRuleDTO.setName(name);
            reportMonitorRuleDTO.setAppCode(appCode);
            reportMonitorRuleDTO.setAppName(appName);
            reportMonitorRuleDTO.setActionId(reportScene.getActionId());
            reportMonitorRuleDTO.setProductName(productName);

            SceneDTO sceneDTO = reportScene.getScene();
            RuleSceneDTO scene = new RuleSceneDTO();
            scene.setCode(code);
            scene.setTerminal(sceneDTO.getTerminal());
            scene.setWhat(sceneDTO.getWhat());
            scene.setWhen(sceneDTO.getWhen());
            scene.setWhere(sceneDTO.getWhere());
            scene.setWho(sceneDTO.getWho());
            reportMonitorRuleDTO.setScene(scene);

            if (reportScene.getScene() != null && !CollectionUtils.isEmpty(reportScene.getScene().getWhen())) {
                reportMonitorRuleDTO.setStandard_polling_rule(reportScene.getScene().getWhen().get(0));
            }
            reportMonitorRuleDTO.setActionParamDefine(reportScene.getActionParamDefine());
            reportMonitorRuleDTO.setRecast(reportScene.getRecast());
            return monitorPartParser.buildReportMonitorRule(reportMonitorRuleDTO);
        }
        return null;
    }

    // 设计器发版，切版调用
    // 向语义推送action元数据信息
    @Override
    public Object postPushData(List<String> appCodes, String tenantId, String version) {
        Map<String, Object> result = new HashMap<>();
        result.put("code", 200);
        result.put("msg", "success");
        List<PushDataDTO> pushDataDTOS = new ArrayList<>();
        List<PushMetricDTO> pushMetricDTOS = new ArrayList<>();
        List<PushTableDTO> pushMetricDataSetDTOS = new ArrayList<>();
        List<PushDataSetDTO> pushDataSetDTOS = new ArrayList<>();

        try {
            Map<String, Object> profile = new HashMap<>();
            profile.put("tenantId", tenantId);//athenaPaasW AthenaWFPASS E10ATHENApass athenaTestW
            DWServiceContext.getContext().setProfile(profile);
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);

            String tenantVersion = kgInnerService.currentTenantVersion();

            Criteria criteria = new Criteria();
            criteria.and("code").in(appCodes);
            List<Application> applications = dataPickService.find(criteria, Application.class, "application");
            if (CollectionUtils.isEmpty(applications)) {
                return pushDataDTOS;
            }

            List<ReportSceneDTOs> dataSetList = mongoTemplate.find(Query.query(Criteria.where("version").is(tenantVersion).and("appCode").in(appCodes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
            if (CollectionUtils.isEmpty(dataSetList)) {
                // 指标数据处理
                handleMetricData(applications, tenantVersion, pushMetricDTOS);
                // 1.0数据集处理
                handleMetricDataSetData(applications, tenantVersion, pushMetricDataSetDTOS);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("table", pushMetricDataSetDTOS);
                jsonObject.put("metric", pushMetricDTOS);

                // 场景数据处理
                handlePushData(tenantId, version, applications, pushDataDTOS);

                // 调用接口发送数据信息
                Map sceneDataResult = postDataSource(pushDataDTOS, "/scrumbi/pushKMDatas/V2");
                if (!CollectionUtils.isEmpty(sceneDataResult)) {
                    return sceneDataResult;
                }

                Map metricDataResult = postDataSource(jsonObject, "/scrumbi/pushIndicatorData");
                if (!CollectionUtils.isEmpty(metricDataResult)) {
                    return metricDataResult;
                }
            }else {
                // 2.0数据集处理
                handleDataSetData(applications,dataSetList, tenantVersion, pushDataSetDTOS);
                Map dataSetDataResult = postDataSource(pushDataSetDTOS, "/scrumbi/dataSet/push");
                if (!CollectionUtils.isEmpty(dataSetDataResult)) {
                    return dataSetDataResult;
                }
            }

        } catch (Exception e) {
            result.put("code", 500);
            result.put("msg", "km推送语义失败");
            log.error("postPushData error :{}", e);
        } finally {
            Map<String, Object> profile = new HashMap<>();
            profile.put("tenantId", null);//athenaPaasW AthenaWFPASS E10ATHENApass athenaTestW
            DWServiceContext.getContext().setProfile(profile);
            DWServiceContext.getContext().getRequestHeader().remove(tenantId + "tenantVersion", version);
        }
        result.put("scene", pushDataDTOS);
        result.put("metric", pushMetricDTOS);
        result.put("dataset", pushDataSetDTOS);
        log.error("pushData info is token:{},appCodes:{},tenantId:{},version:{}, data:{}", DWServiceContext.getContext().getToken(), appCodes, tenantId, version, result);
        return result;
    }

    private void handlePushData(String tenantId, String version, List<Application> applications, List<PushDataDTO> pushDataDTOS) throws Exception {
        for (Application application : applications) {
            // 查询模板
            List<SceneTemplate> sceneTemplates = mongoTemplate.find(Query.query(Criteria.where("version").is(application.getVersion()).and("application").is(application.getCode())), SceneTemplate.class);

            // 如果模板为空，直接添加PushDataDTO并返回
            if (CollectionUtils.isEmpty(sceneTemplates)) {
                pushDataDTOS.add(createPushDataDTO(application));
                continue;
            }

            // 获取应用对应模板的集合
            Map<String, List<SceneTemplate>> groupedSceneTemplates = sceneTemplates.stream()
                    .collect(Collectors.groupingBy(SceneTemplate::getApplication));

            // 计算应用对应的场景code集合
            Map<String, List<String>> mergedSceneCodesByAppCode = new HashMap<>();
            mergeSceneCodes(mergedSceneCodesByAppCode, groupedSceneTemplates);

            // 如果场景code集合为空，直接添加PushDataDTO
            if (CollectionUtils.isEmpty(mergedSceneCodesByAppCode)) {
                pushDataDTOS.add(createPushDataDTO(application));
            } else {
                // 获取应用对应的场景信息,并设置PushDataDTO
                for (Map.Entry<String, List<String>> entry : mergedSceneCodesByAppCode.entrySet()) {
                    processApplicationScene(pushDataDTOS, entry, groupedSceneTemplates, application, tenantId, version);
                }
            }
        }
    }

    // 创建PushDataDTO的辅助方法
    private PushDataDTO createPushDataDTO(Application application) {
        PushDataDTO pushDataDTO = new PushDataDTO();
        pushDataDTO.setApplicationCode(application.getCode());
        pushDataDTO.setApplicationName(application.getName());
        pushDataDTO.setVersion(application.getVersion());
        return pushDataDTO;
    }


    private void handleMetricData(List<Application> applications, String tenantVersion, List<PushMetricDTO> pushMetricDTOS) throws Exception {
        for (Application application : applications) {
            List<ReportSceneDTO> reportSceneDTOList = this.querySceneByAppAndTag(
                    Collections.singletonList(application.getCode()), "metric", tenantVersion);
            if (CollectionUtils.isEmpty(reportSceneDTOList)) {
                pushMetricDTOS.add(PushMetricDTO.builder()
                        .applicationCode(application.getCode())
                        .applicationName(application.getName())
                        .version(application.getVersion())
                        .build());
            } else {
                handlePushMetricData(pushMetricDTOS, application, reportSceneDTOList);
            }
        }
    }

    private void handleMetricDataSetData(List<Application> applications, String tenantVersion, List<PushTableDTO> pushMetricDTOS) throws Exception {
        for (Application application : applications) {
            List<ReportSceneDTOs> reportSceneDTOList = this.querySceneByAppAndTags(
                    Collections.singletonList(application.getCode()), "dataset", tenantVersion);
            if (CollectionUtils.isEmpty(reportSceneDTOList)) {
                pushMetricDTOS.add(PushTableDTO.builder()
                        .applicationCode(application.getCode())
                        .applicationName(application.getName())
                        .version(application.getVersion())
                        .build());
            } else {
                handlePushTableData(pushMetricDTOS, application, reportSceneDTOList);
            }
        }
    }

    private void handleDataSetData(List<Application> applications,List<ReportSceneDTOs> dataSetList, String tenantVersion, List<PushDataSetDTO> pushDataSetDTOS) throws Exception {
        Map<String, List<ReportSceneDTOs>> reportSceneMap = dataSetList.stream()
                .collect(Collectors.groupingBy(ReportSceneDTOs::getAppCode));
        for (Application application : applications) {
            List<ReportSceneDTOs> reportSceneDTOs = reportSceneMap.get(application.getCode());
            if (CollectionUtils.isEmpty(reportSceneDTOs)) {
                pushDataSetDTOS.add(PushDataSetDTO.builder()
                        .applicationCode(application.getCode())
                        .applicationName(application.getName())
                        .version(application.getVersion())
                        .dataSetDto(new ArrayList<>())
                        .build());
            }else {
                List<PushDataSetDTO.PushDataSetContentDTO> dataSetContentList = new ArrayList<>();
                for (ReportSceneDTOs reportScene : reportSceneDTOs) {
                    /*List<Object> dimensions = reportScene.getDimensions();
                    for (Object dimension : dimensions) {
                        if (dimension instanceof JSONObject) {
                            JSONObject item = (JSONObject) dimension;
                            JSONObject businessType = item.getJSONObject("businessType");
                            if (!ObjectUtils.isEmpty(businessType)) {
                                item.put("businessType", businessType.get("code"));
                            }
                        }
                    }*/
                    List<Object> measures = reportScene.getMeasures();
                    for (Object measure : measures) {
                        if (measure instanceof JSONObject) {
                            JSONObject item = (JSONObject) measure;
                            JSONObject businessType = item.getJSONObject("businessType");
                            if (!ObjectUtils.isEmpty(businessType)) {
                                item.put("businessType", businessType.get("code"));
                            }
                        }
                        if (measure instanceof Map) {
                            Map item = (Map) measure;
                            if (!ObjectUtils.isEmpty(item.get("businessType"))) {
                                Map businessType = (Map) item.get("businessType");
                                item.put("businessType", businessType.get("code"));
                            }
                        }
                    }
                    dataSetContentList.add(PushDataSetDTO.PushDataSetContentDTO.builder()
                            .datasetId(reportScene.getCode())
                            .modelId(reportScene.getModelId())
                            .modelCode(reportScene.getModelCode())
                            .datasetName(reportScene.getName())
                            .lang(reportScene.getLang())
                            .billingGoodsId(application.getBillingGoodsId())
                            .dimensions(reportScene.getDimensions())
                            .measures(reportScene.getMeasures())
                            .description(reportScene.getDescription())
                            .questions(reportScene.getQuestions())
                            .quickQuestion(reportScene.getQuickQuestion())
                            .metrics(reportScene.getMetrics())
                            .modules(reportScene.getModules())
                            .entities(reportScene.getEntities())
                            .build());
                }
                pushDataSetDTOS.add(PushDataSetDTO.builder()
                        .applicationCode(application.getCode())
                        .applicationName(application.getName())
                        .version(application.getVersion())
                        .dataSetDto(dataSetContentList)
                        .build());
            }
        }
    }

    // 组装指标推送的数据
    private void handlePushMetricData(List<PushMetricDTO> pushMetricDTOS,
                                      Application application, List<ReportSceneDTO> reportSceneDTOList) {
        for (ReportSceneDTO reportScene : reportSceneDTOList) {
            pushMetricDTOS.add(PushMetricDTO.builder().metricId(reportScene.getCode())
                    .metricName(reportScene.getSceneTitle())
                    .applicationCode(application.getCode())
                    .applicationName(application.getName())
                    .billingGoodsId(application.getBillingGoodsId())
                    .description(reportScene.getDescription())
                    .prod(reportScene.getProd())
                    .productLine(reportScene.getProductLine())
                    .businessType(Objects.nonNull(reportScene.getBusinessType()) ? reportScene.getBusinessType().getCode() : null)
                    .formula(reportScene.getFormula())
                    .lang(reportScene.getLang())
                    .version(reportScene.getVersion())
                    .fieldSchema(reportScene.getFieldSchema()).build());
        }
    }

    private void handlePushTableData(List<PushTableDTO> pushMetricDTOS,
                                      Application application, List<ReportSceneDTOs> reportSceneDTOList) {
        for (ReportSceneDTOs reportScene : reportSceneDTOList) {
            pushMetricDTOS.add(PushTableDTO.builder().metricId(reportScene.getCode())
                    .metricName(reportScene.getSceneTitle())
                    .applicationCode(application.getCode())
                    .applicationName(application.getName())
                    .billingGoodsId(application.getBillingGoodsId())
                    .description(reportScene.getDescription())
                    .prod(reportScene.getProd())
                    .productLine(reportScene.getProductLine())
                    .formula(reportScene.getFormula())
                    .lang(reportScene.getLang())
                    .version(reportScene.getVersion())
                    .questions(reportScene.getQuestions())
                    .quickQuestion(reportScene.getQuickQuestion())
                    .fieldSchema(reportScene.getFieldSchema())
                    .metrics(reportScene.getMetrics())
                    .modules(reportScene.getModules())
                    .entities(reportScene.getEntities())
                    .build());
        }
    }

    private void mergeSceneCodes(Map<String, List<String>> mergedSceneCodesByAppCode,
                                 Map<String, List<SceneTemplate>> groupedSceneTemplates) {
        groupedSceneTemplates.forEach((appCode, mergedSceneTemplates) -> {
            List<String> mergedSceneCodes = mergedSceneTemplates.stream()
                    .map(SceneTemplate::getTemplateCode)
                    .distinct()
                    .collect(Collectors.toList());
            mergedSceneCodesByAppCode.put(appCode, mergedSceneCodes);
        });
    }

    private void processApplicationScene(List<PushDataDTO> pushDataDTOS,
                                         Map.Entry<String, List<String>> entry,
                                         Map<String, List<SceneTemplate>> groupedSceneTemplates,
                                         Application application,
                                         String tenantId, String version) throws Exception {
        // 根据模板code查询场景信息
        List<ReportSceneDTO> reportScenes = this.querySceneMapsByTemplate(entry.getValue(), application.getCode());
        if (CollectionUtils.isEmpty(reportScenes)) {
            pushDataDTOS.add(createPushDataDTO(application));
            return;
        }

        PushDataDTO pushData = new PushDataDTO();
//                    List<DataSourceDTO> dataSources = new ArrayList<>();
        List<DimensionDTO> dimensions = new ArrayList<>();

        // 设置数据源
//                    List<DataSourceDTO> dataSource = mergeAndDistinct(transMetaData(dataSources, reportScenes, tenantId,dimensions));
//                    pushData.setDatasource(dataSource);

        // 获取模板对应的推荐语句
        Map<String, List<String>> templateIntentionsMap = new HashMap<>();
        List<PushSceneDTO> pushSceneList = new ArrayList<>();
        for (ReportSceneDTO reportSceneDTO : reportScenes) {
            if (!CollectionUtils.isEmpty(reportSceneDTO.getIntentions())) {
                if (templateIntentionsMap.containsKey(reportSceneDTO.getTemplateCode())) {
                    List<String> existingIntentions = templateIntentionsMap.get(reportSceneDTO.getTemplateCode());
                    existingIntentions.addAll(reportSceneDTO.getIntentions());
                    templateIntentionsMap.put(reportSceneDTO.getTemplateCode(), existingIntentions.stream().distinct().collect(Collectors.toList()));
                } else {
                    templateIntentionsMap.put(reportSceneDTO.getTemplateCode(), new ArrayList<>(new HashSet<>(reportSceneDTO.getIntentions())));
                }
            }

            List<DataSourceDTO> dataSource = mergeAndDistinct(
                    transMetaData(new ArrayList<>(),
                            Collections.singletonList(reportSceneDTO),
                            tenantId, dimensions, version));
            // 设置场景
            PushSceneDTO pushScene = PushSceneDTO.builder()
                    .sceneCode(reportSceneDTO.getCode())
                    .sceneTitle(reportSceneDTO.getSceneTitle())
                    .productLine(reportSceneDTO.getProductLine())
                    .targetName(reportSceneDTO.getTargetName())
                    .targetId(reportSceneDTO.getTargetId())
                    .templateCode(reportSceneDTO.getTemplateCode())
                    .templateName(reportSceneDTO.getTemplateName())
                    .schemas(dataSource.get(0).getSchemas())
                    .billingGoodsId(StringUtils.isNotEmpty(application.getBillingGoodsId()) ? application.getBillingGoodsId() : "")
                    .intentions(CollectionUtils.isEmpty(reportSceneDTO.getIntentions()) ?
                            new ArrayList<>() : reportSceneDTO.getIntentions())
                    .dimensionKeys(CollectionUtils.isEmpty(reportSceneDTO.getActionDimension()) ?
                            new ArrayList<>() :
                            reportSceneDTO.getActionDimension().stream().map(ActionDimension::getDimension).flatMap(Collection::stream).distinct().collect(Collectors.toList()))
                    .build();
            pushSceneList.add(pushScene);
        }
        pushData.setScenes(pushSceneList);

        // 设置维度
        List<DimensionDTO> distinctDimensions = dimensions.stream()
                .collect(collectingAndThen(
                        toCollection(() -> new TreeSet<>(Comparator.comparing(DimensionDTO::getName))),
                        ArrayList::new
                ));

        pushData.setDimensions(distinctDimensions);

        // 设置模板
        List<SceneTemplate> templateList = groupedSceneTemplates.get(entry.getKey());
        for (SceneTemplate template : templateList) {
            template.setIntentions(templateIntentionsMap.get(template.getTemplateCode()));
        }
        pushData.setTemplate(templateList);

        // 设置应用code
        pushData.setApplicationCode(application.getCode());

        // 设置应用名称
        pushData.setApplicationName(application.getName());

        pushData.setVersion(application.getVersion());
        pushDataDTOS.add(pushData);
    }

    // 元数据转换平铺
    List<DataSourceDTO> transMetaData(List<DataSourceDTO> dataSources,
                                      List<ReportSceneDTO> reportScenes,
                                      String tenantId,
                                      List<DimensionDTO> dimensions, String version) throws Exception {
        // 获取租户
        for (ReportSceneDTO reportScene : reportScenes) {
            // 查询场景的action
            String[] actionIds = reportScene.getActionId().split(",");

            // 查询action的入参 并转Map
//            List<ActionExecutionParam> actionExecutionParams = mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)), ActionExecutionParam.class);
//            Map<String, List<String>> actionExecutionParamMap = actionExecutionParams.stream().collect(Collectors.toMap(ActionExecutionParam::getActionId, a -> a.getExecutionParam()));

            // 查询所有的action的元数据
            List<GetActionLocaleResponseDTO> metaData = new ArrayList<>();
//            List<ActionLabel> actionAndLabels= actionRepository.getActionAndLabels(actionIds,tenantVersion);
//            for (ActionLabel actionAndLabel : actionAndLabels) {
            List<String> pathActionId = new ArrayList<>();
            for (String actionId : actionIds) {
                // 查pulling action的图谱所有的action
                ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO) actionService.postQueryExecutionPath(actionId, tenantId,
                        new ArrayList<>(), new ArrayList<>());
                List<ActionDefinitionDTO> actionData = pathDTO.getActionMetadatas();
                for (ActionDefinitionDTO meta : actionData) {
//                    metaData.add((GetActionLocaleResponseDTO) actionService.getMetadata(meta.getActionId()));
                    pathActionId.add(meta.getActionId());
                }

                metaData = actionMetadataManager.getActionMetadatas(pathActionId, tenantId, version);

                /*ActionMetadataDTO responseDTO = this.getActionMetadata(actionAndLabel);
                GetActionLocaleResponseDTO localeResponseDTO = JSON.parseObject(JSON.toJSONString(responseDTO),
                        GetActionLocaleResponseDTO.class);
                metaData.add(localeResponseDTO);*/
            }

            // 转换平铺
            DataSourceDTO dataSourceDTO = convertActionDefinitionToDataSource(metaData, reportScene, dimensions);
            dataSourceDTO.setAppCode(reportScene.getAppCode());
            dataSourceDTO.setVersion(reportScene.getVersion());
            dataSources.add(dataSourceDTO);
        }
        return dataSources;
    }

    // 元数据转换平铺
    List<DataSourceDTO> transMetaData111(List<DataSourceDTO> dataSources,
                                         List<ReportSceneDTO> reportScenes,
                                         String tenantId,
                                         List<DimensionDTO> dimensions, String version) throws Exception {
        // 获取租户
        for (ReportSceneDTO reportScene : reportScenes) {
            // 查询场景的action
            String[] actionIds = reportScene.getActionId().split(",");

            // 查询action的入参 并转Map
//            List<ActionExecutionParam> actionExecutionParams = mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)), ActionExecutionParam.class);
//            Map<String, List<String>> actionExecutionParamMap = actionExecutionParams.stream().collect(Collectors.toMap(ActionExecutionParam::getActionId, a -> a.getExecutionParam()));

            // 查询所有的action的元数据
//            List<GetActionLocaleResponseDTO> metaData = new ArrayList<>();
//            List<ActionLabel> actionAndLabels= actionRepository.getActionAndLabels(actionIds,tenantVersion);
//            for (ActionLabel actionAndLabel : actionAndLabels) {
//            List<String> pathActionId = new ArrayList<>();
//            for (String actionId : actionIds) {
//                // 查pulling action的图谱所有的action
//                ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO) actionService.postQueryExecutionPath(actionId, tenantId,
//                        new ArrayList<>() , new ArrayList<>());
//                List<ActionDefinitionDTO> actionData = pathDTO.getActionMetadatas();
//                for (ActionDefinitionDTO meta: actionData) {
////                    metaData.add((GetActionLocaleResponseDTO) actionService.getMetadata(meta.getActionId()));
//                    pathActionId.add(meta.getActionId());
//                }
//
//                metaData.addAll(actionMetadataManager.getActionMetadatas(pathActionId, tenantId, version));
//
//                /*ActionMetadataDTO responseDTO = this.getActionMetadata(actionAndLabel);
//                GetActionLocaleResponseDTO localeResponseDTO = JSON.parseObject(JSON.toJSONString(responseDTO),
//                        GetActionLocaleResponseDTO.class);
//                metaData.add(localeResponseDTO);*/
//            }

            List<GetActionLocaleResponseDTO> dataPullingActions = actionMetadataManager.getActionMetadatas(Arrays.asList(actionIds), tenantId, version);

            List<String> codes = dataPullingActions.stream()
                    .filter(dto -> StringUtils.isNotEmpty(dto.getDataFlowCode()))
                    .map(GetActionLocaleResponseDTO::getDataFlowCode)
                    .collect(Collectors.toList());

            List<GetActionLocaleResponseDTO> metaData = actionMetadataManager.getActionMetadatasByDataFlowCode(codes, tenantId, version);

            // 转换平铺
            DataSourceDTO dataSourceDTO = convertActionDefinitionToDataSource(metaData, reportScene, dimensions);
            dataSourceDTO.setAppCode(reportScene.getAppCode());
            dataSourceDTO.setVersion(reportScene.getVersion());
            dataSources.add(dataSourceDTO);
        }
        return dataSources;
    }

    public EspActionMetadataDTO getActionMetadata(ActionLabel actionAndLabels) throws Exception {
        Action action = actionAndLabels.getAction();
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(action.getActionId());
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());
        metadataDTO.setName(action.getName());
        //去除转义字符
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray(action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));

        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData(JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class));

        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);

        metadataDTO.setSceneNodeType(action.getSceneNodeType());

        return metadataDTO;
    }

    List<ReportSceneDTO> querySceneMapsByTemplate(List<String> templateCode, String appCode) {
        if (CollectionUtils.isEmpty(templateCode)) {
            return null;
        }
        String tenantVersion = kgInnerService.currentTenantVersion();

        Map<String, Object> param = new HashMap<>();
        String query = "MATCH (n:ReportScene) WHERE n.templateCode in $templateCode and n.version = $version and n.appCode = $appCode and n.status = '1' RETURN n";
        param.put("templateCode", templateCode);
        param.put("version", tenantVersion);
        param.put("appCode", appCode);

        return querySceneData(query, param);
    }

    public List<ReportSceneDTO> querySceneData(String query, Map<String, Object> param) {
        List<ReportSceneDTO> reportSceneList = new ArrayList<>();
        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();
        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map<String, Object> record = iterator.next();
            Node node = (Node) record.get("n");
            List<Property<String, Object>> propertyList = node.getPropertyList();

            for (Property<String, Object> property : propertyList) {
                setReportSceneProperty(reportScene, property);
            }
            reportSceneList.add(reportScene);
        }
        return reportSceneList;
    }

    public List<ReportSceneDTOs> querySceneDatas(String query, Map<String, Object> param) {
        List<ReportSceneDTOs> reportSceneList = new ArrayList<>();
        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();
        while (iterator.hasNext()) {
            ReportSceneDTOs reportScene = new ReportSceneDTOs();
            Map<String, Object> record = iterator.next();
            Node node = (Node) record.get("n");
            List<Property<String, Object>> propertyList = node.getPropertyList();

            for (Property<String, Object> property : propertyList) {
                String key = property.getKey();
                Object value = property.getValue();
                setReportScenePropertyUsingReflection(reportScene, key, value);
            }
            reportSceneList.add(reportScene);
        }
        return reportSceneList;
    }

    private void setReportScenePropertyUsingReflection(ReportSceneDTOs reportScene, String key, Object value) {
        try {
            Class<? extends ReportSceneDTOs> clazz = reportScene.getClass();
            Field[] fields = clazz.getDeclaredFields();
            Field targetField = null;
            for (Field field : fields) {
                if (field.getName().equals(key)) {
                    targetField = field;
                    break;
                }
            }

            if (targetField == null || ObjectUtils.isEmpty(targetField)) {
                return;
            }

            targetField.setAccessible(true);
            // 获取字段的类型
            Class<?> fieldType = targetField.getType();

            // 根据字段类型进行类型转换
            Object convertedValue = convertValue(value, fieldType);
            targetField.set(reportScene, convertedValue);
        } catch (IllegalAccessException e) {
            // 处理找不到字段或访问字段时的异常
            log.error("setReportScenePropertyUsingReflection error", e);
        }
    }


    private Object convertValue(Object value, Class<?> targetType) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (value.toString().startsWith("[") && value.toString().endsWith("]") && !value.toString().startsWith("[{")) {
            return value;
        }
        return JSON.parseObject(value.toString(),  targetType);
    }


    @Override
    public Object postRemoveData(String type, String sceneCode) {
        // todo 调用接口删除数据信息
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("type", type);
        paramMap.put("sceneCode", sceneCode);
//        postDataSource(paramMap,"/datasource/delete");
        return "success";


    }

    public List<DataSourceDTO> mergeAndDistinct(List<DataSourceDTO> dataSourceDTOs) {
        Map<String, DataSourceDTO> mergedMap = new HashMap<>();

        for (DataSourceDTO dataSourceDTO : dataSourceDTOs) {
            String datasourceId = dataSourceDTO.getDatasourceId();
            if (mergedMap.containsKey(datasourceId)) {
                DataSourceDTO existing = mergedMap.get(datasourceId);
                List<DataSchemaDTO> mergedSchemas = mergeAndDistinctSchemas(existing.getSchemas(), dataSourceDTO.getSchemas());
                existing.setSchemas(mergedSchemas);

                if (!CollectionUtils.isEmpty(dataSourceDTO.getIntentions())) {
                    List<String> mergedIntentions = CollectionUtils.isEmpty(existing.getIntentions()) ? new ArrayList<>() : new ArrayList<>(existing.getIntentions());
                    mergedIntentions.addAll(dataSourceDTO.getIntentions());
                    List<String> mergedAndDistinctIntentions = mergedIntentions.stream()
                            .distinct()
                            .collect(Collectors.toList());
                    existing.setIntentions(mergedAndDistinctIntentions);
                }

            } else {
                mergedMap.put(datasourceId, dataSourceDTO);
            }
        }

        return new ArrayList<>(mergedMap.values());
    }

    private List<DataSchemaDTO> mergeAndDistinctSchemas(List<DataSchemaDTO> existingSchemas, List<DataSchemaDTO> newSchemas) {
        Map<String, DataSchemaDTO> schemaMap = existingSchemas.stream().collect(Collectors.toMap(DataSchemaDTO::getName, schema -> schema));

        for (DataSchemaDTO newSchema : newSchemas) {
            schemaMap.putIfAbsent(newSchema.getName(), newSchema);
        }

        return new ArrayList<>(schemaMap.values());
    }

    public DataSourceDTO convertActionDefinitionToDataSource(List<GetActionLocaleResponseDTO> actionDefinitions, ReportSceneDTO reportScene, List<DimensionDTO> dimensions) {
        DataSourceDTO dataSource = new DataSourceDTO();
        dataSource.setDatasourceId(reportScene.getTargetId());
        dataSource.setDatasourceName(reportScene.getTargetName());
        /*SceneTargetInfo sceneTargetInfo = this.postQuerySceneTargetInfo(reportScene.getTargetId());
        if (Objects.nonNull(sceneTargetInfo)) {
            dataSource.setSynonym(sceneTargetInfo.getSynonym());
            dataSource.setIntentions(sceneTargetInfo.getIntentions());
        }*/

        dataSource.setIntentions(reportScene.getIntentions());

        List<DataSchemaDTO> schemas = new ArrayList<>();

        for (GetActionLocaleResponseDTO actionDefinition : actionDefinitions) {
            // 只需要入参
            if (actionDefinition.getRequest() != null && !CollectionUtils.isEmpty(actionDefinition.getRequest().getParameters())) {
                for (ApiDataFieldLocaleMetadataDTO param : actionDefinition.getRequest().getParameters()) {
                    schemas.addAll(convertApiDataFieldWithNestedFieldsToSchemas(param));
                }
            }

            /*if (reportScene.getActionId().contains(actionDefinition.getActionId()) && actionDefinition.getResponse() != null && actionDefinition.getResponse().getData() != null && !CollectionUtils.isEmpty(actionDefinition.getResponse().getData().getField())) {
                for (ApiDataFieldLocaleMetadataDTO field : actionDefinition.getResponse().getData().getField()) {
                    schemas.addAll(convertApiDataFieldWithNestedFieldsToSchemas(field));
                }
            }*/
        }

        List<ActionDimension> actionDimensionsData = reportScene.getActionDimension();
        if (!CollectionUtils.isEmpty(actionDimensionsData)) {
            for (ActionDimension actionDimension : actionDimensionsData) {
                List<String> actionDimensions = actionDimension.getDimension();
                for (DataSchemaDTO schemaDTO : schemas) {
                    if (actionDimensions.contains(schemaDTO.getName())) {
                        DimensionDTO dimensionDTO = new DimensionDTO();
                        dimensionDTO.setName(schemaDTO.getName());
                        dimensionDTO.setTitle(schemaDTO.getTitle());
                        dimensions.add(dimensionDTO);
                    }
                }
            }
        }

        dataSource.setSchemas(mergeAndAdjustInputOutput(schemas));
        return dataSource;
    }

    public List<DataSchemaDTO> convertApiDataFieldWithNestedFieldsToSchemas(ApiDataFieldLocaleMetadataDTO apiDataField) {
        // paramType 0:入参，1：出参
        List<DataSchemaDTO> schemas = new ArrayList<>();
        if (!"object".equals(apiDataField.getData_type())) {
            DataSchemaDTO schema = convertApiDataFieldToSchema(apiDataField);
            schemas.add(schema);
        }

        if (!CollectionUtils.isEmpty(apiDataField.getField())) {
            for (ApiDataFieldLocaleMetadataDTO nestedField : apiDataField.getField()) {
                schemas.addAll(convertApiDataFieldWithNestedFieldsToSchemas(nestedField));
            }
        }

        return schemas;
    }

    public DataSchemaDTO convertApiDataFieldToSchema(ApiDataFieldLocaleMetadataDTO apiDataField/*,String paramType*/) {
        DataSchemaDTO schema = new DataSchemaDTO();
        schema.setName(apiDataField.getData_name());
        schema.setTitle(apiDataField.getDescription()/* == null ? "" : JSON.parseObject(apiDataField.getDescription(), JSONObject.class).get("zh_CN").toString()*/);
        schema.setDataType(apiDataField.getData_type());
        /*schema.setRequired(Boolean.parseBoolean(apiDataField.getRequired()));
        schema.setInput(paramType.equals("0"));
        schema.setOutput(paramType.equals("1"));*/
        // 其他字段的映射

        return schema;
    }

/*    public List<DataSchemaDTO> mergeAndAdjustInputOutput(List<DataSchemaDTO> schemaList) {
        JSONObject mergedSchemas = new JSONObject();
        for (DataSchemaDTO schema : schemaList) {
            String name = schema.getName();
            if (mergedSchemas.containsKey(name)) {
                DataSchemaDTO existingSchema = mergedSchemas.getObject(name, DataSchemaDTO.class);
                // 合并属性值完全相同的
                if (schema.getName().equals(existingSchema.getName()) && !Objects.equals(schema.getInput(),existingSchema.getInput())
                        && !Objects.equals(schema.getOutput(),existingSchema.getOutput())) {
                    schema.setInput(true);
                    schema.setOutput(true);
                }
            }
            mergedSchemas.put(name, schema);
        }

        // 将JSONObject转换为List<DataSchemaDTO>
        List<DataSchemaDTO> mergedSchemasList = new ArrayList<>();
        for (String key : mergedSchemas.keySet()) {
            DataSchemaDTO schemaDTO = JSON.parseObject(mergedSchemas.getJSONObject(key).toJSONString(), DataSchemaDTO.class);
            mergedSchemasList.add(schemaDTO);
        }
        return mergedSchemasList;

    }*/

    public List<DataSchemaDTO> mergeAndAdjustInputOutput(List<DataSchemaDTO> schemaList) {
        Map<String, DataSchemaDTO> mergedSchemas = new LinkedHashMap<>(); // 使用 LinkedHashMap 代替 JSONObject

        for (DataSchemaDTO schema : schemaList) {
            String name = schema.getName();
            if (mergedSchemas.containsKey(name)) {
                DataSchemaDTO existingSchema = mergedSchemas.get(name);
                // 合并属性值完全相同的
                if (schema.getName().equals(existingSchema.getName()) && !Objects.equals(schema.getInput(), existingSchema.getInput())
                        && !Objects.equals(schema.getOutput(), existingSchema.getOutput())) {
                    schema.setInput(true);
                    schema.setOutput(true);
                }
            }
            mergedSchemas.put(name, schema);
        }

        return new ArrayList<>(mergedSchemas.values()); // 将 LinkedHashMap 转换为 List
    }

    // 创建action和代表性话术的关系
    @Override
    public Object postCreateActionIntentions(ActionIntentions actionIntentions) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionIntentions.getActionId()));
        Update update = Update.update("intentions", actionIntentions.getIntentions()).set("version", tenantVersion);
        mongoTemplate.upsert(query, update, ActionIntentions.class);
        return "success";
    }

    // 查询action和代表性话术的关系
    @Override
    public List<ActionIntentions> postQueryActionIntentions(List<String> actionIds) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        return mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)
                .and("version").is(tenantVersion)), ActionIntentions.class);
    }


    // 创建action的二次计算定义
    @Override
    public Object postCreateActionRecast(ActionRecast actionRecast) {
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionRecast.getActionId()));
        Update update = Update.update("recast", actionRecast.getRecast());
        mongoTemplate.upsert(query, update, ActionRecast.class);
        return "success";
    }

    // 查询action的二次计算的定义
    @Override
    public List<ActionRecast> postQueryActionRecast(List<String> actionIds) {
        return mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)), ActionRecast.class);
    }

    // 创建action的关系
    @Override
    public Object postCreateActionRelation(ActionRelation actionRelation) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionRelation.getActionId()));
        Update update = Update.update("path", actionRelation.getPath()).set("version", tenantVersion);
        mongoTemplate.upsert(query, update, ActionRelation.class);
        return "success";
    }

    // 查询action关系 并按约定返回数据
    @Override
    public Object postQueryActionRelation(List<String> actionIds) throws Exception {
        List<ActionRelation> actionRelationList = mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)), ActionRelation.class);

        Set<String> rootPath = findRootPath(actionRelationList);

        List<ActionRelationDTO> actionRelationDTOList = new ArrayList<>();
        Map<String, String> isContainMap = new HashMap<>();
        for (String parentPath : rootPath) {
            actionRelationDTOList.addAll(buildActionRelationDTO(actionRelationList, parentPath, isContainMap));
        }

        return assemble(actionRelationDTOList);
    }


    private Set<String> findRootPath(List<ActionRelation> actionRelations) {
        Set<String> allPaths = new HashSet<>();
        Set<String> childPaths = new HashSet<>();

        for (ActionRelation actionRelation : actionRelations) {
            allPaths.add(actionRelation.getPath());
            childPaths.add(actionRelation.getActionId());
        }

        Set<String> rootPaths = new HashSet<>();
        for (String path : allPaths) {
            boolean isRoot = true;
            for (String childPath : childPaths) {
                if (path.contains(childPath) && path.endsWith(childPath)) {
                    isRoot = false;
                    break;
                }
            }
            if (isRoot) {
                rootPaths.add(path);
            }
        }
        return rootPaths;
    }

    private static List<ActionRelationDTO> buildActionRelationDTO(List<ActionRelation> actionRelations, String parentPath, Map<String, String> isContainMap) {
        List<ActionRelationDTO> actionRelationDTOList = new ArrayList<>();
        for (ActionRelation actionRelation : actionRelations) {
            if (actionRelation.getPath().startsWith(parentPath) && Objects.isNull(isContainMap.get(actionRelation.getActionId()))) {
                ActionRelationDTO actionRelationDTO = new ActionRelationDTO();
                actionRelationDTO.setActionId(actionRelation.getActionId());
                actionRelationDTO.setType(actionRelation.getType());
                actionRelationDTO.setSubAction(buildActionRelationDTO(actionRelations, parentPath + (StringUtils.isNotEmpty(parentPath) ? "." : "") + actionRelation.getActionId(), isContainMap));
                actionRelationDTOList.add(actionRelationDTO);
                isContainMap.put(actionRelation.getActionId(), actionRelation.getActionId());
            }
        }
        return actionRelationDTOList;
    }


    public List<ActionRelationDTO> assemble(List<ActionRelationDTO> sceneActionRelation) throws Exception {
        if (CollectionUtils.isEmpty(sceneActionRelation)) {
            return Collections.emptyList();
        }
        List<ActionRelationDTO> assembledActionRelation = new ArrayList<>();
        queryAction(sceneActionRelation, assembledActionRelation);

        return assembledActionRelation;
    }

    private List<ActionRelationDTO> assembleSubActions(List<ActionRelationDTO> subActions) throws Exception {
        List<ActionRelationDTO> assembledSubActions = new ArrayList<>();
        queryAction(subActions, assembledSubActions);
        return assembledSubActions;
    }

    private void queryAction(List<ActionRelationDTO> subActions, List<ActionRelationDTO> assembledSubActions) throws Exception {
        for (ActionRelationDTO subAction : subActions) {
            ActionRelationDTO assembledSubAction = new ActionRelationDTO();
            assembledSubAction.setActionId(subAction.getActionId());
            // 业务中台的modelId
            if ("model".equals(subAction.getType())) {
                assembledSubAction.setAction(this.postModelCenterMetaData(Arrays.asList(subAction.getActionId())));
            } else { // 自己的action
                assembledSubAction.setAction(actionService.getMetadata(subAction.getActionId()));
            }

            List<ActionRelationDTO> assembledNestedSubActions = assembleSubActions(subAction.getSubAction());
            assembledSubAction.setSubAction(assembledNestedSubActions);
            assembledSubActions.add(assembledSubAction);
        }
    }


    // 创建action和场景报表的呈现关系
    @Override
    public Object postCreateActionReportConfig(ActionReportConfig actionReportConfig) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionReportConfig.getActionId()));
        Update update = Update.update("show", actionReportConfig.getShow()).set("showType", actionReportConfig.getShowType()).set("version", tenantVersion);
        mongoTemplate.upsert(query, update, ActionReportConfig.class);
        return "success";
    }

    // 查询action和场景报表的呈现关系
    @Override
    public List<Object> postQueryActionReportConfig(List<String> actionIds) throws IllegalAccessException, NoSuchFieldException, DWBusinessException {
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<ActionReportConfig> actionReportConfigs = mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)
                .and("version").is(tenantVersion)), ActionReportConfig.class);

        if (!CollectionUtils.isEmpty(actionReportConfigs)) {
            return JSON.parseArray(getTranslateContent(actionReportConfigs).toString(), Object.class);
        }
        return Collections.emptyList();
    }


    // 创建场景模板
    @Override
    public Object postCreateSceneTemplate(SceneTemplate sceneTemplate) {
        String tenantVersion = kgInnerService.currentTenantVersion();

        Query query = new Query();
        query.addCriteria(Criteria.where("templateCode").is(sceneTemplate.getTemplateCode()).and("version").is(tenantVersion));

        mongoTemplate.remove(query, SceneTemplate.class);
        sceneTemplate.setVersion(tenantVersion);
        mongoTemplate.save(sceneTemplate);

        return "success";
    }


    // 查询场景模板
    @Override
    public Object postQuerySceneTemplate(List<String> templateCodes) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        return mongoTemplate.find(Query.query(Criteria.where("templateCode").in(templateCodes).and("version").is(tenantVersion)), SceneTemplate.class);
    }


    public SceneTargetInfo postQuerySceneTargetInfo(String targetCode) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        return mongoTemplate.findOne(Query.query(Criteria.where("targetCode").is(targetCode).and("version").is(tenantVersion)), SceneTargetInfo.class);
    }


    // 查询资产中心模型数据的元数据
    @Override
    public List<GetActionLocaleResponseDTO> postModelCenterMetaData(List<String> modelIds) throws IOException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();

        String url = "https://bmd-dmsc-001-hz-test.apps.digiwincloud.com.cn/restful/service/dataModel/semantic/modelMeta";
        Map<String, Object> params = new HashMap<>();
        params.put("ids", modelIds);
        DapResponse response = Utils.postJson(url, Utils.requiredMapHeaders(), params, DapResponse.class);
        JSONObject result = (JSONObject) response.getResponse();
        List<DataModelDTO> respModelDTO = JSON.parseArray(result.get("data").toString(), DataModelDTO.class);

        List<GetActionLocaleResponseDTO> metadataDTOS = new ArrayList<>();
        for (DataModelDTO dataModelDTO : respModelDTO) {
            List<ModelTableDTO> dataTables = dataModelDTO.getTables();
            if (!CollectionUtils.isEmpty(dataTables)) {
                for (ModelTableDTO modelTableDTO : dataTables) {
                    ActionMetadataDTO metadataDTO = new ActionMetadataDTO();
                    ActionResponseMetadataDTO actionResponseMetadataDTO = new ActionResponseMetadataDTO();
                    ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
                    apiDataFieldMetadataDTO.setData_name(modelTableDTO.getCode());
                    apiDataFieldMetadataDTO.setData_type("object");
                    apiDataFieldMetadataDTO.setRequired("true");

                    List<ApiDataFieldMetadataDTO> field = new ArrayList<>();
                    List<ModelFieldDTO> dataFields = modelTableDTO.getFields();
                    if (!CollectionUtils.isEmpty(dataFields)) {
                        apiDataFieldMetadataDTO.setIs_array(true);
                        for (ModelFieldDTO modelFieldDTO : dataFields) {
                            MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
                            multiLanguageDTO.setZh_CN(modelFieldDTO.getName());
                            ApiDataFieldMetadataDTO apiDataFieldMetadataFieldDTO = new ApiDataFieldMetadataDTO();
                            apiDataFieldMetadataFieldDTO.setData_name(modelFieldDTO.getOriginalCode());
                            apiDataFieldMetadataFieldDTO.setData_type(convertDataTypeValue(modelFieldDTO.getDataType()));
                            apiDataFieldMetadataFieldDTO.setDescription(multiLanguageDTO);
                            apiDataFieldMetadataFieldDTO.setIs_array(false);
                            field.add(apiDataFieldMetadataFieldDTO);
                        }
                    }
                    apiDataFieldMetadataDTO.setField(field);
                    actionResponseMetadataDTO.setData(apiDataFieldMetadataDTO);
                    metadataDTO.setActionId(dataModelDTO.getId().toString());
                    metadataDTO.setName(dataModelDTO.getName());
                    metadataDTO.setResponse(actionResponseMetadataDTO);
                    metadataDTO.setRequest(new ActionRequestMetadataDTO());
                    GetActionLocaleResponseDTO localeResponseDTO = JSON.parseObject(JSON.toJSONString(metadataDTO),
                            GetActionLocaleResponseDTO.class);
                    //给requestApiFieldMetadata多语言重新赋值，租户产品字段精度赋值
                    MetadataTranslator.translateField(localeResponseDTO, metadataDTO, localeStr, null);
                    metadataDTOS.add(localeResponseDTO);
                }
            }
        }
        return metadataDTOS;
    }

    private String convertDataTypeValue(int value) {
        switch (value) {
            case 0:
                return "string";
            case 1:
                return "date";
            case 2:
                return "int";
            case 3:
                return "numeric";
            case 4:
                return "boolean";
            default:
                return "string"; // 默认
        }
    }


    public Map postDataSource(Object data, String url) {
        String apiMetadataUrl = scrumbiUrl + url;
        Map<String, Object> resultMap = new HashMap<>();
        try {
            HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
//            headers.add("token", AthenaUtils.getHeaderToken());
            HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity(data, headers);
            ResponseEntity<Map> res = restTemplate.postForEntity(apiMetadataUrl, httpEntity, Map.class);
            if (!"200".equals(res.getBody().get("code").toString())) {
                return res.getBody();
            }
        } catch (Exception e) {
            log.error("push data error : {}", e);
            resultMap.put("code", "500");
            resultMap.put("msg", "语义报错，请联系管理员！");
            return resultMap;
        }

        return null;
    }

    @Override
    public Object getCreatePullingDataMap() throws DWBusinessException {
        List<PullingData> pullingDataList = mongoTemplate.find(Query.query(Criteria.where("transStatus").is("1")), PullingData.class);
        List<String> actionIds = new ArrayList<>();
        if (CollectionUtils.isEmpty(pullingDataList)) {
            return "";
        }

        String tenantId = AthenaUtils.getTenantId();
        for (PullingData pullingData : pullingDataList) {
            String actionId = pullingData.getActionId();
            String nameSpace = pullingData.getNameSpace();

            String executeScript = getExecuteCreateNodeScript(pullingData);
            if (StringUtils.isNotEmpty(executeScript)) {
                // 删除已存在的
                Map<String, Object> props = new HashMap<>();
                props.put("actionId", actionId);
                String deleteQuery = "match(t:Action) where t.actionId=$actionId detach delete t";
                kgHelpService.executeCyhper(deleteQuery, props);

                // 创建action
                kgHelpService.executeCyhper(executeScript, new HashMap<>());
                String tenantActionScript = String.format("MATCH (a:TenantEntity{tenantId: '%s'})\n" +
                        "MATCH (b:Action{actionId:'%s'})\n" +
                        "CREATE (a)-[:ACTION]->(b)", tenantId, actionId);
                // 创建action和租户的关系
                kgHelpService.executeCyhper(tenantActionScript, new HashMap<>());
                entityAndDependencyGeneratorService.BuildOne(actionId, nameSpace);
            }
            actionIds.add(actionId);
        }

        for (PullingData pullingData : pullingDataList) {
            Query query = new Query();
            query.addCriteria(Criteria.where("actionId").is(pullingData.getActionId()));
            Update update = Update.update("transStatus", "0");
            mongoTemplate.upsert(query, update, PullingData.class);
        }

        return "success";
    }

    @Override
    public Object getCreatePullingDataRelation() {
        List<PullingDataRelation> pullingDataList = mongoTemplate.find(Query.query(Criteria.where("transStatus").is("1")), PullingDataRelation.class);
        if (!CollectionUtils.isEmpty(pullingDataList)) {
            for (PullingDataRelation pullingDataRelation : pullingDataList) {
                // 删除已存在的MapsTo关系
                String deleteQuery = String.format("match(a:Action)-[:Requires]->(ae:DataEntity)-->(ad:DataField)-[r:MapsTo]->(bd:DataField)\n" +
                                "where a.actionId = '%s'  \n" +
                                "delete r",
                        pullingDataRelation.getFromActionId());
                kgHelpService.executeCyhper(deleteQuery, new HashMap<>());

                deleteQuery = String.format("match(a:Action)-[:Requires]->(ad:DataField)-[r:MapsTo]->(bd:DataField)\n" +
                                "where a.actionId = '%s'  return r",
                        pullingDataRelation.getFromActionId());
                kgHelpService.executeCyhper(deleteQuery, new HashMap<>());

                // 创建关系
                String executeScript = String.format("match(a:Action)-[:Requires]->(ae:DataEntity)-[:Contains*0..3]->(ad:DataField) \n" +
                                "match(b:Action)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) \n" +
                                "where ad.name=bd.name and a.actionId = '%s' and b.actionId = '%s'  \n" +
                                "merge (ad)-[:MapsTo]->(bd)",
                        pullingDataRelation.getFromActionId(), pullingDataRelation.getToActionId());
                kgHelpService.executeCyhper(executeScript, new HashMap<>());

                executeScript = String.format("match(a:Action)-[:Requires]->(ad:DataField) \n" +
                                "match(b:Action)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) \n" +
                                "where ad.name=bd.name and a.actionId = '%s' and b.actionId = '%s'  \n" +
                                "merge (ad)-[:MapsTo]->(bd)",
                        pullingDataRelation.getFromActionId(), pullingDataRelation.getToActionId());
                kgHelpService.executeCyhper(executeScript, new HashMap<>());

                Query query = new Query();
                query.addCriteria(Criteria.where("fromActionId").is(pullingDataRelation.getFromActionId()).and("toActionId").is(pullingDataRelation.getToActionId()));
                Update update = Update.update("transStatus", "0");
                mongoTemplate.upsert(query, update, PullingDataRelation.class);
            }
        }
        return "success";
    }

    private String getExecuteCreateNodeScript(PullingData pullingData) {
        String script = null;
        String actionId = pullingData.getActionId();
        String type = pullingData.getType();
        String nameSpace = pullingData.getNameSpace();
        String querySchema = pullingData.getQuerySchema();
        String expression = pullingData.getExpression();
        String target = pullingData.getTarget();
        String microTrans = pullingData.getMicroTrans();
        String name = pullingData.getName();
        List<ApiDataFieldMetadataDTO> requestParams = pullingData.getRequestData();
        ApiDataFieldMetadataDTO processVar_output = pullingData.getResponseData();
        if (StringUtils.isNotEmpty(type)) {
            switch (type) {
                case "DATA_PULLING":
                    script = DataPullingActionDO.builder()
                            .actionId(actionId)
                            .name(name)
                            .request(requestParams)
                            .response(processVar_output)
                            .sceneNodeType(StringUtils.isNotEmpty(pullingData.getSceneNodeType()) ? pullingData.getSceneNodeType() : "1")
                            .build().GeneratePullDataCreateScript(nameSpace);
                    break;
                case "BMD_GENERAL":
                    script = DataPullingActionDO.builder()
                            .actionId(actionId)
                            .name(name)
                            .request(requestParams)
                            .response(processVar_output)
                            .build().GenerateBmdCreateScript(nameSpace, querySchema);
                    break;
                case "BMD":
                    script = DataPullingActionDO.builder()
                            .actionId(actionId)
                            .name(name)
                            .request(requestParams)
                            .response(processVar_output)
                            .sceneNodeType(StringUtils.isNotEmpty(pullingData.getSceneNodeType()) ? pullingData.getSceneNodeType() : "")
                            .build().GenerateBmdNewCreateScript(nameSpace, pullingData.getSpName());
                    break;
                case "FormulaAction":
                    script = FormulaActionDO.builder()
                            .actionId(actionId)
                            .name(name)
                            .request(requestParams)
                            .response(processVar_output)
                            .expression(expression).target(target)
                            .build().GenerateFormulaCreateScript(nameSpace);
                    break;
                case "MICRO_TRANS":
                    script = DataPullingActionDO.builder()
                            .actionId(actionId)
                            .name(name)
                            .request(requestParams)
                            .response(processVar_output)
                            .build().GenerateMicroTransCreateScript(nameSpace, microTrans);
                    break;
                default:
                    script = null;
            }
        }
        return script;
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction()) {
            for (String cql : executeNeo4jScripts) {
                session.query(cql, new HashMap<>());
            }
            transaction.commit();
        } catch (Exception e) {
            log.error("executeNeo4jScript updateSceneShow error:{}", e);
        }
        session.clear();
    }


    // 获取场景的schema
    public Object getSceneSchema(String sceneCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.currentTenantVersion();
        ReportSceneDTO reportScene = querySceneMaps(Collections.singletonList(sceneCode), tenantVersion);
        if (Objects.isNull(reportScene)) {
            return null;
        }
        return mergeAndDistinct(transMetaData(new ArrayList<>(), Collections.singletonList(reportScene), tenantId, new ArrayList<>(), tenantVersion));
    }

    @Override
    public Object postQuerySceneIntention() throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        List<TargetIntentionsDTO> targetIntentionsDTOList = new ArrayList<>();

        List<ReportSceneDTO> reportSceneList = querySceneMapsDataByAppCode();
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return targetIntentionsDTOList;
        }

        // 将reportSceneList数据根据targetName分组，并将intentions合并在一起
        Map<String, List<String>> groupedIntentions = getIntentionsByTargetName(reportSceneList);
        if (CollectionUtils.isEmpty(groupedIntentions)) {
            return targetIntentionsDTOList;
        }

        // 对groupedIntentions中的targetName进行排序
        List<String> sortedTargetIds = groupedIntentions.keySet().stream()
                .sorted()
                .collect(Collectors.toList());

        // 处理并封装targetIntentionsDTOList
        setIntentionsByTargetName(groupedIntentions, sortedTargetIds, targetIntentionsDTOList);
        return getTranslateContent(targetIntentionsDTOList);
    }

    @Override
    public Object postQuerySceneIntentions() throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        List<TargetIntentionsDTO> targetIntentionsDTOList = new ArrayList<>();

        List<ReportSceneDTO> reportSceneList = querySceneMapsDataByAppCode();
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return targetIntentionsDTOList;
        }

        // 将reportSceneList数据根据targetName和场景code分组，并将intentions合并在一起
        Map<String, Map<String, List<String>>> groupedIntentions = getIntentionsByTargetNameAndCode(reportSceneList);
        if (CollectionUtils.isEmpty(groupedIntentions)) {
            return targetIntentionsDTOList;
        }

        // 对groupedIntentions中的targetName进行排序
        List<String> sortedTargetIds = groupedIntentions.keySet().stream()
                .sorted()
                .collect(Collectors.toList());

        // 处理并封装targetIntentionsDTOList
        setIntentionsByTargetNameAndCode(groupedIntentions, sortedTargetIds, targetIntentionsDTOList);
        return getDistinctData(getTranslateContent(targetIntentionsDTOList));
    }


    private List<ReportSceneDTO> querySceneMapsDataByAppCode() throws DWBusinessException {
        List<ReportSceneDTO> reportSceneDTOS = new ArrayList<>();

//        List<String> uniqueAppCodes = getUniqueAppCodes();
        String userId = AthenaUtils.getUserId();
        if (StringUtils.isEmpty(userId)) {
            throw new DWBusinessException("userId is empty");
        }

        // 获取用户对应的应用列表
        List<String> uniqueAppCodes = cacUtils.getAppAuth(userId);

        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return reportSceneDTOS;
        }

        String tenantVersion = kgInnerService.currentTenantVersion();

        Map<String, Object> param = new HashMap<>();
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.status = '1'  RETURN n";
        param.put("appCode", uniqueAppCodes);
        param.put("version", tenantVersion);

        return querySceneData(query, param);

/*        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();

        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map<String, Object> record = iterator.next();
            Node node = (Node) record.get("n");
            List<Property<String, Object>> propertyList = node.getPropertyList();

            for (Property<String, Object> property : propertyList) {
                setReportSceneProperty(reportScene, property);
            }
            reportSceneDTOS.add(reportScene) ;
        }
        return reportSceneDTOS;*/
    }

    private Map<String, List<String>> getIntentionsByTargetName(List<ReportSceneDTO> reportSceneList) {
        // 将reportSceneList数据根据targetName分组，并将intentions合并在一起
        return reportSceneList.stream()
                .filter(dto -> StringUtils.isNotEmpty(dto.getTargetName()))
                .collect(Collectors.groupingBy(
                        ReportSceneDTO::getTargetName, // 根据targetName分组
                        Collectors.mapping(ReportSceneDTO::getIntentions, Collectors.reducing(new ArrayList<>(), (l1, l2) -> {
                            List<String> result = new ArrayList<>(l1); // 创建一个新列表，将 l1 的内容加入其中
                            if (!CollectionUtils.isEmpty(l2)) {
                                result.addAll(l2); // 将 l2 的内容加入其中
                            }
                            return result; // 返回合并后的列表
                        }))
                ));
    }

    public void setIntentionsByTargetName(Map<String, List<String>> groupedIntentions,
                                          List<String> sortedTargetIds,
                                          List<TargetIntentionsDTO> targetIntentionsDTOList) {
//        Random rand = new Random();
        List<String> randomIntentions;

        for (String sortedTargetId : sortedTargetIds) {
            // 获取随机targetId对应的intentions
            randomIntentions = groupedIntentions.get(sortedTargetId);
            if (CollectionUtils.isEmpty(randomIntentions)) {
                continue;
            }

            IntentionsDTO intentionsDTO = new IntentionsDTO();
            intentionsDTO.setIntention(randomIntentions.get(0/*rand.nextInt(randomIntentions.size()))*/));

            TargetIntentionsDTO targetIntentionsDTO = new TargetIntentionsDTO();
            targetIntentionsDTO.setTargetName(sortedTargetId);
            targetIntentionsDTO.setIntentions(Collections.singleton(intentionsDTO));
            targetIntentionsDTOList.add(targetIntentionsDTO);
        }
    }

    private Map<String, Map<String, List<String>>> getIntentionsByTargetNameAndCode(List<ReportSceneDTO> reportSceneList) {
        // 将reportSceneList数据根据targetName和code分组，并将intentions合并在一起
        return reportSceneList.stream()
                .filter(dto -> StringUtils.isNotEmpty(dto.getTargetName()))
                .collect(Collectors.groupingBy(
                        ReportSceneDTO::getTargetName, // 根据targetName分组
                        Collectors.groupingBy(ReportSceneDTO::getCode, // 第二级分组：根据code分组
                                Collectors.mapping(ReportSceneDTO::getIntentions, Collectors.reducing(new ArrayList<>(), (l1, l2) -> {
                                    List<String> result = new ArrayList<>(l1); // 创建一个新列表，将 l1 的内容加入其中
                                    if (!CollectionUtils.isEmpty(l2)) {
                                        result.addAll(l2); // 将 l2 的内容加入其中
                                    }
                                    return result; // 返回合并后的列表
                                }))
                        )
                ));
    }

    public void setIntentionsByTargetNameAndCode(Map<String, Map<String, List<String>>> groupedIntentions,
                                                 List<String> sortedTargetIds,
                                                 List<TargetIntentionsDTO> targetIntentionsDTOList) {
        /*Random rand = new Random();*/
        for (String sortedTargetId : sortedTargetIds) {
            Map<String, List<String>> codeIntentionsMap = groupedIntentions.get(sortedTargetId);
            ;
            Set<IntentionsDTO> intentionsDTOList = new HashSet<>();
            TargetIntentionsDTO targetIntentionsDTO = new TargetIntentionsDTO();
            for (Map.Entry<String, List<String>> codeIntentionsEntry : codeIntentionsMap.entrySet()) {
                List<String> intentions = codeIntentionsEntry.getValue();
                if (CollectionUtils.isEmpty(intentions)) {
                    continue;
                }

                IntentionsDTO intentionsDTO = new IntentionsDTO();
                intentionsDTO.setIntention(intentions.get(0/*rand.nextInt(intentions.size())*/));
                intentionsDTOList.add(intentionsDTO);
            }
            if (CollectionUtils.isEmpty(intentionsDTOList)) {
                continue;
            }
            targetIntentionsDTO.setTargetName(sortedTargetId);
            targetIntentionsDTO.setIntentions(intentionsDTOList);
            targetIntentionsDTOList.add(targetIntentionsDTO);
        }
    }

    // 例句去重
    private Object getDistinctData(Object data) {
        if (Objects.isNull(data)) {
            return new JSONArray();
        }
        JSONArray jsonArray = JSON.parseArray(data.toString());
        // 使用Java Stream API进行优化处理
        return jsonArray.stream()
                .map(obj -> processIntentions((JSONObject) obj))
                .collect(Collectors.toCollection(JSONArray::new));

    }

    private JSONObject processIntentions(JSONObject obj) {
        if (!obj.containsKey("intentions") || CollectionUtils.isEmpty(obj.getJSONArray("intentions"))) {
            return obj; // 早期返回，避免不必要的处理
        }

        JSONArray intentions = obj.getJSONArray("intentions");
        Map<JSONObject, JSONObject> langIntentionsMap = new HashMap<>();

        for (int i = 0; i < intentions.size(); i++) {
            JSONObject intention = intentions.getJSONObject(i);
            JSONObject lang = intention.getJSONObject("lang");

            // 优化：使用lang作为key时，考虑lang对象的equals和hashCode实现
            // 为避免数据覆盖，可以对value进行合并处理或采取其他策略
            langIntentionsMap.put(lang, intention);
        }

        // 使用stream将map转换为JSONArray，同时可以在此处对数据进行进一步处理或排序
        JSONArray uniqueIntentions = langIntentionsMap.values().stream()
                .collect(Collectors.toCollection(JSONArray::new));

        obj.put("intentions", uniqueIntentions);
        return obj;
    }


    List<ReportSceneDTO> querySceneByAppAndTag(List<String> appCodes, String viewType, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(appCodes)) {
            return null;
        }

        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.viewType = $viewType and n.status = '1'  RETURN n";
        Map<String, Object> param = new HashMap<>();
        param.put("appCode", appCodes);
        param.put("viewType", viewType);
        param.put("version", tenantVersion);

        List<ReportSceneDTO> dataList = querySceneData(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        return JSON.parseArray(JSON.toJSONString(this.getTranslateContent(dataList)), ReportSceneDTO.class);
    }

    List<ReportSceneDTOs> querySceneByAppAndTags(List<String> appCodes, String viewType, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(appCodes)) {
            return null;
        }

        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.viewType = $viewType and n.status = '1'  RETURN n";
        Map<String, Object> param = new HashMap<>();
        param.put("appCode", appCodes);
        param.put("viewType", viewType);
        param.put("version", tenantVersion);

        List<ReportSceneDTOs> dataList = querySceneDatas(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        return JSON.parseArray(JSON.toJSONString(this.getTranslateContent(dataList)), ReportSceneDTOs.class);
    }


    List<ReportSceneDTO> querySceneByCodeAndTag(List<String> code, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(code)) {
            return null;
        }
        String query = "MATCH (n:ReportScene) WHERE n.code in $code and n.version = $version and n.viewType = 'screen' and n.status = '1'  RETURN n";
        Map<String, Object> param = new HashMap<>();
        param.put("code", code);
        param.put("version", tenantVersion);
        List<ReportSceneDTO> dataList = querySceneData(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }

        return JSON.parseArray(JSON.toJSONString(this.getTranslateContent(dataList)), ReportSceneDTO.class);
    }

    @Override
    public Object postQuerySceneByTenantId(String tenantId) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<String> authorizationsAppCodes = cacService.getAuthorizationsApplication(tenantId);
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.status = '1'  RETURN n.code as code";
        Map<String, Object> param = new HashMap<>();
        param.put("appCode", authorizationsAppCodes);
        param.put("version", tenantVersion);

        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult = result.queryResults();
        return StreamSupport.stream(iterableResult.spliterator(), false)
                .map(map -> map.get("code"))
                .filter(Objects::nonNull)
                .distinct()
                .collect(Collectors.toList());
    }


    @Override
    public Object postQueryApplicationByCode(String code) throws Exception {
        String tenantVersion = kgInnerService.currentTenantVersion();
        UserScreenConfig userScreen = screenService.postQueryUserScreen(code);
        List<String> appCodes = new ArrayList<>();
        if (ObjectUtils.isEmpty(userScreen)) {
            ReportSceneDTO reportScene = querySceneMaps(Collections.singletonList(code), tenantVersion);
            if (!ObjectUtils.isEmpty(reportScene)) {
                appCodes.add(reportScene.getAppCode());
            }
        } else {
            List<Map> sectorList = sectorService.getSectorByCode(Arrays.asList(userScreen.getBkCode().split(",")), tenantVersion);
            appCodes.addAll(sectorList.stream()
                    .map(map -> map.get("appCode"))
                    .filter(Objects::nonNull)
                    .map(Object::toString)
                    .distinct()
                    .collect(Collectors.toList()));
        }

        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyList();
        }

        return appService.getApplicationsByCodes(appCodes);
    }

    @Override
    public Object postQueryDataSetsByApp(String appCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<String> permissionCodes = screenService.getUserPermissionScreen(userId, new ArrayList<>(), Collections.singletonList(appCode));
        if (CollectionUtils.isEmpty(permissionCodes)) {
            return Collections.emptyList();
        }

        List<ReportSceneDTOs> dataSetList = mongoTemplate.find(Query.query(Criteria.where("version").is(tenantVersion).and("code").in(permissionCodes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty(dataSetList)) {
            return Collections.emptyList();
        }

/*        List<Object> commandIntentions = new ArrayList<>();
        for (ReportSceneDTOs dataSet : dataSetList) {
            Map<String, Object> dataSetInfo = new HashMap<>();
            dataSetInfo.put("name", dataSet.getName());
            dataSetInfo.put("questions", dataSet.getQuestions());
            dataSetInfo.put("code", dataSet.getCode());
            dataSetInfo.put("lang", dataSet.getLang());
            dataSetInfo.put("modelId", dataSet.getModelId());
            dataSetInfo.put("dimensions", dataSet.getDimensions());
            dataSetInfo.put("measures", dataSet.getMeasures());
            commandIntentions.add(dataSetInfo);
        }*/
        LanguageUtil.processLocaleLanguage(dataSetList, DWResourceBundleUtils.getCurrentLocale().toString());
        return dataSetList;
    }

}