package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.service.IScheduleRuleService;
import org.bson.Document;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Lang
@Service
@Deprecated
public class ScheduleRuleService implements IScheduleRuleService {

    @Override
    public Object getQuery(Map<String, Object> conditions, int count, String language) throws Exception {
        ScheduleRuleConfigService srv = new ScheduleRuleConfigService();
        DWServiceResult re;
        if (conditions != null && conditions.containsKey("tenantId")) {//如果条件中包含tenantId则先查符合条件的租户
            re = (DWServiceResult) srv.getQuery((String) conditions.get("tenantId"), count);
            conditions.remove("tenantId");
        }else {//查询所有租户的配置
            re = (DWServiceResult) srv.getQuery(null, count);
        }

        List<Map<String, Object>> results = new ArrayList<>();
        if (re.getSuccess() && re.getData() != null) {
            String[] configs = (String[])re.getData();
            for (String strCfg : configs) {
                Document config = Document.parse(strCfg);
                String tenantId = (String) config.get("tenantId");
                String ruleId = (String) config.get("ruleId");

                //trigger中的description需要按language做多语言处理
                Document trigger = null;
                if (config.get("trigger") != null) {
                    trigger = (Document) config.get("trigger");
                }

                StringBuffer sbCondition = new StringBuffer();
                if (conditions != null && conditions.size() > 0) {
                    for (Map.Entry<String, Object> c : conditions.entrySet()) {
                        if (c.getValue().getClass().equals(String.class)) {
                            sbCondition.append("and r.");
                            sbCondition.append(c.getKey());
                            sbCondition.append("='");
                            sbCondition.append(c.getValue());
                            sbCondition.append("' ");
                        } else {
                            sbCondition.append("and r.");
                            sbCondition.append(c.getKey());
                            sbCondition.append("=");
                            sbCondition.append(c.getValue());
                            sbCondition.append(" ");
                        }
                    }
                }

                Map<String, Object> result = this.queryRuleAction(ruleId, tenantId, trigger, sbCondition.toString());
                if (result != null) {//不存在排程信息则不增加记录
                    results.add(result);
                }
            }
        }

        Object r;
        if(results.size() > 0) {
            r = results;
        }else {
            r = null;
        }
        return r;
    }

    @Override
    public Object getList(String language) throws Exception {
        return this.getQuery(null, -1, language);
    }

    @Override
    public Object get(String ruleId, String tenantId, String language) throws Exception {
        ScheduleRuleConfigService srv = new ScheduleRuleConfigService();
        DWServiceResult r = (DWServiceResult) srv.get(ruleId, tenantId);
        Map<String, Object> result = null;
        if (r.getSuccess() && r.getData() != null && !((String)r.getData()).isEmpty()) {//查询有租户数据 返回相关排程
            Document trigger = null;
            Document config = Document.parse((String) r.getData());
            if (config.get("trigger") != null) {//trigger中的description需要按language做多语言处理
                trigger = (Document)config.get("trigger");
            }

            result = queryRuleAction(ruleId, tenantId, trigger, "");
        }

        //return DWServiceResultBuilder.build(true, result);
        return result;
    }

    private Map<String, Object> queryRuleAction(String ruleId, String tenantId, Document trigger, String condition) {
        String sql = String.format("match (r:ScheduleRule)-[rel:USE]->(a:Action) where r.ruleId='%s' %s return r,a", ruleId, condition);

        Map<String, Object> result = null;
        List<Map<String, Object>> re = Neo4jManager.getNeo4jManager().ExecuteQuery(sql);
        if (re.size() == 1) {//如果没有查到排程规则 返回null
            Map<String, Object> ra = re.get(0);
            if (ra.size() == 2) {
                Object rule = ra.get("r");
                result = new HashMap<>();
                result.put("ruleId", ruleId);
                result.put("tenantId", tenantId);
                if (rule instanceof Map) {
                    Map<String, Object> ruleMap = (Map<String, Object>) rule;
                    result.put("type", ruleMap.get("type"));
                    if (trigger == null) {//不存在配置则用默认trigger
                        String triggerJson = (String) ruleMap.get("defaultTrigger");//默认trigger必须是json对象字符串
                        if (triggerJson != null && !triggerJson.isEmpty()) {//default trigger不为null 则应用
                            result.put("trigger", Document.parse(triggerJson));
                        }
                    } else {
                        result.put("trigger", trigger);
                    }
                }
                Object action = ra.get("a");
                if (rule instanceof Map) {
                    Map<String, Object> actionMap = (Map<String, Object>) action;
                    result.put("actionId", actionMap.get("actionId"));
                    //需要按language做多语言处理
                    result.put("actionDescription", actionMap.get("description"));
                }
            }
        }

        return result;
    }
}
