package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.service.ISetService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.set.PartParserService;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.TaskCardPart;
import com.mongodb.client.model.Filters;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @title: SetService
 * @description: SetService
 * @author: linc
 * @date 2023/8/15 8:52
 * @version: 1.0
 */

@Lang
@Service
@Slf4j
@MyExceptionHandler
public class SetService implements ISetService {
    @Autowired
    private PartParserService partParserService;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private KgHelpService kgHelpService;
    public static Map<String, List<String>> mongoTables = new HashMap<>();
    public static List<String> neo4jTables;

    static {
        mongoTables.put("knowledgegraphSystem", Arrays.asList("applicationRelation", "monitorRuleProductConfig",
                "parts", "parts", "variableDefinition"));
        mongoTables.put("datamap", Arrays.asList("activity", "task", "project", "pageView", "flowGraph",
                "dataDescription", "dataState"));
        mongoTables.put("tagSystem", Arrays.asList("taggingData"));
        mongoTables.put("preset", Arrays.asList("rules"));
        neo4jTables = Arrays.asList("MonitorRule", "Action", "DataEntity", "DataField", "Tag", "RelatedObject");
    }

    /***
     * 随心控，开发平台嗲你发布的时候，调用此方法
     * @param setsList
     *      开发平台推送过来的相关套件的json信息
     * @return
     * @throws DWBusinessException
     */
    @Override
    public Object postCompileAndSaveSets(List<Sets> setsList) throws DWBusinessException {
        log.info("postCompileAndSaveSets:{}", JSON.toJSONString(setsList));
        if (!CollectionUtils.isEmpty(setsList)) {
            for (Sets sets : setsList) {
                String operate = sets.getOperate();
                SetParseContext context = new SetParseContext(sets);
//                if ("delete".equalsIgnoreCase(operate)) {
//                    postDeleteSets(sets.getCode(), null);
//                    partParserService.parseOperatePart(context, sets.getS().getPart());
//                    continue;
//                }
                preProcess(context, sets);
                postDeleteSets(sets.getCode(), sets.getVersion());
                partParserService.parsePart(context, sets.getS().getPart());
                partParserService.parsePart(context, sets.getU().getPart());
                partParserService.parsePart(context, sets.getA().getPart());
            }
        }
        return "success";
    }

    private void preProcess(SetParseContext context, Sets sets) {
        Query partQuery = Query.query(Criteria.where("pluginId").is(sets.getCode()).and("type").is("smartAdjustProject"));
        TaskCardPart oldAPart = mongoTemplateSystem.findOne(partQuery, TaskCardPart.class, "parts");
        if (oldAPart != null) {
            // 保存上次的邮件通知
            context.setEnableEmailNotice(oldAPart.getEnableEmailNotice());
            context.setEmailNotices(oldAPart.getEmailNotices());
        }
    }

    /***
     * 根据套件code和对应的版本删除相关随心控的套件信息
     * @param code
     * 套件编码
     * @param version
     * 版本号
     * @return
     */
    public Object postDeleteSets(String code, String version) {
        if (StringUtils.isEmpty(code)) {
            return "ok";
        }
        mongoTables.forEach((db, tables) -> {
            tables.forEach(table -> {
                if (StringUtils.isEmpty(version)) {
                    mongoTemplateSystem.getMongoDbFactory().getDb(db).getCollection(table).deleteMany(Filters.eq(
                            "pluginId", code));
                } else {
                    mongoTemplateSystem.getMongoDbFactory().getDb(db).getCollection(table).deleteMany(Filters.and(Filters.eq("pluginId", code), Filters.eq("version", version)));
                }
            });
        });

        Map<String, Object> param = new HashMap<>();
        param.put("pluginId", code);
        param.put("version", version);
        neo4jTables.forEach(table -> {
            String cypher;
            if (StringUtils.isEmpty(version)) {
                cypher = "match(t:" + table + ") where t.pluginId = $pluginId detach delete t";
            } else {
                cypher = "match(t:" + table + ") where t.pluginId = $pluginId and t.version = $version detach delete t";
            }
            kgHelpService.executeCyhper(cypher, param);
        });
        return "ok";
    }
}
